/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_583;
import net.minecraft.class_630;
import org.lwjgl.opengl.GL11;
import xaero.common.AXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.XaeroMinimapSession;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.CustomVertexConsumers;
import xaero.common.graphics.ImprovedFramebuffer;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.common.graphics.shader.MinimapShaders;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.MinimapInterface;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.radar.MinimapRadar;
import xaero.common.minimap.radar.MinimapRadarList;
import xaero.common.minimap.radar.category.EntityRadarCategory;
import xaero.common.minimap.radar.category.setting.EntityRadarCategorySettings;
import xaero.common.minimap.region.MinimapChunk;
import xaero.common.minimap.render.MinimapRenderer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.radar.EntityIcon;
import xaero.common.minimap.render.radar.EntityIconManager;
import xaero.common.minimap.render.radar.EntityIconPrerenderer;
import xaero.common.minimap.waypoints.render.WaypointsGuiRenderer;
import xaero.common.minimap.write.MinimapWriter;
import xaero.common.misc.Misc;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModSettings;

public class MinimapFBORenderer
extends MinimapRenderer {
    private ImprovedFramebuffer scalingFramebuffer;
    private ImprovedFramebuffer rotationFramebuffer;
    private EntityIconManager entityIconManager;
    private boolean triedFBO;
    private boolean loadedFBO;
    private boolean[] usableBoolean = new boolean[1];
    private boolean[] usableBoolean2 = new boolean[1];

    public MinimapFBORenderer(AXaeroMinimap modMain, class_310 mc, WaypointsGuiRenderer waypointsGuiRenderer, MinimapInterface minimapInterface) {
        super(modMain, mc, waypointsGuiRenderer, minimapInterface);
    }

    public void loadFrameBuffer(MinimapProcessor minimapProcessor) {
        if (!minimapProcessor.canUseFrameBuffer()) {
            MinimapLogs.LOGGER.info("FBO mode not supported! Using minimap safe mode.");
        } else {
            this.scalingFramebuffer = new ImprovedFramebuffer(512, 512, false);
            this.rotationFramebuffer = new ImprovedFramebuffer(512, 512, true);
            this.rotationFramebuffer.method_1232(9729);
            this.loadedFBO = this.scalingFramebuffer.field_1476 != -1 && this.rotationFramebuffer.field_1476 != -1;
            this.entityIconManager = new EntityIconManager(this.modMain, new EntityIconPrerenderer(this.modMain));
        }
        this.triedFBO = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void renderChunks(XaeroMinimapSession minimapSession, class_4587 matrixStack, MinimapProcessor minimap, int mapSize, int bufferSize, float sizeFix, float partial, int lightLevel, boolean useWorldMap, boolean lockedNorth, int shape, double ps, double pc, boolean cave, boolean circle, ModSettings settings, CustomVertexConsumers cvc) {
        MinimapWriter minimapWriter = minimap.getMinimapWriter();
        synchronized (minimapWriter) {
            this.renderChunksToFBO(minimapSession, matrixStack, minimap, (class_1657)this.mc.field_1724, this.mc.method_1560(), bufferSize, mapSize, sizeFix, partial, lightLevel, true, useWorldMap, lockedNorth, shape, ps, pc, cave, circle, cvc);
        }
        this.scalingFramebuffer.bindDefaultFramebuffer(class_310.method_1551());
        GlStateManager._viewport((int)0, (int)0, (int)class_310.method_1551().method_22683().method_4489(), (int)class_310.method_1551().method_22683().method_4506());
        this.rotationFramebuffer.method_35610();
    }

    public void renderChunksToFBO(XaeroMinimapSession minimapSession, class_4587 matrixStack, MinimapProcessor minimap, class_1657 player, class_1297 renderEntity, int bufferSize, int viewW, float sizeFix, float partial, int level, boolean retryIfError, boolean useWorldMap, boolean lockedNorth, int shape, double ps, double pc, boolean cave, boolean circle, CustomVertexConsumers cvc) {
        int drawX;
        double zInsidePixel;
        MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers = minimapSession.getMultiTextureRenderTypeRenderers();
        double maxVisibleLength = lockedNorth || shape == 1 ? (double)viewW : (double)viewW * Math.sqrt(2.0);
        double halfMaxVisibleLength = maxVisibleLength / 2.0;
        double radiusBlocks = maxVisibleLength / 2.0 / this.zoom;
        double playerX = minimap.getEntityRadar().getEntityX(renderEntity, partial);
        double playerZ = minimap.getEntityRadar().getEntityZ(renderEntity, partial);
        int xFloored = OptimizedMath.myFloor(playerX);
        int zFloored = OptimizedMath.myFloor(playerZ);
        int playerChunkX = xFloored >> 6;
        int playerChunkZ = zFloored >> 6;
        int offsetX = xFloored & 0x3F;
        int offsetZ = zFloored & 0x3F;
        boolean zooming = (double)((int)this.zoom) != this.zoom;
        this.scalingFramebuffer.method_1235(true);
        GL11.glClear((int)16640);
        GlStateManager._enableTexture();
        class_308.method_24210();
        long before = System.currentTimeMillis();
        GlStateManager._clear((int)256, (boolean)class_310.field_1703);
        this.helper.defaultOrtho();
        class_4587 shaderMatrixStack = RenderSystem.getModelViewStack();
        shaderMatrixStack.method_22903();
        shaderMatrixStack.method_34426();
        before = System.currentTimeMillis();
        double xInsidePixel = minimap.getEntityRadar().getEntityX(renderEntity, partial) - (double)xFloored;
        if (xInsidePixel < 0.0) {
            xInsidePixel += 1.0;
        }
        if ((zInsidePixel = minimap.getEntityRadar().getEntityZ(renderEntity, partial) - (double)zFloored) < 0.0) {
            zInsidePixel += 1.0;
        }
        float halfWView = (float)viewW / 2.0f;
        float angle = (float)(90.0 - this.getRenderAngle(lockedNorth));
        RenderSystem.enableBlend();
        shaderMatrixStack.method_22904(256.0, 256.0, -2000.0);
        shaderMatrixStack.method_22905((float)this.zoom, (float)this.zoom, 1.0f);
        RenderSystem.applyModelViewMatrix();
        class_332.method_25294((class_4587)matrixStack, (int)-256, (int)-256, (int)256, (int)256, (int)-16777216);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_4597.class_4598 renderTypeBuffers = cvc.getBetterPVPRenderTypeBuffers();
        class_4588 overlayBufferBuilder = renderTypeBuffers.getBuffer(CustomRenderTypes.MAP_CHUNK_OVERLAY);
        float chunkGridAlphaMultiplier = 1.0f;
        int minX = playerChunkX + (int)Math.floor(((double)offsetX - radiusBlocks) / 64.0);
        int minZ = playerChunkZ + (int)Math.floor(((double)offsetZ - radiusBlocks) / 64.0);
        int maxX = playerChunkX + (int)Math.floor(((double)(offsetX + 1) + radiusBlocks) / 64.0);
        int maxZ = playerChunkZ + (int)Math.floor(((double)(offsetZ + 1) + radiusBlocks) / 64.0);
        if (useWorldMap) {
            chunkGridAlphaMultiplier = this.modMain.getSupportMods().worldmapSupport.getMinimapBrightness();
            this.modMain.getSupportMods().worldmapSupport.drawMinimap(minimapSession, matrixStack, this.getHelper(), xFloored, zFloored, minX, minZ, maxX, maxZ, zooming, this.zoom, overlayBufferBuilder, multiTextureRenderTypeRenderers);
        } else if (minimap.getMinimapWriter().getLoadedBlocks() != null && level >= 0) {
            int loadedLevels = minimap.getMinimapWriter().getLoadedLevels();
            chunkGridAlphaMultiplier = loadedLevels <= 1 ? 1.0f : 0.375f + 0.625f * (1.0f - (float)level / (float)(loadedLevels - 1));
            int loadedMapChunkX = minimap.getMinimapWriter().getLoadedMapChunkX();
            int loadedMapChunkZ = minimap.getMinimapWriter().getLoadedMapChunkZ();
            int loadedWidth = minimap.getMinimapWriter().getLoadedBlocks().length;
            boolean slimeChunks = this.modMain.getSettings().getSlimeChunks(minimapSession.getWaypointsManager());
            minX = Math.max(minX, loadedMapChunkX);
            minZ = Math.max(minZ, loadedMapChunkZ);
            maxX = Math.min(maxX, loadedMapChunkX + loadedWidth - 1);
            maxZ = Math.min(maxZ, loadedMapChunkZ + loadedWidth - 1);
            MultiTextureRenderTypeRenderer multiTextureRenderTypeRenderer = multiTextureRenderTypeRenderers.getRenderer(t -> RenderSystem.setShaderTexture((int)0, (int)t), MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.GUI_BILINEAR);
            MinimapRendererHelper helper = this.getHelper();
            for (int X = minX; X <= maxX; ++X) {
                int canvasX = X - minimap.getMinimapWriter().getLoadedMapChunkX();
                for (int Z = minZ; Z <= maxZ; ++Z) {
                    int canvasZ = Z - minimap.getMinimapWriter().getLoadedMapChunkZ();
                    MinimapChunk mchunk = minimap.getMinimapWriter().getLoadedBlocks()[canvasX][canvasZ];
                    if (mchunk == null) continue;
                    int texture = mchunk.bindTexture(level);
                    if (!mchunk.isHasSomething() || level >= mchunk.getLevelsBuffered() || texture == 0) continue;
                    if (!zooming) {
                        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                    } else {
                        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                    }
                    drawX = (X - playerChunkX) * 64 - offsetX;
                    int drawZ = (Z - playerChunkZ) * 64 - offsetZ;
                    helper.prepareMyTexturedColoredModalRect(matrixStack.method_23760().method_23761(), drawX, drawZ, 0, 64, 64.0f, 64.0f, -64.0f, 64.0f, texture, 1.0f, 1.0f, 1.0f, 1.0f, multiTextureRenderTypeRenderer);
                    if (!slimeChunks) continue;
                    for (int t2 = 0; t2 < 16; ++t2) {
                        if (mchunk.getTile(t2 % 4, t2 / 4) == null || !mchunk.getTile(t2 % 4, t2 / 4).isSlimeChunk()) continue;
                        int slimeDrawX = drawX + 16 * (t2 % 4);
                        int slimeDrawZ = drawZ + 16 * (t2 / 4);
                        helper.addColoredRectToExistingBuffer(matrixStack.method_23760().method_23761(), overlayBufferBuilder, slimeDrawX, slimeDrawZ, 16, 16, -2142047936);
                    }
                }
            }
            multiTextureRenderTypeRenderers.draw(multiTextureRenderTypeRenderer);
        }
        if (this.modMain.getSettings().chunkGrid > -1) {
            int i;
            class_4588 lineBufferBuilder = renderTypeBuffers.getBuffer(CustomRenderTypes.MAP_LINES);
            int grid = ModSettings.COLORS[this.modMain.getSettings().chunkGrid];
            int r = grid >> 16 & 0xFF;
            int g = grid >> 8 & 0xFF;
            int b = grid & 0xFF;
            MinimapShaders.FRAMEBUFFER_LINES.setFrameSize(this.scalingFramebuffer.field_1480, this.scalingFramebuffer.field_1477);
            float red = (float)r / 255.0f;
            float green = (float)g / 255.0f;
            float blue = (float)b / 255.0f;
            float alpha = 0.8f;
            float colorMultiplier = chunkGridAlphaMultiplier;
            red *= colorMultiplier;
            green *= colorMultiplier;
            blue *= colorMultiplier;
            RenderSystem.lineWidth((float)1.0f);
            boolean bias = true;
            class_4587.class_4665 matrices = matrixStack.method_23760();
            for (int X = minX; X <= maxX; ++X) {
                drawX = (X - playerChunkX + 1) * 64 - offsetX;
                for (i = 0; i < 4; ++i) {
                    float lineX = (float)drawX + (float)(-16 * i);
                    this.helper.addColoredLineToExistingBuffer(matrices, lineBufferBuilder, lineX, -((float)halfMaxVisibleLength), lineX, (float)halfMaxVisibleLength + (float)bias, red, green, blue, alpha);
                }
            }
            for (int Z = minZ; Z <= maxZ; ++Z) {
                int drawZ = (Z - playerChunkZ + 1) * 64 - offsetZ;
                for (i = 0; i < 4; ++i) {
                    float lineZ = (float)drawZ + (float)((double)(-16 * i) - 1.0 / this.zoom);
                    this.helper.addColoredLineToExistingBuffer(matrices, lineBufferBuilder, -((float)halfMaxVisibleLength), lineZ, (float)halfMaxVisibleLength + (float)bias, lineZ, red, green, blue, alpha);
                }
            }
        }
        renderTypeBuffers.method_22993();
        this.scalingFramebuffer.method_1240();
        this.rotationFramebuffer.method_1235(false);
        GL11.glClear((int)16640);
        this.scalingFramebuffer.method_35610();
        shaderMatrixStack.method_34426();
        if (this.modMain.getSettings().getAntiAliasing()) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        shaderMatrixStack.method_22904((double)halfWView, (double)halfWView, -2980.0);
        shaderMatrixStack.method_22903();
        if (!lockedNorth) {
            shaderMatrixStack.method_22907(class_1160.field_20707.method_23214(-angle));
        }
        shaderMatrixStack.method_22904(-xInsidePixel * this.zoom, -zInsidePixel * this.zoom, 0.0);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)(this.modMain.getSettings().minimapOpacity / 100.0)));
        this.helper.drawMyTexturedModalRect(matrixStack, -256.0f, -256.0f, 0, 0, 512.0f, 512.0f, 512.0f, 512.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        shaderMatrixStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        before = System.currentTimeMillis();
        RenderSystem.disableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)1);
        GlStateManager._depthFunc((int)519);
        GlStateManager._depthFunc((int)515);
        GlStateManager._depthMask((boolean)false);
        GlStateManager._depthMask((boolean)true);
        GL11.glBindTexture((int)3553, (int)0);
        GlStateManager._bindTexture((int)0);
        RenderSystem.setShaderTexture((int)0, (class_2960)InterfaceRenderer.guiTextures);
        this.mc.method_1531().method_22813(InterfaceRenderer.guiTextures);
        if (this.modMain.getSettings().getSmoothDots()) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        class_1657 p = player;
        ModSettings settings = this.modMain.getSettings();
        boolean smoothDots = settings.getSmoothDots();
        boolean debugEntityIcons = settings.debugEntityIcons;
        boolean debugEntityVariantIds = settings.debugEntityVariantIds;
        int dotsStyle = settings.getDotsStyle();
        MinimapRadar minimapRadar = minimap.getEntityRadar();
        boolean reversedOrder = ModSettings.keyReverseEntityRadar.method_1434();
        this.entityIconManager.allowPrerender();
        class_1921 dotsRenderType = smoothDots ? CustomRenderTypes.GUI_BILINEAR : CustomRenderTypes.GUI_NEAREST;
        class_4588 dotsBufferBuilder = renderTypeBuffers.getBuffer(dotsRenderType);
        class_4588 nameBgBuilder = renderTypeBuffers.getBuffer(CustomRenderTypes.RADAR_NAME_BGS);
        MultiTextureRenderTypeRenderer iconsRenderer = multiTextureRenderTypeRenderers.getRenderer(t -> RenderSystem.setShaderTexture((int)0, (int)t), MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.GUI_BILINEAR);
        int dotIndex = 0;
        Iterator<MinimapRadarList> entityLists = minimapRadar.getRadarListsIterator();
        while (entityLists.hasNext()) {
            MinimapRadarList entityList = entityLists.next();
            EntityRadarCategory entityCategory = entityList.getCategory();
            int icons = entityCategory.getSettingValue(EntityRadarCategorySettings.ICONS).intValue();
            int names = entityCategory.getSettingValue(EntityRadarCategorySettings.NAMES).intValue();
            double nameScale = settings.getDotNameScale();
            double iconScale = entityCategory.getSettingValue(EntityRadarCategorySettings.ICON_SCALE);
            int dotSize = entityCategory.getSettingValue(EntityRadarCategorySettings.DOT_SIZE).intValue();
            int heightLimit = entityCategory.getSettingValue(EntityRadarCategorySettings.HEIGHT_LIMIT).intValue();
            boolean heightBasedFade = entityCategory.getSettingValue(EntityRadarCategorySettings.HEIGHT_FADE);
            int startFadingAt = entityCategory.getSettingValue(EntityRadarCategorySettings.START_FADING_AT).intValue();
            boolean displayNameWhenIconFails = entityCategory.getSettingValue(EntityRadarCategorySettings.ICON_NAME_FALLBACK);
            boolean alwaysNameTags = entityCategory.getSettingValue(EntityRadarCategorySettings.ALWAYS_NAMETAGS);
            int colorIndex = entityCategory.getSettingValue(EntityRadarCategorySettings.COLOR).intValue();
            dotIndex = this.renderEntityListToFBO(matrixStack, minimap, p, renderEntity, entityList.getEntities(), ps, pc, playerX, playerZ, partial, names, icons, alwaysNameTags, minimapRadar, lockedNorth, dotsStyle, smoothDots, debugEntityIcons, debugEntityVariantIds, cave, nameScale, renderTypeBuffers, dotsBufferBuilder, iconsRenderer, nameBgBuilder, dotIndex, displayNameWhenIconFails, heightLimit, heightBasedFade, startFadingAt, iconScale, dotSize, colorIndex, entityCategory, reversedOrder);
        }
        if (reversedOrder) {
            renderTypeBuffers.method_22994(dotsRenderType);
        }
        multiTextureRenderTypeRenderers.draw(iconsRenderer);
        if (!reversedOrder) {
            renderTypeBuffers.method_22994(dotsRenderType);
        }
        if (settings.compassLocation == 1) {
            int compassScale = settings.getCompassScale();
            matrixStack.method_22903();
            matrixStack.method_22904(0.0, 0.0, 1950.0);
            this.waypointsGuiRenderer.drawCompass(matrixStack, this.getHelper(), viewW / 2 - 7 - 3 * compassScale, viewW / 2 - 7 - 3 * compassScale, ps, pc, 1.0, circle, compassScale, true, renderTypeBuffers, nameBgBuilder);
            matrixStack.method_22909();
        }
        renderTypeBuffers.method_22993();
        RenderSystem.setShaderTexture((int)0, (class_2960)InterfaceRenderer.guiTextures);
        this.mc.method_1531().method_22813(InterfaceRenderer.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        this.rotationFramebuffer.method_1240();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        Misc.minecraftOrtho(this.mc);
        shaderMatrixStack.method_22909();
        RenderSystem.applyModelViewMatrix();
    }

    public int renderEntityListToFBO(class_4587 matrixStack, MinimapProcessor minimap, class_1657 p, class_1297 renderEntity, List<class_1297> list, double ps, double pc, double playerX, double playerZ, float partial, int names, int icons, boolean alwaysNameTags, MinimapRadar minimapRadar, boolean lockedNorth, int style, boolean smooth, boolean debug, boolean debugEntityVariantIds, boolean cave, double dotNameScale, class_4597.class_4598 textRenderTypeBuffer, class_4588 dotsBufferBuilder, MultiTextureRenderTypeRenderer iconsRenderer, class_4588 nameBgBuilder, int dotIndex, boolean displayNameWhenIconFails, int heightLimit, boolean heightBasedFade, int startFadingAt, double iconScale, int dotSize, int colorIndex, EntityRadarCategory category, boolean reversedOrder) {
        boolean playerListPressed = this.mc.field_1690.field_1907.method_1434();
        boolean namesForList = names == 1 && playerListPressed || names == 2;
        boolean iconsForList = icons == 1 && playerListPressed || icons == 2;
        int iterationStart = reversedOrder ? list.size() - 1 : 0;
        int iterationEnd = reversedOrder ? -1 : list.size();
        int iterationStep = reversedOrder ? -1 : 1;
        for (int i = iterationStart; i != iterationEnd; i += iterationStep) {
            boolean icon;
            class_1297 e = list.get(i);
            if (renderEntity == e) continue;
            boolean name = namesForList;
            boolean bl = icon = iconsForList && e instanceof class_1309;
            if (!(e instanceof class_1657)) {
                name = name || alwaysNameTags && e.method_16914();
            }
            this.renderEntityDotToFBO(matrixStack, minimap, p, renderEntity, e, ps, pc, playerX, playerZ, partial, name, icon, minimapRadar, lockedNorth, style, smooth, debug, debugEntityVariantIds, cave, dotNameScale, textRenderTypeBuffer, dotsBufferBuilder, iconsRenderer, nameBgBuilder, dotIndex++, displayNameWhenIconFails, heightLimit, heightBasedFade, startFadingAt, iconScale, dotSize, colorIndex, category);
        }
        return dotIndex;
    }

    public void renderEntityDotToFBO(class_4587 matrixStack, MinimapProcessor minimap, class_1657 p, class_1297 renderEntity, class_1297 e, double ps, double pc, double playerX, double playerZ, float partial, boolean name, boolean icon, MinimapRadar minimapRadar, boolean lockedNorth, int style, boolean smooth, boolean debug, boolean debugEntityVariantIds, boolean cave, double dotNameScale, class_4597.class_4598 textRenderTypeBuffer, class_4588 dotsBufferBuilder, MultiTextureRenderTypeRenderer iconsRenderer, class_4588 nameBgBuilder, int dotIndex, boolean displayNameWhenIconFails, int heightLimit, boolean heightBasedFade, int startFadingAt, double iconScale, int dotSize, int colorIndex, EntityRadarCategory category) {
        class_2561 component;
        double dotsScale;
        EntityIcon entityHeadTexture;
        if (!minimapRadar.shouldRenderEntity(e, renderEntity)) {
            return;
        }
        double offx = minimapRadar.getEntityX(e, partial) - playerX;
        double offz = minimapRadar.getEntityZ(e, partial) - playerZ;
        float offh = (float)(renderEntity.method_23318() - e.method_23318());
        matrixStack.method_22903();
        double zoomedOffX = offx * this.zoom;
        double zoomedOffZ = offz * this.zoom;
        double translateX = ps * zoomedOffX - pc * zoomedOffZ;
        double translateY = pc * zoomedOffX + ps * zoomedOffZ;
        int roundedX = (int)Math.round(translateX);
        int roundedY = (int)Math.round(translateY);
        matrixStack.method_22904((double)roundedX, (double)roundedY, 0.0);
        int nameOffsetX = 0;
        int nameOffsetY = 0;
        matrixStack.method_22903();
        EntityIcon entityIcon = entityHeadTexture = icon ? this.entityIconManager.getEntityHeadTexture(e, (class_276)this.rotationFramebuffer, this.getHelper(), (float)iconScale, debug, debugEntityVariantIds) : null;
        if (entityHeadTexture == EntityIconManager.DOT) {
            entityHeadTexture = null;
            icon = false;
        }
        if (entityHeadTexture == EntityIconManager.FAILED) {
            entityHeadTexture = null;
        }
        if (entityHeadTexture != null) {
            float a;
            float r;
            float g;
            float b;
            matrixStack.method_22904(translateX - (double)roundedX, translateY - (double)roundedY, 0.0);
            dotsScale = iconScale;
            double clampedScale = Math.max(1.0, dotsScale);
            matrixStack.method_22905((float)clampedScale, (float)clampedScale, 1.0f);
            float brightness = minimapRadar.getEntityBrightness(offh, heightLimit, startFadingAt, heightBasedFade);
            if (!cave) {
                g = b = brightness;
                r = b;
                a = 1.0f;
            } else {
                b = 1.0f;
                g = 1.0f;
                r = 1.0f;
                a = brightness;
            }
            this.getHelper().prepareMyTexturedColoredModalRect(matrixStack.method_23760().method_23761(), -31.0f, -31.0f, entityHeadTexture.getOffsetX() + 1, entityHeadTexture.getOffsetY() + 1, 62.0f, 62.0f, 62.0f, entityHeadTexture.getTextureAtlas().getWidth(), entityHeadTexture.getTextureAtlas().getTextureId(), r, g, b, a, iconsRenderer);
        } else {
            if (icon && displayNameWhenIconFails) {
                name = true;
            }
            dotsScale = 1.0 + 0.5 * (double)(dotSize - 1);
            int color = minimapRadar.getEntityColour(p, e, offh, cave, category, heightLimit, startFadingAt, heightBasedFade, colorIndex);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            double partialX = translateX - (double)roundedX;
            double partialY = translateY - (double)roundedY;
            matrixStack.method_22904(partialX, partialY, 0.0);
            int dotTextureX = 0;
            int dotTextureY = 0;
            int dotTextureW = 0;
            int dotTextureH = 0;
            float dotOffset = 0.0f;
            double dotActualScale = 1.0;
            if (style == 1) {
                if (smooth) {
                    dotTextureX = 1;
                    dotTextureY = 88;
                } else {
                    dotsScale = (int)dotsScale;
                    dotTextureX = 9;
                    dotTextureY = 77;
                }
                dotOffset = -3.5f;
                dotTextureH = 8;
                dotTextureW = 8;
                dotActualScale = dotsScale;
                matrixStack.method_22905((float)dotsScale, (float)dotsScale, 1.0f);
            } else {
                switch (dotSize) {
                    case 1: {
                        dotOffset = -4.5f;
                        dotTextureY = 108;
                        dotTextureH = 9;
                        dotTextureW = 9;
                        break;
                    }
                    case 3: {
                        dotOffset = -7.5f;
                        dotTextureY = 128;
                        dotTextureH = 15;
                        dotTextureW = 15;
                        break;
                    }
                    case 4: {
                        dotOffset = -10.5f;
                        dotTextureY = 160;
                        dotTextureH = 21;
                        dotTextureW = 21;
                        break;
                    }
                    default: {
                        dotOffset = -5.5f;
                        dotTextureY = 117;
                        dotTextureH = 11;
                        dotTextureW = 11;
                    }
                }
            }
            if (!smooth) {
                double dotRadius = (double)(-dotOffset) * dotActualScale;
                double dotRadiusPartial = dotRadius - (double)((int)dotRadius);
                nameOffsetX = partialX - dotRadiusPartial <= -0.5 ? -1 : 0;
                nameOffsetY = partialY - dotRadiusPartial < -0.5 ? -1 : 0;
            }
            this.getHelper().addTexturedColoredRectToExistingBuffer(matrixStack.method_23760().method_23761(), dotsBufferBuilder, dotOffset, dotOffset, dotTextureX, dotTextureY, dotTextureW, dotTextureH, r, g, b, a, 256.0f);
        }
        matrixStack.method_22909();
        if (name && (component = Misc.getFixedDisplayName(e)) != null) {
            matrixStack.method_22903();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            String entityName = component.getString();
            int nameW = this.mc.field_1772.method_1727(entityName);
            int offsetY = entityHeadTexture != null ? 11 : 5;
            int zOffset = dotIndex > 19490 ? 19490 : dotIndex;
            matrixStack.method_22904((double)nameOffsetX, (double)((long)nameOffsetY + Math.round((double)offsetY * dotsScale)), (double)zOffset * 0.1);
            matrixStack.method_22905((float)dotNameScale, (float)dotNameScale, 1.0f);
            this.getHelper().addColoredRectToExistingBuffer(matrixStack.method_23760().method_23761(), nameBgBuilder, -nameW / 2 - 2, -1.0f, nameW + 3, 10, 0.0f, 0.0f, 0.0f, 0.3529412f);
            Misc.drawNormalText(matrixStack, entityName, -nameW / 2, 0.0f, -1, false, textRenderTypeBuffer);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            matrixStack.method_22909();
        }
        matrixStack.method_22909();
    }

    public void deleteFramebuffers() {
        this.scalingFramebuffer.method_1238();
        this.rotationFramebuffer.method_1238();
        if (this.entityIconManager != null) {
            this.entityIconManager.reset();
        }
    }

    public boolean isLoadedFBO() {
        return this.loadedFBO;
    }

    public void setLoadedFBO(boolean loadedFBO) {
        this.loadedFBO = loadedFBO;
    }

    public boolean isTriedFBO() {
        return this.triedFBO;
    }

    public void resetEntityIcons() {
        if (this.entityIconManager != null) {
            this.entityIconManager.reset();
        }
    }

    public void resetEntityIconsResources() {
        if (this.entityIconManager != null) {
            this.entityIconManager.resetResources();
        }
    }

    public void onEntityIconsModelRenderDetection(class_583<?> model, float red, float green, float blue, float alpha) {
        this.entityIconManager.onModelRenderDetection(model, red, green, blue, alpha);
    }

    public void onEntityIconsModelPartRenderDetection(class_630 modelRenderer, float red, float green, float blue, float alpha) {
        this.entityIconManager.onModelPartRenderDetection(modelRenderer, red, green, blue, alpha);
    }

    public void renderMainEntityDot(class_4587 matrixStack, MinimapProcessor minimap, class_1657 p, class_1297 renderEntity, double ps, double pc, double playerX, double playerZ, float partial, MinimapRadar minimapRadar, boolean lockedNorth, int style, boolean smooth, boolean debug, boolean cave, double dotNameScale, ModSettings settings, class_4597.class_4598 renderTypeBuffers) {
        EntityRadarCategory mainEntityCategory = minimapRadar.getEntityCategoryManager().getRuleResolver().resolve(minimapRadar.getEntityCategoryManager().getRootCategory(), renderEntity, p);
        if (mainEntityCategory == null) {
            mainEntityCategory = minimapRadar.getEntityCategoryManager().getRootCategory();
        }
        int dotSize = settings.mainDotSize;
        this.renderEntityDotToFBO(matrixStack, minimap, p, renderEntity, renderEntity, ps, pc, playerX, playerZ, partial, false, false, minimapRadar, lockedNorth, style, smooth, debug, false, cave, dotNameScale, renderTypeBuffers, renderTypeBuffers.getBuffer(CustomRenderTypes.GUI_BILINEAR), null, null, 0, false, 100, false, 100, 1.0, dotSize, mainEntityCategory.getSettingValue(EntityRadarCategorySettings.COLOR).intValue(), mainEntityCategory);
        renderTypeBuffers.method_22993();
    }
}

