/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.class_1074;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import org.lwjgl.opengl.GL11;
import xaero.common.AXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.graphics.CustomVertexConsumers;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.MinimapInterface;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.radar.MinimapRadar;
import xaero.common.minimap.radar.category.EntityRadarCategory;
import xaero.common.minimap.radar.category.setting.EntityRadarCategorySettings;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.MinimapSafeModeRenderer;
import xaero.common.minimap.waypoints.render.WaypointsGuiRenderer;
import xaero.common.misc.Misc;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModSettings;

public abstract class MinimapRenderer {
    public static final int black = -16777216;
    public static final int slime = -2142047936;
    protected AXaeroMinimap modMain;
    protected class_310 mc;
    protected MinimapInterface minimapInterface;
    protected MinimapRendererHelper helper;
    protected WaypointsGuiRenderer waypointsGuiRenderer;
    private int lastMinimapSize;
    private ArrayList<String> underText;
    protected double zoom = 1.0;
    private class_2338.class_2339 mutableBlockPos;

    public MinimapRenderer(AXaeroMinimap modMain, class_310 mc, WaypointsGuiRenderer waypointsGuiRenderer, MinimapInterface minimapInterface) {
        this.modMain = modMain;
        this.mc = mc;
        this.waypointsGuiRenderer = waypointsGuiRenderer;
        this.minimapInterface = minimapInterface;
        this.underText = new ArrayList();
        this.helper = new MinimapRendererHelper();
        this.mutableBlockPos = new class_2338.class_2339();
    }

    public double getRenderAngle(boolean lockedNorth) {
        if (lockedNorth) {
            return 90.0;
        }
        return this.getActualAngle();
    }

    private double getActualAngle() {
        double rotation = this.mc.field_1773.method_19418().method_19330();
        return -90.0 - rotation;
    }

    protected abstract void renderChunks(XaeroMinimapSession var1, class_4587 var2, MinimapProcessor var3, int var4, int var5, float var6, float var7, int var8, boolean var9, boolean var10, int var11, double var12, double var14, boolean var16, boolean var17, ModSettings var18, CustomVertexConsumers var19);

    public void renderMinimap(XaeroMinimapSession minimapSession, class_4587 matrixStack, MinimapProcessor minimap, int x, int y, int width, int height, double scale, int size, float partial, CustomVertexConsumers cvc) {
        class_2960 dimensionId;
        boolean crosshairDisplayed;
        int specW;
        int frameType;
        boolean renderFrame;
        ModSettings settings = this.modMain.getSettings();
        if (settings.getMinimapSize() != this.lastMinimapSize) {
            this.lastMinimapSize = settings.getMinimapSize();
            minimap.setToResetImage(true);
        }
        this.mc.field_1705.method_25304(0);
        minimap.getEntityRadar().setLastRenderViewEntity(this.mc.method_1560());
        ArrayList<String> underText = this.underText;
        int mapSize = minimapSession.getMinimapProcessor().getMinimapSize();
        int bufferSize = minimapSession.getMinimapProcessor().getMinimapBufferSize(mapSize);
        if (this.minimapInterface.usingFBO()) {
            bufferSize = minimap.getFBOBufferSize();
        }
        float minimapScale = settings.getMinimapScale();
        float mapScale = (float)(scale / (double)minimapScale);
        minimap.updateZoom();
        this.zoom = minimap.getMinimapZoom();
        class_308.method_24210();
        RenderSystem.disableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.pixelStore((int)3317, (int)4);
        RenderSystem.pixelStore((int)3316, (int)0);
        RenderSystem.pixelStore((int)3315, (int)0);
        RenderSystem.pixelStore((int)3314, (int)0);
        float sizeFix = (float)bufferSize / 512.0f;
        int shape = settings.minimapShape;
        boolean lockedNorth = settings.getLockNorth(mapSize / 2, shape);
        double angle = Math.toRadians(this.getRenderAngle(lockedNorth));
        double ps = Math.sin(Math.PI - angle);
        double pc = Math.cos(Math.PI - angle);
        boolean useWorldMap = this.modMain.getSupportMods().shouldUseWorldMapChunks() && minimap.getMinimapWriter().getLoadedCaving() == Integer.MAX_VALUE && minimap.getMinimapWriter().loadedLightOverlayType <= 0;
        int lightLevel = (int)((1.0f - Math.min(1.0f, this.getSunBrightness())) * (float)(minimap.getMinimapWriter().getLoadedLevels() - 1));
        boolean cave = !useWorldMap && minimap.getMinimapWriter().getLoadedCaving() != Integer.MAX_VALUE;
        boolean circleShape = shape == 1;
        this.renderChunks(minimapSession, matrixStack, minimap, mapSize, bufferSize, sizeFix, partial, lightLevel, useWorldMap, lockedNorth, shape, ps, pc, cave, circleShape, settings, cvc);
        if (this.minimapInterface.usingFBO()) {
            sizeFix = 1.0f;
        }
        RenderSystem.enableTexture();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        matrixStack.method_22903();
        matrixStack.method_22905(1.0f / mapScale, 1.0f / mapScale, 1.0f);
        int scaledX = (int)((float)x * mapScale);
        int scaledY = (int)((float)y * mapScale);
        int minimapFrameSize = (int)((float)(mapSize / 2) / sizeFix);
        int circleSides = Math.max(32, (int)Math.ceil(Math.PI * (double)(minimapFrameSize + 8) / 8.0 / 4.0) * 4);
        double circleSeamAngle = -0.7853981633974483;
        int circleSeamWidth = 32;
        int circleFrameThickness = 4;
        double circleStartAngle = 0.0;
        if (!circleShape) {
            this.getHelper().drawMyTexturedModalRect(matrixStack, (int)((float)(scaledX + 9) / sizeFix), (int)((float)(scaledY + 9) / sizeFix), 0, 256 - minimapFrameSize, minimapFrameSize, minimapFrameSize, minimapFrameSize, 256.0f);
        } else {
            float outerRadius = mapSize / 4 + circleFrameThickness;
            circleStartAngle = circleSeamAngle - (double)((float)(circleSeamWidth / 2) / outerRadius);
            this.getHelper().drawTexturedElipseInsideRectangle(matrixStack, circleStartAngle, circleSides, (int)((float)(scaledX + 9) / sizeFix), (int)((float)(scaledY + 9) / sizeFix), 0, 256 - minimapFrameSize, minimapFrameSize, 256.0f);
        }
        if (!this.minimapInterface.usingFBO()) {
            matrixStack.method_22905(1.0f / sizeFix, 1.0f / sizeFix, 1.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        boolean bl = renderFrame = (frameType = settings.minimapFrame) < ModSettings.FRAME_OPTIONS.length - 1;
        if (frameType > 0) {
            int frameColor = ModSettings.COLORS[settings.minimapFrameColor];
            RenderSystem.setShaderColor((float)((float)(frameColor >> 16 & 0xFF) / 255.0f), (float)((float)(frameColor >> 8 & 0xFF) / 255.0f), (float)((float)(frameColor & 0xFF) / 255.0f), (float)1.0f);
        }
        MinimapRendererHelper helper = this.getHelper();
        if (renderFrame) {
            RenderSystem.setShaderTexture((int)0, (class_2960)InterfaceRenderer.minimapFrameTextures);
        }
        if (renderFrame && !circleShape) {
            int rightCornerStartX = scaledX + 9 + mapSize / 2 + 4 - 16;
            int bottomCornerStartY = scaledY + 9 + mapSize / 2 + 4 - 16;
            RenderSystem.setShader(class_757::method_34542);
            class_289 tessellator = class_289.method_1348();
            class_287 vertexBuffer = tessellator.method_1349();
            vertexBuffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
            class_1159 matrix = matrixStack.method_23760().method_23761();
            int cornerTextureX = frameType == 0 ? 192 : (frameType == 1 ? 208 : 224);
            helper.addTexturedRectToExistingBuffer(matrix, (class_4588)vertexBuffer, scaledX + 9 - 4, scaledY + 9 - 4, cornerTextureX, 97, 16, 16);
            helper.addTexturedRectToExistingBuffer(matrix, (class_4588)vertexBuffer, rightCornerStartX, scaledY + 9 - 4, cornerTextureX, 113, 16, 16);
            helper.addTexturedRectToExistingBuffer(matrix, (class_4588)vertexBuffer, scaledX + 9 - 4, bottomCornerStartY, cornerTextureX, 129, 16, 16);
            helper.addTexturedRectToExistingBuffer(matrix, (class_4588)vertexBuffer, rightCornerStartX, bottomCornerStartY, cornerTextureX, 145, 16, 16);
            int horLineStartX = scaledX + 9 - 4 + 16;
            int horLineWidth = rightCornerStartX - horLineStartX;
            int horPieceTextureY = frameType == 0 ? 0 : (frameType == 1 ? 32 : 64);
            int horPieceWidth = 226;
            int horLineLength = (int)Math.ceil((double)horLineWidth / (double)horPieceWidth);
            for (int i = 0; i < horLineLength; ++i) {
                int pieceX = scaledX + 9 - 4 + 16 + i * horPieceWidth;
                int pieceW = horPieceWidth;
                if (i == horLineLength - 1 && pieceX + pieceW > rightCornerStartX) {
                    pieceW = rightCornerStartX - pieceX;
                }
                helper.addTexturedRectToExistingBuffer(matrix, (class_4588)vertexBuffer, pieceX, scaledY + 9 - 4, 0, horPieceTextureY, pieceW, 16);
                helper.addTexturedRectToExistingBuffer(matrix, (class_4588)vertexBuffer, pieceX, scaledY + 9 + mapSize / 2 - 12, 0, horPieceTextureY + 16, pieceW, 16);
            }
            int verLineStartY = scaledY + 9 - 4 + 16;
            int verLineHeight = bottomCornerStartY - verLineStartY;
            int verPieceTextureX = frameType == 0 ? 0 : (frameType == 1 ? 64 : 128);
            int verPieceHeight = 113;
            int vertLineLength = (int)Math.ceil((double)verLineHeight / (double)verPieceHeight);
            for (int i = 0; i < vertLineLength; ++i) {
                int pieceY = scaledY + 9 - 4 + 16 + i * verPieceHeight;
                int pieceU = verPieceTextureX + 32 * (i & 1);
                int pieceH = verPieceHeight;
                if (i == vertLineLength - 1 && pieceY + pieceH > bottomCornerStartY) {
                    pieceH = bottomCornerStartY - pieceY;
                }
                helper.addTexturedRectToExistingBuffer(matrix, (class_4588)vertexBuffer, scaledX + 9 - 4, pieceY, pieceU, 97, 16, pieceH);
                helper.addTexturedRectToExistingBuffer(matrix, (class_4588)vertexBuffer, scaledX + 9 + mapSize / 2 - 12, pieceY, pieceU + 16, 97, 16, pieceH);
            }
            tessellator.method_1350();
        } else if (renderFrame) {
            int frameTextureY = frameType == 0 ? 210 : (frameType == 1 ? 214 : 218);
            double shadeStartAngle = 0.7853981633974483 - circleStartAngle;
            int shadeStartIndex = (int)(shadeStartAngle / 2.0 / Math.PI * (double)circleSides);
            int circleLeftX = scaledX + 9;
            int circleTopY = scaledY + 9;
            int innerCircleDiameter = mapSize / 2;
            helper.drawTexturedElipseInsideRectangleFrame(matrixStack, false, false, circleStartAngle, 0, shadeStartIndex, circleSides, circleFrameThickness, circleLeftX, circleTopY, 0, frameTextureY, innerCircleDiameter, 73.0f, circleFrameThickness, circleSeamWidth, 256.0f);
            helper.drawTexturedElipseInsideRectangleFrame(matrixStack, true, false, circleStartAngle, shadeStartIndex, shadeStartIndex + circleSides / 4, circleSides, circleFrameThickness, circleLeftX, circleTopY, 138, frameTextureY, innerCircleDiameter, 68.0f, circleFrameThickness, 20, 256.0f);
            helper.drawTexturedElipseInsideRectangleFrame(matrixStack, true, true, circleStartAngle, shadeStartIndex + circleSides / 4, shadeStartIndex + circleSides / 2, circleSides, circleFrameThickness, circleLeftX, circleTopY, 138, frameTextureY, innerCircleDiameter, 68.0f, circleFrameThickness, 20, 256.0f);
            helper.drawTexturedElipseInsideRectangleFrame(matrixStack, false, false, circleStartAngle, shadeStartIndex + circleSides / 2, circleSides, circleSides, circleFrameThickness, circleLeftX, circleTopY, 0, frameTextureY, innerCircleDiameter, 73.0f, circleFrameThickness, circleSeamWidth, 256.0f);
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)InterfaceRenderer.guiTextures);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.method_22903();
        matrixStack.method_22904((double)(scaledX + 9), (double)(scaledY + 9), 0.0);
        matrixStack.method_22905(1.0f / minimapScale, 1.0f / minimapScale, 1.0f);
        int halfFrame = (int)((float)mapSize * minimapScale / 2.0f / 2.0f);
        matrixStack.method_22904((double)halfFrame, (double)halfFrame, 0.0);
        int specH = specW = halfFrame + (int)(3.0f * minimapScale);
        boolean safeMode = this instanceof MinimapSafeModeRenderer;
        double playerX = minimap.getEntityRadar().getEntityX(this.mc.method_1560(), partial);
        double playerY = minimap.getEntityRadar().getEntityY(this.mc.method_1560(), partial);
        double playerZ = minimap.getEntityRadar().getEntityZ(this.mc.method_1560(), partial);
        this.waypointsGuiRenderer.render(minimapSession, matrixStack, this.getHelper(), playerX, playerY, playerZ, specW, specH, ps, pc, partial, this.zoom * (double)minimapScale / 2.0, circleShape, minimapScale, cvc.getBetterPVPRenderTypeBuffers(), safeMode);
        matrixStack.method_22909();
        RenderSystem.enableBlend();
        boolean bl2 = crosshairDisplayed = settings.mainEntityAs == 0 && !lockedNorth;
        if (crosshairDisplayed) {
            matrixStack.method_22903();
            matrixStack.method_22904((double)(scaledX + 9), (double)(scaledY + 9), 0.0);
            matrixStack.method_22905(0.5f, 0.5f, 1.0f);
            RenderSystem.disableTexture();
            matrixStack.method_22904((double)(mapSize / 2), (double)(mapSize / 2), 0.0);
            RenderSystem.blendFuncSeparate((int)775, (int)0, (int)1, (int)0);
            this.getHelper().drawMyColoredRect(matrixStack, -5.0f, -1.0f, 5.0f, 1.0f);
            this.getHelper().drawMyColoredRect(matrixStack, -1.0f, 3.0f, 1.0f, 5.0f);
            this.getHelper().drawMyColoredRect(matrixStack, -1.0f, -5.0f, 1.0f, -3.0f);
            RenderSystem.blendFunc((int)770, (int)771);
            MinimapRadar minimapRadar = minimap.getEntityRadar();
            EntityRadarCategory mainEntityCategory = minimapRadar.getEntityCategoryManager().getRuleResolver().resolve(minimapRadar.getEntityCategoryManager().getRootCategory(), this.mc.method_1560(), this.mc.field_1724);
            if (mainEntityCategory == null) {
                mainEntityCategory = minimapRadar.getEntityCategoryManager().getRootCategory();
            }
            int crosshairColor = minimapRadar.getEntityColour((class_1657)this.mc.field_1724, this.mc.method_1560(), 0.0f, false, mainEntityCategory, 100, 100, false, mainEntityCategory.getSettingValue(EntityRadarCategorySettings.COLOR).intValue());
            RenderSystem.setShaderColor((float)((float)(crosshairColor >> 16 & 0xFF) / 255.0f), (float)((float)(crosshairColor >> 8 & 0xFF) / 255.0f), (float)((float)(crosshairColor & 0xFF) / 255.0f), (float)1.0f);
            this.getHelper().drawMyColoredRect(matrixStack, 1.0f, -1.0f, 3.0f, 1.0f);
            this.getHelper().drawMyColoredRect(matrixStack, -3.0f, -1.0f, -1.0f, 1.0f);
            this.getHelper().drawMyColoredRect(matrixStack, -1.0f, 1.0f, 1.0f, 3.0f);
            this.getHelper().drawMyColoredRect(matrixStack, -1.0f, -3.0f, 1.0f, -1.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableTexture();
            RenderSystem.enableBlend();
            matrixStack.method_22909();
        }
        double centerX = 2 * scaledX + 18 + mapSize / 2;
        double centerY = 2 * scaledY + 18 + mapSize / 2;
        matrixStack.method_22903();
        matrixStack.method_22905(0.5f, 0.5f, 1.0f);
        matrixStack.method_22904(centerX, centerY, 0.0);
        this.mc.method_1531().method_22813(InterfaceRenderer.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        if (!safeMode && !crosshairDisplayed) {
            class_1297 mainEntity = this.mc.method_1560();
            MinimapRadar radar = minimap.getEntityRadar();
            this.minimapInterface.getMinimapFBORenderer().renderMainEntityDot(matrixStack, minimap, (class_1657)this.mc.field_1724, mainEntity, ps, pc, radar.getEntityX(mainEntity, partial), radar.getEntityZ(mainEntity, partial), partial, radar, lockedNorth, settings.getDotsStyle(), true, settings.debugEntityIcons, cave, settings.getDotNameScale(), settings, cvc.getBetterPVPRenderTypeBuffers());
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)InterfaceRenderer.guiTextures);
        RenderSystem.enableBlend();
        if (lockedNorth || settings.mainEntityAs == 2) {
            float b;
            float g;
            float r;
            float arrowAngle = lockedNorth ? this.mc.method_1560().method_5705(partial) : 180.0f;
            float arrowOpacity = (float)settings.playerArrowOpacity / 100.0f;
            if (arrowOpacity == 1.0f) {
                this.drawArrow(matrixStack, arrowAngle, 0.0, 1.0, 0.0f, 0.0f, 0.0f, 0.5f, settings);
            }
            if (settings.arrowColour != -1) {
                float[] c = ModSettings.arrowColours[settings.arrowColour];
                r = c[0];
                g = c[1];
                b = c[2];
                a = c[3];
            } else {
                int rgb = minimap.getEntityRadar().getTeamColour((class_1297)this.mc.field_1724);
                if (rgb != -1) {
                    r = (float)(rgb >> 16 & 0xFF) / 255.0f;
                    g = (float)(rgb >> 8 & 0xFF) / 255.0f;
                    b = (float)(rgb & 0xFF) / 255.0f;
                    a = 1.0f;
                } else {
                    float[] c = ModSettings.arrowColours[0];
                    r = c[0];
                    g = c[1];
                    b = c[2];
                    a = c[3];
                }
            }
            this.drawArrow(matrixStack, arrowAngle, 0.0, 0.0, r, g, b, a *= arrowOpacity, settings);
        }
        matrixStack.method_22909();
        this.mc.method_1531().method_22813(InterfaceRenderer.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        int playerBlockX = OptimizedMath.myFloor(this.mc.method_1560().method_23317());
        int playerBlockY = OptimizedMath.myFloor(this.mc.method_1560().method_23318());
        int playerBlockZ = OptimizedMath.myFloor(this.mc.method_1560().method_23321());
        if (settings.getShowCoords()) {
            int interfaceSize = size;
            String coords = playerBlockX + ", " + playerBlockY + ", " + playerBlockZ;
            if (this.mc.field_1772.method_1727(coords) >= interfaceSize) {
                String stringLevel = "" + playerBlockY;
                coords = playerBlockX + ", " + playerBlockZ;
                underText.add(coords);
                underText.add(stringLevel);
            } else {
                underText.add(coords);
            }
        }
        class_2338.class_2339 pos = this.mutableBlockPos.method_10103(playerBlockX, playerBlockY, playerBlockZ);
        if (settings.showDimensionName && (dimensionId = this.mc.field_1687.method_27983().method_29177()) != null) {
            String dimensionName = dimensionId.method_12836().equals("minecraft") ? dimensionId.method_12832() : dimensionId.toString();
            underText.add(dimensionName);
        }
        if (settings.showBiome) {
            class_1959 biome = (class_1959)this.mc.field_1687.method_23753((class_2338)pos).comp_349();
            class_2960 biomeRL = biome == null ? null : this.mc.field_1687.method_30349().method_30530(class_2378.field_25114).method_10221((Object)biome);
            String biomeText = biomeRL == null ? class_1074.method_4662((String)"gui.xaero_unknown_biome", (Object[])new Object[0]) : class_1074.method_4662((String)("biome." + biomeRL.method_12836() + "." + biomeRL.method_12832()), (Object[])new Object[0]);
            this.addLineWordsUnderMinimap(underText, size, biomeText);
        }
        if (settings.showLightLevel > 0) {
            boolean lightFetchable;
            int playerBlockLightLevel = 0;
            int playerSkyLightLevel = 0;
            boolean bl3 = lightFetchable = playerBlockY >= this.mc.field_1687.method_31607() && playerBlockY < this.mc.field_1687.method_31600();
            if (settings.showLightLevel == 1 || settings.showLightLevel == 3) {
                int n = playerBlockLightLevel = lightFetchable ? this.mc.field_1687.method_8314(class_1944.field_9282, (class_2338)pos) : 0;
            }
            if (settings.showLightLevel == 2 || settings.showLightLevel == 3) {
                playerSkyLightLevel = lightFetchable ? this.mc.field_1687.method_8314(class_1944.field_9284, (class_2338)pos) : 15;
            }
            underText.add(class_1074.method_4662((String)"gui.xaero_light_value", (Object[])new Object[]{Math.max(playerBlockLightLevel, playerSkyLightLevel)}));
        }
        if (settings.showTime != 0) {
            long totalTime = 6000L + this.mc.field_1687.method_8532();
            int dayNumber = (int)(totalTime / 24000L) + 1;
            int dayTimeSinceMidnight = (int)(totalTime % 24000L);
            int timeHours = dayTimeSinceMidnight / 1000;
            int minutes = (int)((double)(dayTimeSinceMidnight % 1000) / 1000.0 * 60.0);
            if ((settings.showTime - 1) % 2 == 0) {
                if (settings.showTime < 3) {
                    underText.add(class_1074.method_4662((String)"gui.xaero_day", (Object[])new Object[0]) + String.format(" %d, %02d:%02d", dayNumber, timeHours, minutes));
                } else {
                    underText.add(String.format("%02d:%02d", timeHours, minutes));
                }
            } else {
                String half = "AM";
                if (timeHours >= 12) {
                    timeHours -= 12;
                    half = "PM";
                }
                if (timeHours == 0) {
                    timeHours = 12;
                }
                if (settings.showTime < 3) {
                    underText.add(class_1074.method_4662((String)"gui.xaero_day", (Object[])new Object[0]) + String.format(" %d, %02d:%02d %s", dayNumber, timeHours, minutes, half));
                } else {
                    underText.add(String.format("%02d:%02d %s", timeHours, minutes, half));
                }
            }
        }
        if (minimap.getMinimapWriter().debugTotalTime) {
            underText.add(String.format("Min Time %d", minimap.getMinimapWriter().minTimeDebug));
            underText.add(String.format("Average %d", minimap.getMinimapWriter().averageTimeDebug));
            underText.add(String.format("Max Time %d", minimap.getMinimapWriter().maxTimeDebug));
        }
        if (settings.showAngles) {
            underText.add(String.format("%.1f / %.1f", Float.valueOf(class_3532.method_15393((float)this.mc.method_1560().method_36454())), Float.valueOf(class_3532.method_15393((float)this.mc.method_1560().method_36455()))));
        }
        if (settings.lightOverlayType > 0) {
            underText.add(class_1074.method_4662((String)"gui.xaero_light_overlay_status", (Object[])new Object[0]));
        }
        this.drawTextUnderMinimap(matrixStack, underText, scaledX, scaledY, height, size, mapScale, settings, cvc.getBetterPVPRenderTypeBuffers());
        matrixStack.method_22909();
        class_308.method_24211();
    }

    private void addLineWordsUnderMinimap(ArrayList<String> underText, int size, String line) {
        if (this.mc.field_1772.method_1727(line) <= size) {
            underText.add(line);
        } else {
            String[] words = line.split(" ");
            StringBuilder lineBuilder = new StringBuilder();
            for (int i = 0; i < words.length; ++i) {
                int lineWidth;
                int wordStart = lineBuilder.length();
                if (i > 0) {
                    lineBuilder.append(' ');
                }
                lineBuilder.append(words[i]);
                if (i == 0 || (lineWidth = this.mc.field_1772.method_1727(lineBuilder.toString())) <= size) continue;
                lineBuilder.delete(wordStart, lineBuilder.length());
                underText.add(lineBuilder.toString());
                lineBuilder.delete(0, lineBuilder.length());
                lineBuilder.append(words[i]);
            }
            underText.add(lineBuilder.toString());
        }
    }

    private void drawArrow(class_4587 matrixStack, float angle, double arrowX, double arrowY, float r, float g, float b, float a, ModSettings settings) {
        matrixStack.method_22903();
        matrixStack.method_22904(arrowX, arrowY, 0.0);
        matrixStack.method_22907(class_1160.field_20707.method_23214(angle));
        matrixStack.method_22905((float)(0.5 * settings.arrowScale), (float)(0.5 * settings.arrowScale), 1.0f);
        int offsetY = -6;
        int h = 28;
        int ty = 0;
        matrixStack.method_22904(-13.0, (double)offsetY, 0.0);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        this.mc.field_1705.method_25302(matrixStack, 0, 0, 49, ty, 26, h);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.method_22909();
    }

    public void drawTextUnderMinimap(class_4587 matrixStack, ArrayList<String> underText, int scaledX, int scaledY, int height, int size, float mapScale, ModSettings settings, class_4597.class_4598 textRenderTypeBuffer) {
        int interfaceSize = size;
        int scaledHeight = (int)((float)height * mapScale);
        int align = settings.minimapTextAlign;
        for (int i = 0; i < underText.size(); ++i) {
            String s = underText.get(i);
            int stringWidth = this.mc.field_1772.method_1727(s);
            boolean under = scaledY + interfaceSize / 2 < scaledHeight / 2;
            int stringY = scaledY + (under ? interfaceSize : -9) + i * 10 * (under ? 1 : -1);
            int stringX = scaledX + (align == 0 ? interfaceSize / 2 - stringWidth / 2 : (align == 1 ? 6 : interfaceSize - 6 - stringWidth));
            Misc.drawNormalText(matrixStack, s, stringX, stringY, -1, true, textRenderTypeBuffer);
        }
        textRenderTypeBuffer.method_22993();
        underText.clear();
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    private float getSunBrightness() {
        return class_3532.method_15363((float)((this.mc.field_1687.method_23783(1.0f) - 0.2f) / 0.8f), (float)0.0f, (float)1.0f);
    }

    public MinimapRendererHelper getHelper() {
        return this.helper;
    }
}

