/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.flighthud.components;

import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.torocraft.flighthud.Dimensions;
import net.torocraft.flighthud.FlightComputer;
import net.torocraft.flighthud.HudComponent;

public class AltitudeIndicator
extends HudComponent {
    private final Dimensions dim;
    private final FlightComputer computer;

    public AltitudeIndicator(FlightComputer computer, Dimensions dim) {
        this.computer = computer;
        this.dim = dim;
    }

    @Override
    public void render(class_4587 m, float partial, class_310 mc) {
        float top = this.dim.tFrame;
        float bottom = this.dim.bFrame;
        float right = this.dim.rFrame + 2.0f;
        float left = this.dim.rFrame;
        float blocksPerPixel = 1.0f;
        float floorOffset = this.i(this.computer.altitude * blocksPerPixel);
        float yFloor = this.dim.yMid - floorOffset;
        float xAltText = right + 5.0f;
        if (AltitudeIndicator.CONFIG.altitude_showGroundInfo) {
            this.drawHeightIndicator(mc, m, left - 1.0f, this.dim.yMid, bottom - this.dim.yMid);
        }
        if (AltitudeIndicator.CONFIG.altitude_showReadout) {
            this.drawFont(mc, m, String.format("%.0f", Float.valueOf(this.computer.altitude)), xAltText, this.dim.yMid - 3.0f);
            this.drawBox(m, xAltText - 2.0f, this.dim.yMid - 4.5f, 28.0f, 10.0f);
        }
        if (AltitudeIndicator.CONFIG.altitude_showHeight) {
            this.drawFont(mc, m, "G", xAltText - 10.0f, bottom + 3.0f);
            String heightText = this.computer.distanceFromGround == null ? "??" : String.format("%d", this.i(this.computer.distanceFromGround.floatValue()));
            this.drawFont(mc, m, heightText, xAltText, bottom + 3.0f);
            this.drawBox(m, xAltText - 2.0f, bottom + 1.5f, 28.0f, 10.0f);
        }
        if (AltitudeIndicator.CONFIG.altitude_showScale) {
            for (int i = 0; i < 1000; i += 10) {
                float y = this.dim.hScreen - (float)i * blocksPerPixel - yFloor;
                if (y < top || y > bottom - 5.0f) continue;
                if (i % 50 == 0) {
                    this.drawHorizontalLine(m, left, right + 2.0f, y);
                    if (!AltitudeIndicator.CONFIG.altitude_showReadout || y > this.dim.yMid + 7.0f || y < this.dim.yMid - 7.0f) {
                        this.drawFont(mc, m, String.format("%d", i), xAltText, y - 3.0f);
                    }
                }
                this.drawHorizontalLine(m, left, right, y);
            }
        }
    }

    private void drawHeightIndicator(class_310 client, class_4587 m, float x, float top, float h) {
        float bottom = top + h;
        float blocksPerPixel = h / ((float)client.field_1687.method_31605() + 64.0f);
        float yAlt = bottom - (float)this.i((this.computer.altitude + 64.0f) * blocksPerPixel);
        float yFloor = bottom - (float)this.i(64.0f * blocksPerPixel);
        this.drawVerticalLine(m, x, top - 1.0f, bottom + 1.0f);
        if (this.computer.groundLevel != null) {
            float yGroundLevel = bottom - ((float)this.computer.groundLevel.intValue() + 64.0f) * blocksPerPixel;
            AltitudeIndicator.fill(m, x - 3.0f, yGroundLevel + 2.0f, x, yFloor);
        }
        this.drawHorizontalLine(m, x - 6.0f, x - 1.0f, top);
        this.drawHorizontalLine(m, x - 6.0f, x - 1.0f, yFloor);
        this.drawHorizontalLine(m, x - 6.0f, x - 1.0f, bottom);
        this.drawPointer(m, x, yAlt, 90.0f);
    }
}

