/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.coderbot.iris.Iris;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.coderbot.iris.pipeline.FixedFunctionWorldRenderingPipeline;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.shaderpack.DimensionId;
import net.coderbot.iris.uniforms.SystemTimeUniforms;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class PipelineManager {
    private static PipelineManager instance;
    private final Function<DimensionId, WorldRenderingPipeline> pipelineFactory;
    private final Map<DimensionId, WorldRenderingPipeline> pipelinesPerDimension = new HashMap<DimensionId, WorldRenderingPipeline>();
    private WorldRenderingPipeline pipeline = new FixedFunctionWorldRenderingPipeline();
    private boolean sodiumShaderReloadNeeded;

    public PipelineManager(Function<DimensionId, WorldRenderingPipeline> function) {
        this.pipelineFactory = function;
    }

    public WorldRenderingPipeline preparePipeline(DimensionId dimensionId) {
        if (!this.pipelinesPerDimension.containsKey((Object)dimensionId)) {
            SystemTimeUniforms.COUNTER.reset();
            SystemTimeUniforms.TIMER.reset();
            Iris.logger.info("Creating pipeline for dimension {}", new Object[]{dimensionId});
            this.pipeline = this.pipelineFactory.apply(dimensionId);
            this.pipelinesPerDimension.put(dimensionId, this.pipeline);
            this.sodiumShaderReloadNeeded = true;
            if (BlockRenderingSettings.INSTANCE.isReloadRequired()) {
                if (class_310.method_1551().field_1769 != null) {
                    class_310.method_1551().field_1769.method_3279();
                }
                BlockRenderingSettings.INSTANCE.clearReloadRequired();
            }
        } else {
            this.pipeline = this.pipelinesPerDimension.get((Object)dimensionId);
        }
        return this.pipeline;
    }

    @Nullable
    public WorldRenderingPipeline getPipelineNullable() {
        return this.pipeline;
    }

    public Optional<WorldRenderingPipeline> getPipeline() {
        return Optional.ofNullable(this.pipeline);
    }

    public boolean isSodiumShaderReloadNeeded() {
        return this.sodiumShaderReloadNeeded;
    }

    public void clearSodiumShaderReloadNeeded() {
        this.sodiumShaderReloadNeeded = false;
    }

    public void setAsInstance() {
        if (instance != null) {
            throw new IllegalStateException("Multiple pipeline managers active at one time");
        }
        instance = this;
    }

    public static void resetInstance() {
        instance = null;
    }

    public static PipelineManager getInstance() {
        return instance;
    }

    public void destroyPipeline() {
        this.pipelinesPerDimension.forEach((dimensionId, worldRenderingPipeline) -> {
            Iris.logger.info("Destroying pipeline {}", dimensionId);
            this.resetTextureState();
            worldRenderingPipeline.destroy();
        });
        this.pipelinesPerDimension.clear();
        this.pipeline = null;
    }

    private void resetTextureState() {
        for (int i = 0; i < 16; ++i) {
            GlStateManager.glActiveTexture((int)(33984 + i));
            GlStateManager._bindTexture((int)0);
        }
        GlStateManager.glActiveTexture((int)33984);
    }
}

