/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search.argument;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.IntIntMutablePair;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMaps;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.config.SearchMode;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.search.IntRange;
import me.shedaniel.rei.impl.client.search.argument.AlternativeArgument;
import me.shedaniel.rei.impl.client.search.argument.CompoundArgument;
import me.shedaniel.rei.impl.client.search.argument.type.AlwaysMatchingArgumentType;
import me.shedaniel.rei.impl.client.search.argument.type.ArgumentType;
import me.shedaniel.rei.impl.client.search.argument.type.ArgumentTypesRegistry;
import me.shedaniel.rei.impl.client.search.result.ArgumentApplicableResult;
import me.shedaniel.rei.impl.common.util.HashedEntryStackWrapper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_3902;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public class Argument<T, R> {
    public static final String SPACE = " ";
    public static final String EMPTY = "";
    public static final Short2ObjectMap<Long2ObjectMap<Object>> SEARCH_CACHE = Short2ObjectMaps.synchronize((Short2ObjectMap)new Short2ObjectOpenHashMap());
    private static final AtomicReference<String> lastLanguage = new AtomicReference();
    static final Argument<class_3902, class_3902> ALWAYS = new Argument<class_3902, class_3902>(AlwaysMatchingArgumentType.INSTANCE, "", true, -1, -1, true);
    private ArgumentType<T, R> argumentType;
    private String text;
    private T filterData;
    private boolean regular;
    private final int start;
    private final int end;
    private static final Pattern SPLIT_PATTERN = Pattern.compile("(?:\"([^\"]*)\")|([^\\s]+)");
    public static Long prepareStart = null;
    public static Collection<EntryStack<?>> prepareStacks = null;
    public static IntIntPair prepareStage = null;
    public static IntIntPair[] currentStages = null;

    public Argument(ArgumentType<T, R> argumentType, String text, boolean regular, int start, int end, boolean lowercase) {
        this.argumentType = argumentType;
        this.text = lowercase ? text.toLowerCase(Locale.ROOT) : text;
        this.regular = regular;
        this.filterData = null;
        this.start = start;
        this.end = end;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    @ApiStatus.Internal
    public static List<CompoundArgument> bakeArguments(String searchTerm) {
        return Argument.bakeArguments(searchTerm, null);
    }

    @ApiStatus.Internal
    public static List<CompoundArgument> bakeArguments(String searchTerm, @Nullable ProcessedSink sink) {
        ArrayList compoundArguments = Lists.newArrayList();
        int tokenStartIndex = 0;
        for (String token : StringUtils.splitByWholeSeparatorPreserveAllTokens((String)searchTerm, (String)"|")) {
            Matcher terms = SPLIT_PATTERN.matcher(token);
            CompoundArgument.Builder builder = CompoundArgument.builder();
            while (terms.find()) {
                AlternativeArgument.Builder alternativeBuilder = AlternativeArgument.builder();
                for (ArgumentType<?, ?> type : ArgumentTypesRegistry.ARGUMENT_TYPE_LIST) {
                    Argument.applyArgument(type, searchTerm, terms, tokenStartIndex, alternativeBuilder, true, sink);
                    if (alternativeBuilder.isEmpty()) continue;
                    break;
                }
                if (alternativeBuilder.isEmpty()) {
                    for (ArgumentType<?, ?> type : ArgumentTypesRegistry.ARGUMENT_TYPE_LIST) {
                        Argument.applyArgument(type, searchTerm, terms, tokenStartIndex, alternativeBuilder, false, sink);
                    }
                }
                builder.add(alternativeBuilder);
            }
            compoundArguments.add(builder.build());
            if (sink == null || (tokenStartIndex += 1 + token.length()) - 1 >= searchTerm.length()) continue;
            sink.addSplitter(tokenStartIndex - 1);
        }
        Argument.prepareSearchFilter(compoundArguments);
        return compoundArguments;
    }

    private static void prepareSearchFilter(List<CompoundArgument> compoundArguments) {
        for (CompoundArgument arguments : compoundArguments) {
            Iterator iterator = arguments.iterator();
            while (iterator.hasNext()) {
                AlternativeArgument alternativeArgument = (AlternativeArgument)((Object)iterator.next());
                Iterator iterator2 = alternativeArgument.iterator();
                while (iterator2.hasNext()) {
                    Argument argument = (Argument)iterator2.next();
                    argument.filterData = argument.argumentType.prepareSearchFilter(argument.getText());
                }
            }
        }
    }

    private static void applyArgument(ArgumentType<?, ?> type, String searchTerm, Matcher terms, int tokenStartIndex, AlternativeArgument.Builder alternativeBuilder, boolean forceGrammar, @Nullable ProcessedSink sink) {
        String term = (String)MoreObjects.firstNonNull((Object)terms.group(1), (Object)terms.group(2));
        if (type.getSearchMode() == SearchMode.NEVER) {
            return;
        }
        ArgumentApplicableResult result = type.checkApplicable(term, forceGrammar);
        if (result.isApplicable()) {
            int group = terms.group(1) != null ? 1 : 2;
            Argument argument = new Argument(type, result.getText(), !result.isInverted(), terms.start(group) + tokenStartIndex, terms.end(group) + tokenStartIndex, !result.shouldPreserveCasing());
            alternativeBuilder.add(argument);
            if (sink != null) {
                if (group == 1) {
                    sink.addQuote(terms.start() + tokenStartIndex);
                    if (terms.end() - 1 + tokenStartIndex < searchTerm.length()) {
                        sink.addQuote(terms.end() - 1 + tokenStartIndex);
                    }
                }
                sink.addPart(argument, result.isUsingGrammar(), result.grammarRanges(), terms.start() + tokenStartIndex);
            }
        }
    }

    @ApiStatus.Internal
    public static boolean matches(EntryStack<?> stack, List<CompoundArgument> compoundArguments) {
        if (compoundArguments.isEmpty()) {
            return true;
        }
        String newLanguage = class_310.method_1551().field_1690.field_1883;
        if (!Objects.equals(lastLanguage.getAndSet(newLanguage), newLanguage)) {
            SEARCH_CACHE.clear();
        }
        block0: for (CompoundArgument arguments : compoundArguments) {
            Iterator iterator = arguments.iterator();
            while (iterator.hasNext()) {
                AlternativeArgument argument = (AlternativeArgument)((Object)iterator.next());
                if (Argument.matches(stack, argument)) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    private static <T, R, Z, B> boolean matches(EntryStack<?> stack, AlternativeArgument alternativeArgument) {
        if (alternativeArgument.isEmpty()) {
            return true;
        }
        long hashExact = EntryStacks.hashExact(stack);
        Iterator iterator = alternativeArgument.iterator();
        while (iterator.hasNext()) {
            Argument argument = (Argument)iterator.next();
            if (Argument.matches(argument.getArgument(), stack, hashExact, argument.getText(), argument.filterData) != argument.isRegular()) continue;
            return true;
        }
        return false;
    }

    private static Long2ObjectMap<Object> getSearchCache(ArgumentType<?, ?> argumentType) {
        short argumentIndex = (short)argumentType.getIndex();
        Long2ObjectMap map = (Long2ObjectMap)SEARCH_CACHE.get(argumentIndex);
        if (map == null) {
            map = Long2ObjectMaps.synchronize((Long2ObjectMap)new Long2ObjectOpenHashMap());
            SEARCH_CACHE.put(argumentIndex, (Object)map);
        }
        return map;
    }

    private static <T, R, B> boolean matches(ArgumentType<T, B> argumentType, EntryStack<?> stack, long hashExact, String filter, R filterData) {
        Long2ObjectMap<Object> map = Argument.getSearchCache(argumentType);
        Object value = map.get(hashExact);
        if (value == null) {
            value = argumentType.cacheData(stack);
            map.put(hashExact, value);
        }
        return argumentType.matches(value, stack, filter, filterData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepareFilter(Collection<EntryStack<?>> stacks, Collection<ArgumentType<?, ?>> argumentTypes) {
        block11: {
            if (prepareStage != null || currentStages != null) {
                return;
            }
            try {
                prepareStart = class_156.method_659();
                prepareStacks = stacks;
                prepareStage = new IntIntMutablePair(0, argumentTypes.size());
                currentStages = new IntIntPair[argumentTypes.size()];
                List<HashedEntryStackWrapper> hashedStacks = CollectionUtils.map(stacks, HashedEntryStackWrapper::new);
                int searchPartitionSize = ConfigObject.getInstance().getAsyncSearchPartitionSize();
                boolean async = ConfigObject.getInstance().shouldAsyncSearch() && stacks.size() > searchPartitionSize * 4;
                ArrayList futures = Lists.newArrayList();
                ArrayList pairs = Lists.newArrayList();
                for (ArgumentType<?, ?> argumentType : argumentTypes) {
                    prepareStage.first(prepareStage.firstInt() + 1);
                    Long2ObjectMap<Object> map = Argument.getSearchCache(argumentType);
                    IntIntMutablePair intIntMutablePair = new IntIntMutablePair(0, hashedStacks.size());
                    Argument.currentStages[Argument.prepareStage.firstInt() - 1] = intIntMutablePair;
                    IntIntMutablePair currentStage = intIntMutablePair;
                    if (async) {
                        for (Collection collection : CollectionUtils.partition(hashedStacks, searchPartitionSize)) {
                            CompletionStage future = CompletableFuture.supplyAsync(() -> {
                                Long2ObjectArrayMap out = new Long2ObjectArrayMap(searchPartitionSize + 1);
                                for (HashedEntryStackWrapper stack : partitionStacks) {
                                    Object data;
                                    if (map.get(stack.hashExact()) != null || (data = argumentType.cacheData(stack.unwrap())) == null) continue;
                                    out.put(stack.hashExact(), data);
                                }
                                return out;
                            }).whenComplete((arg_0, arg_1) -> Argument.lambda$prepareFilter$1((IntIntPair)currentStage, collection, arg_0, arg_1));
                            futures.add(future);
                            pairs.add(Pair.of(argumentType, (Object)future));
                        }
                        continue;
                    }
                    for (HashedEntryStackWrapper hashedEntryStackWrapper : hashedStacks) {
                        Object data;
                        currentStage.first(currentStage.firstInt() + 1);
                        if (map.get(hashedEntryStackWrapper.hashExact()) != null || (data = argumentType.cacheData(hashedEntryStackWrapper.unwrap())) == null) continue;
                        map.put(hashedEntryStackWrapper.hashExact(), data);
                    }
                }
                if (!async) break block11;
                try {
                    CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).get(30L, TimeUnit.SECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    e.printStackTrace();
                }
                for (Pair pair : pairs) {
                    Long2ObjectMap now = ((CompletableFuture)pair.second()).getNow(null);
                    if (now == null) continue;
                    Argument.getSearchCache((ArgumentType)pair.left()).putAll((Map)now);
                }
            }
            finally {
                prepareStart = null;
                prepareStacks = null;
                prepareStage = null;
                currentStages = null;
            }
        }
    }

    public ArgumentType<?, ?> getArgument() {
        return this.argumentType;
    }

    public String getText() {
        return this.text;
    }

    public boolean isRegular() {
        return this.regular;
    }

    public String toString() {
        return String.format("Argument[%s]: name = %s, regular = %b", this.argumentType.getName(), this.text, this.regular);
    }

    private static /* synthetic */ void lambda$prepareFilter$1(IntIntPair currentStage, Collection partitionStacks, Long2ObjectMap objectLong2ObjectMap, Throwable throwable) {
        currentStage.first(currentStage.firstInt() + partitionStacks.size());
    }

    public static interface ProcessedSink {
        public void addQuote(int var1);

        public void addSplitter(int var1);

        public void addPart(Argument<?, ?> var1, boolean var2, Collection<IntRange> var3, int var4);
    }
}

