/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer.server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import mjson.Json;
import net.fabricmc.installer.LoaderVersion;
import net.fabricmc.installer.util.InstallerProgress;
import net.fabricmc.installer.util.Library;
import net.fabricmc.installer.util.Reference;
import net.fabricmc.installer.util.Utils;

public class ServerInstaller {
    private static final String servicesDir = "META-INF/services/";
    private static final String manifestPath = "META-INF/MANIFEST.MF";
    public static final String DEFAULT_LAUNCH_JAR_NAME = "fabric-server-launch.jar";
    private static final Pattern SIGNATURE_FILE_PATTERN = Pattern.compile("META-INF/[^/]+\\.(SF|DSA|RSA|EC)");

    public static void install(Path dir, LoaderVersion loaderVersion, String gameVersion, InstallerProgress progress) throws IOException {
        Path launchJar = dir.resolve(DEFAULT_LAUNCH_JAR_NAME);
        ServerInstaller.install(dir, loaderVersion, gameVersion, progress, launchJar);
    }

    public static void install(Path dir, LoaderVersion loaderVersion, String gameVersion, InstallerProgress progress, Path launchJar) throws IOException {
        String mainClassMeta;
        progress.updateProgress(new MessageFormat(Utils.BUNDLE.getString("progress.installing.server")).format(new Object[]{String.format("%s(%s)", loaderVersion.name, gameVersion)}));
        Files.createDirectories(dir, new FileAttribute[0]);
        Path libsDir = dir.resolve("libraries");
        Files.createDirectories(libsDir, new FileAttribute[0]);
        progress.updateProgress(Utils.BUNDLE.getString("progress.download.libraries"));
        ArrayList<Library> libraries = new ArrayList<Library>();
        if (loaderVersion.path == null) {
            Json json = Json.read(Utils.readTextFile(new URL(Reference.getMetaServerEndpoint(String.format("v2/versions/loader/%s/%s/server/json", gameVersion, loaderVersion.name)))));
            for (Json libraryJson : json.at("libraries").asJsonList()) {
                libraries.add(new Library(libraryJson));
            }
            mainClassMeta = json.at("mainClass").asString();
        } else {
            libraries.add(new Library(String.format("net.fabricmc:fabric-loader:%s", loaderVersion.name), null, loaderVersion.path));
            libraries.add(new Library(String.format("net.fabricmc:intermediary:%s", gameVersion), "https://maven.fabricmc.net/", null));
            try (ZipFile zf = new ZipFile(loaderVersion.path.toFile());){
                ZipEntry entry = zf.getEntry("fabric-installer.json");
                Json json = Json.read(Utils.readString(zf.getInputStream(entry)));
                Json librariesElem = json.at("libraries");
                for (Json libraryJson : librariesElem.at("common").asJsonList()) {
                    libraries.add(new Library(libraryJson));
                }
                for (Json libraryJson : librariesElem.at("server").asJsonList()) {
                    libraries.add(new Library(libraryJson));
                }
                mainClassMeta = json.at("mainClass").at("server").asString();
            }
        }
        String mainClassManifest = "net.fabricmc.loader.launch.server.FabricServerLauncher";
        ArrayList<Path> libraryFiles = new ArrayList<Path>();
        for (Library library : libraries) {
            Path libraryFile = libsDir.resolve(library.getPath());
            if (library.inputPath == null) {
                progress.updateProgress(new MessageFormat(Utils.BUNDLE.getString("progress.download.library.entry")).format(new Object[]{library.name}));
                Utils.downloadFile(new URL(library.getURL()), libraryFile);
            } else {
                Files.createDirectories(libraryFile.getParent(), new FileAttribute[0]);
                Files.copy(library.inputPath, libraryFile, StandardCopyOption.REPLACE_EXISTING);
            }
            libraryFiles.add(libraryFile);
            if (!library.name.matches("net\\.fabricmc:fabric-loader:.*")) continue;
            try (JarFile jarFile = new JarFile(libraryFile.toFile());){
                Manifest manifest = jarFile.getManifest();
                mainClassManifest = manifest.getMainAttributes().getValue("Main-Class");
            }
        }
        progress.updateProgress(Utils.BUNDLE.getString("progress.generating.launch.jar"));
        boolean shadeLibraries = Utils.compareVersions(loaderVersion.name, "0.12.5") <= 0;
        ServerInstaller.makeLaunchJar(launchJar, mainClassMeta, mainClassManifest, libraryFiles, shadeLibraries, progress);
    }

    private static void makeLaunchJar(Path file, String launchMainClass, String jarMainClass, List<Path> libraryFiles, boolean shadeLibraries, InstallerProgress progress) throws IOException {
        Files.deleteIfExists(file);
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(Files.newOutputStream(file, new OpenOption[0]));){
            HashSet<String> addedEntries = new HashSet<String>();
            addedEntries.add(manifestPath);
            zipOutputStream.putNextEntry(new ZipEntry(manifestPath));
            Manifest manifest = new Manifest();
            Attributes mainAttributes = manifest.getMainAttributes();
            mainAttributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
            mainAttributes.put(Attributes.Name.MAIN_CLASS, jarMainClass);
            if (!shadeLibraries) {
                mainAttributes.put(Attributes.Name.CLASS_PATH, libraryFiles.stream().map(f -> file.getParent().relativize((Path)f).normalize().toString().replace("\\", "/")).collect(Collectors.joining(" ")));
            }
            manifest.write(zipOutputStream);
            zipOutputStream.closeEntry();
            addedEntries.add("fabric-server-launch.properties");
            zipOutputStream.putNextEntry(new ZipEntry("fabric-server-launch.properties"));
            zipOutputStream.write(("launch.mainClass=" + launchMainClass + "\n").getBytes(StandardCharsets.UTF_8));
            zipOutputStream.closeEntry();
            if (shadeLibraries) {
                HashMap<String, Set<String>> services = new HashMap<String, Set<String>>();
                byte[] buffer = new byte[32768];
                for (Path path : libraryFiles) {
                    progress.updateProgress(new MessageFormat(Utils.BUNDLE.getString("progress.generating.launch.jar.library")).format(new Object[]{path.getFileName().toString()}));
                    try (JarInputStream jis = new JarInputStream(Files.newInputStream(path, new OpenOption[0]));){
                        JarEntry entry;
                        while ((entry = jis.getNextJarEntry()) != null) {
                            int r;
                            if (entry.isDirectory()) continue;
                            String name = entry.getName();
                            if (name.startsWith(servicesDir) && name.indexOf(47, servicesDir.length()) < 0) {
                                ServerInstaller.parseServiceDefinition(name, jis, services);
                                continue;
                            }
                            if (SIGNATURE_FILE_PATTERN.matcher(name).matches()) continue;
                            if (!addedEntries.add(name)) {
                                System.out.printf("duplicate file: %s%n", name);
                                continue;
                            }
                            JarEntry newEntry = new JarEntry(name);
                            zipOutputStream.putNextEntry(newEntry);
                            while ((r = jis.read(buffer, 0, buffer.length)) >= 0) {
                                zipOutputStream.write(buffer, 0, r);
                            }
                            zipOutputStream.closeEntry();
                        }
                    }
                }
                for (Map.Entry entry : services.entrySet()) {
                    JarEntry newEntry = new JarEntry((String)entry.getKey());
                    zipOutputStream.putNextEntry(newEntry);
                    ServerInstaller.writeServiceDefinition((Collection)entry.getValue(), zipOutputStream);
                    zipOutputStream.closeEntry();
                }
            }
        }
    }

    private static void parseServiceDefinition(String name, InputStream rawIs, Map<String, Set<String>> services) throws IOException {
        String line;
        Collection out = null;
        BufferedReader reader = new BufferedReader(new InputStreamReader(rawIs, StandardCharsets.UTF_8));
        while ((line = reader.readLine()) != null) {
            int pos = line.indexOf(35);
            if (pos >= 0) {
                line = line.substring(0, pos);
            }
            if ((line = line.trim()).isEmpty()) continue;
            if (out == null) {
                out = services.computeIfAbsent(name, ignore -> new LinkedHashSet());
            }
            out.add(line);
        }
    }

    private static void writeServiceDefinition(Collection<String> defs, OutputStream os) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));
        for (String def : defs) {
            writer.write(def);
            writer.write(10);
        }
        writer.flush();
    }
}

