/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer.util;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mjson.Json;
import net.fabricmc.installer.util.CompletableHandler;
import net.fabricmc.installer.util.Utils;

public class MetaHandler
extends CompletableHandler<List<GameVersion>> {
    private final String metaUrl;
    private List<GameVersion> versions;

    public MetaHandler(String url) {
        this.metaUrl = url;
    }

    public void load() throws IOException {
        URL url = new URL(this.metaUrl);
        Json json = Json.read(Utils.readTextFile(url));
        this.versions = json.asJsonList().stream().map(GameVersion::new).collect(Collectors.toList());
        this.complete(this.versions);
    }

    public List<GameVersion> getVersions() {
        return Collections.unmodifiableList(this.versions);
    }

    public GameVersion getLatestVersion(boolean snapshot) {
        if (this.versions.isEmpty()) {
            throw new RuntimeException("no versions available at " + this.metaUrl);
        }
        if (!snapshot) {
            for (GameVersion version : this.versions) {
                if (!version.isStable()) continue;
                return version;
            }
        }
        return this.versions.get(0);
    }

    public static class GameVersion {
        String version;
        boolean stable;

        public GameVersion(Json json) {
            this.version = json.at("version").asString();
            this.stable = json.at("stable").asBoolean();
        }

        public String getVersion() {
            return this.version;
        }

        public boolean isStable() {
            return this.stable;
        }
    }
}

