/*
 * Decompiled with CFR 0.152.
 */
package net.boostedbrightness;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;

public class BoostedBrightness
implements ClientModInitializer {
    public static final int MAX_BRIGHTNESSES = 5;
    private static final Gson GSON = new Gson();
    public static double minBrightness = -1.0;
    public static double maxBrightness = 12.0;
    public static double brightnessSliderInterval = 0.05;
    private static double step = 0.1;
    public static ArrayList<Double> brightnesses;
    private static int brightnessIndex;
    private static int lastBrightnessIndex;
    private static final class_304 NEXT_BIND;
    private static final class_304 RAISE_BIND;
    private static final class_304 LOWER_BIND;
    private static final class_304[] SELECT_BINDS;
    public static class_310 client;

    public void onInitializeClient() {
        KeyBindingHelper.registerKeyBinding((class_304)NEXT_BIND);
        KeyBindingHelper.registerKeyBinding((class_304)RAISE_BIND);
        KeyBindingHelper.registerKeyBinding((class_304)LOWER_BIND);
        for (int i = 0; i < 5; ++i) {
            BoostedBrightness.SELECT_BINDS[i] = new class_304("key.boosted-brightness.select" + (i + 1), class_3675.class_307.field_1668, -1, "category.boosted-brightness.title");
            KeyBindingHelper.registerKeyBinding((class_304)SELECT_BINDS[i]);
        }
        ClientTickEvents.END_CLIENT_TICK.register(this::onEndTick);
        this.loadConfig();
        client = class_310.method_1551();
    }

    public static int numBrightnesses() {
        return brightnesses.size();
    }

    public static int getBrightnessIndex() {
        return brightnessIndex;
    }

    public static void setBrightnessIndex(int index) {
        brightnessIndex = index;
        BoostedBrightness.client.field_1690.method_42473().method_41748((Object)BoostedBrightness.getBrightness());
    }

    public static double getBrightness() {
        return brightnesses.get(brightnessIndex);
    }

    public static double getBrightness(int index) {
        return brightnesses.get(index);
    }

    public static void changeBrightness(double brightness) {
        brightnesses.set(BoostedBrightness.getBrightnessIndex(), brightness);
        BoostedBrightness.client.field_1690.method_42473().method_41748((Object)BoostedBrightness.getBrightness());
    }

    public static void changeBrightness(int index, double brightness) {
        if (index == brightnessIndex) {
            BoostedBrightness.changeBrightness(brightness);
        } else {
            brightnesses.set(index, brightness);
        }
    }

    private void loadConfig() {
        try {
            JsonObject config = (JsonObject)GSON.fromJson(new String(Files.readAllBytes(BoostedBrightness.getConfigPath())), JsonObject.class);
            this.asDouble(config.get("min"), min -> {
                minBrightness = min;
            });
            this.asDouble(config.get("max"), max -> {
                maxBrightness = max;
            });
            this.asDouble(config.get("step"), step -> {
                BoostedBrightness.step = step;
            });
            brightnesses = new ArrayList();
            for (int i = 1; i <= 5 && config.has(String.valueOf(i)); ++i) {
                this.asDouble(config.get(String.valueOf(i)), brightness -> brightnesses.add(brightness));
            }
            this.asInt(config.get("selected"), selected -> {
                brightnessIndex = selected - 1;
            });
            brightnessIndex = Math.max(0, Math.min(BoostedBrightness.numBrightnesses() - 1, brightnessIndex));
            if (config.has("last")) {
                this.asInt(config.get("last"), last -> {
                    lastBrightnessIndex = last - 1;
                });
                lastBrightnessIndex = Math.max(0, Math.min(BoostedBrightness.numBrightnesses() - 1, lastBrightnessIndex));
            } else {
                lastBrightnessIndex = 0;
            }
        }
        catch (JsonSyntaxException | IOException ex) {
            BoostedBrightness.logException((Exception)ex, "Failed to load BoostedBrightness config");
        }
        if (brightnesses == null || brightnesses.size() < 2) {
            brightnesses = new ArrayList();
            brightnesses.add(1.0);
            brightnesses.add(maxBrightness);
            brightnessIndex = 0;
            lastBrightnessIndex = 0;
        }
    }

    public static void saveConfig() {
        JsonObject config = new JsonObject();
        config.addProperty("min", (Number)minBrightness);
        config.addProperty("max", (Number)maxBrightness);
        config.addProperty("step", (Number)step);
        config.addProperty("selected", (Number)(brightnessIndex + 1));
        config.addProperty("last", (Number)(lastBrightnessIndex + 1));
        for (int i = 0; i < brightnesses.size(); ++i) {
            config.addProperty(String.valueOf(i + 1), (Number)brightnesses.get(i));
        }
        try {
            Files.write(BoostedBrightness.getConfigPath(), GSON.toJson((JsonElement)config).getBytes(), new OpenOption[0]);
        }
        catch (IOException ex) {
            BoostedBrightness.logException(ex, "Failed to save BoostedBrightness config");
        }
    }

    private static Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir().resolve("boostedbrightness.json");
    }

    private void asDouble(JsonElement element, DoubleConsumer onSuccess) {
        if (element != null && element.isJsonPrimitive() && ((JsonPrimitive)element).isNumber()) {
            onSuccess.accept(element.getAsDouble());
        }
    }

    private void asInt(JsonElement element, IntConsumer onSuccess) {
        if (element != null && element.isJsonPrimitive() && ((JsonPrimitive)element).isNumber()) {
            onSuccess.accept(element.getAsInt());
        }
    }

    private void showOverlay(class_310 client) {
        client.field_1705.method_1758((class_2561)class_2561.method_43469((String)"overlay.boosted-brightness.change", (Object[])new Object[]{BoostedBrightness.getBrightnessIndex() + 1, Math.round(BoostedBrightness.getBrightness() * 100.0)}).method_27694(s -> s.method_10977(class_124.field_1060)), false);
    }

    private void onEndTick(class_310 client) {
        while (NEXT_BIND.method_1436()) {
            lastBrightnessIndex = BoostedBrightness.getBrightnessIndex();
            BoostedBrightness.setBrightnessIndex((lastBrightnessIndex + 1) % BoostedBrightness.numBrightnesses());
            this.showOverlay(client);
        }
        for (int i = 0; i < BoostedBrightness.numBrightnesses(); ++i) {
            while (SELECT_BINDS[i].method_1436()) {
                int nextBrightnessIndex = i != brightnessIndex ? i : lastBrightnessIndex;
                lastBrightnessIndex = BoostedBrightness.getBrightnessIndex();
                BoostedBrightness.setBrightnessIndex(nextBrightnessIndex);
                this.showOverlay(client);
            }
        }
        double offset = 0.0;
        while (RAISE_BIND.method_1436()) {
            offset += step;
        }
        while (LOWER_BIND.method_1436()) {
            offset -= step;
        }
        if (offset != 0.0) {
            double brightness = Math.max(minBrightness, Math.min(maxBrightness, BoostedBrightness.getBrightness() + offset));
            BoostedBrightness.changeBrightness(brightness);
            this.showOverlay(client);
        }
    }

    public static void logException(Exception ex, String message) {
        System.err.printf("[BoostedBrightness] %s (%s: %s)", message, ex.getClass().getSimpleName(), ex.getLocalizedMessage());
    }

    static {
        brightnessIndex = 0;
        lastBrightnessIndex = 0;
        NEXT_BIND = new class_304("key.boosted-brightness.next", class_3675.class_307.field_1668, 66, "category.boosted-brightness.title");
        RAISE_BIND = new class_304("key.boosted-brightness.raise", class_3675.class_307.field_1668, 93, "category.boosted-brightness.title");
        LOWER_BIND = new class_304("key.boosted-brightness.lower", class_3675.class_307.field_1668, 91, "category.boosted-brightness.title");
        SELECT_BINDS = new class_304[5];
    }
}

