/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays.brewing;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.brewing.BrewingRecipe;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class DefaultBrewingDisplay
implements Display {
    private EntryStack<?> output;
    private EntryIngredient reactant;
    private EntryIngredient input;

    public DefaultBrewingDisplay(BrewingRecipe recipe) {
        this(recipe.input, recipe.ingredient, recipe.output);
    }

    public DefaultBrewingDisplay(class_1856 input, class_1856 reactant, class_1799 output) {
        this(EntryIngredients.ofIngredient(input), EntryIngredients.ofIngredient(reactant), EntryStacks.of(output));
    }

    public DefaultBrewingDisplay(EntryIngredient input, EntryIngredient reactant, EntryStack<?> output) {
        this.input = input.map(stack -> stack.copy().tooltip(new class_2561[]{class_2561.method_43471((String)"category.rei.brewing.input").method_27692(class_124.field_1054)}));
        this.reactant = reactant.map(stack -> stack.copy().tooltip(new class_2561[]{class_2561.method_43471((String)"category.rei.brewing.reactant").method_27692(class_124.field_1054)}));
        this.output = output.copy().tooltip(new class_2561[]{class_2561.method_43471((String)"category.rei.brewing.result").method_27692(class_124.field_1054)});
    }

    @Override
    public List<EntryIngredient> getInputEntries() {
        return Lists.newArrayList((Object[])new EntryIngredient[]{this.input, this.reactant});
    }

    @Override
    public List<EntryIngredient> getOutputEntries() {
        return Collections.singletonList(EntryIngredient.of(this.output));
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.BREWING;
    }

    public List<EntryStack<?>> getOutput(int slot) {
        int i;
        ArrayList stack = new ArrayList();
        for (i = 0; i < slot * 2; ++i) {
            stack.add(EntryStack.empty());
        }
        for (i = 0; i < 6 - slot * 2; ++i) {
            stack.add(this.output);
        }
        return stack;
    }

    public static DisplaySerializer<DefaultBrewingDisplay> serializer() {
        return new DisplaySerializer<DefaultBrewingDisplay>(){

            @Override
            public class_2487 save(class_2487 tag, DefaultBrewingDisplay display) {
                tag.method_10566("input", (class_2520)display.input.save());
                tag.method_10566("reactant", (class_2520)display.reactant.save());
                tag.method_10566("output", (class_2520)display.output.save());
                return tag;
            }

            @Override
            public DefaultBrewingDisplay read(class_2487 tag) {
                EntryIngredient input = EntryIngredient.read(tag.method_10554("input", 10));
                EntryIngredient reactant = EntryIngredient.read(tag.method_10554("reactant", 10));
                EntryStack<?> output = EntryStack.read(tag.method_10562("output"));
                return new DefaultBrewingDisplay(input, reactant, output);
            }
        };
    }
}

