/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack.option;

import com.google.common.collect.ImmutableSet;
import net.coderbot.iris.shaderpack.option.BooleanOption;
import net.coderbot.iris.shaderpack.option.OptionLocation;
import org.jetbrains.annotations.Nullable;

public class MergedBooleanOption {
    private final BooleanOption option;
    private final ImmutableSet<OptionLocation> locations;

    MergedBooleanOption(BooleanOption booleanOption, ImmutableSet<OptionLocation> immutableSet) {
        this.option = booleanOption;
        this.locations = immutableSet;
    }

    public MergedBooleanOption(OptionLocation optionLocation, BooleanOption booleanOption) {
        this.option = booleanOption;
        this.locations = ImmutableSet.of((Object)optionLocation);
    }

    @Nullable
    public MergedBooleanOption merge(MergedBooleanOption mergedBooleanOption) {
        if (this.option.getDefaultValue() != mergedBooleanOption.option.getDefaultValue()) {
            return null;
        }
        BooleanOption booleanOption = this.option.getComment().isPresent() ? this.option : mergedBooleanOption.option;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(this.locations);
        builder.addAll(mergedBooleanOption.locations);
        return new MergedBooleanOption(booleanOption, (ImmutableSet<OptionLocation>)builder.build());
    }

    public BooleanOption getOption() {
        return this.option;
    }

    public ImmutableSet<OptionLocation> getLocations() {
        return this.locations;
    }
}

