/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.render;

import java.util.function.Function;
import link.infra.indium.other.SpriteFinderCache;
import link.infra.indium.renderer.mesh.MutableQuadViewImpl;
import link.infra.indium.renderer.render.BaseQuadRenderer;
import me.jellysquid.mods.sodium.client.model.IndexBufferBuilder;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadWinding;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexSink;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;

public abstract class ChunkQuadBufferer
implements BaseQuadRenderer.QuadBufferer {
    protected final Function<class_1921, ChunkModelBuilder> builderFunc;

    protected abstract class_2382 origin();

    protected abstract class_243 blockOffset();

    ChunkQuadBufferer(Function<class_1921, ChunkModelBuilder> builderFunc) {
        this.builderFunc = builderFunc;
    }

    @Override
    public void bufferQuad(MutableQuadViewImpl quad, class_1921 renderLayer) {
        ChunkQuadBufferer.bufferQuad(this.builderFunc.apply(renderLayer), quad, this.origin(), this.blockOffset());
    }

    public static void bufferQuad(ChunkModelBuilder builder, MutableQuadViewImpl quad, class_2382 origin, class_243 blockOffset) {
        ModelVertexSink vertices = builder.getVertexSink();
        vertices.ensureCapacity(4);
        class_2350 cullFace = quad.cullFace();
        IndexBufferBuilder indices = builder.getIndexBufferBuilder(cullFace != null ? ModelQuadFacing.fromDirection((class_2350)cullFace) : ModelQuadFacing.UNASSIGNED);
        int vertexStart = vertices.getVertexCount();
        for (int i = 0; i < 4; ++i) {
            float x = quad.x(i) + (float)blockOffset.method_10216();
            float y = quad.y(i) + (float)blockOffset.method_10214();
            float z = quad.z(i) + (float)blockOffset.method_10215();
            int color = quad.spriteColor(i, 0);
            color = ColorABGR.pack((int)(color & 0xFF), (int)(color >> 8 & 0xFF), (int)(color >> 16 & 0xFF), (int)(color >> 24 & 0xFF));
            float u = quad.spriteU(i, 0);
            float v = quad.spriteV(i, 0);
            int lm = quad.lightmap(i);
            vertices.writeVertex(origin, x, y, z, color, u, v, lm, builder.getChunkId());
        }
        indices.add(vertexStart, ModelQuadWinding.CLOCKWISE);
        class_1058 sprite = quad.cachedSprite();
        if (sprite == null) {
            sprite = SpriteFinderCache.forBlockAtlas().find((QuadView)quad, 0);
        }
        builder.addSprite(sprite);
        vertices.flush();
    }
}

