/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.uniform;

import java.util.function.Supplier;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.uniform.Uniform;
import net.coderbot.iris.gl.uniform.ValueUpdateNotifier;
import net.coderbot.iris.vendored.joml.Vector4i;

public class Vector4IntegerJomlUniform
extends Uniform {
    private Vector4i cachedValue = null;
    private final Supplier<Vector4i> value;

    Vector4IntegerJomlUniform(int n, Supplier<Vector4i> supplier) {
        this(n, supplier, null);
    }

    Vector4IntegerJomlUniform(int n, Supplier<Vector4i> supplier, ValueUpdateNotifier valueUpdateNotifier) {
        super(n, valueUpdateNotifier);
        this.value = supplier;
    }

    @Override
    public void update() {
        this.updateValue();
        if (this.notifier != null) {
            this.notifier.setListener(this::updateValue);
        }
    }

    private void updateValue() {
        Vector4i vector4i = this.value.get();
        if (this.cachedValue == null || !vector4i.equals(this.cachedValue)) {
            this.cachedValue = vector4i;
            IrisRenderSystem.uniform4i(this.location, vector4i.x, vector4i.y, vector4i.z, vector4i.w);
        }
    }
}

