/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import net.minecraft.class_1159;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4588;
import net.minecraft.class_5944;

public class HorizonRenderer {
    private static final float TOP = 16.0f;
    private static final float BOTTOM = -16.0f;
    private static final double COS_22_5 = Math.cos(Math.toRadians(22.5));
    private static final double SIN_22_5 = Math.sin(Math.toRadians(22.5));
    private class_291 buffer;
    private int cachedRenderDistance;

    public HorizonRenderer() {
        this.cachedRenderDistance = class_310.method_1551().field_1690.method_38521();
        this.createBuffer();
    }

    private void createBuffer() {
        if (this.buffer != null) {
            this.buffer.close();
        }
        this.buffer = new class_291();
        class_287 class_2872 = class_289.method_1348().method_1349();
        class_2872.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        this.buildHorizon((class_4588)class_2872);
        class_287.class_7433 class_74332 = class_2872.method_1326();
        this.buffer.method_1353();
        this.buffer.method_1352(class_74332);
        class_291.method_1354();
    }

    private void buildQuad(class_4588 class_45882, double d, double d2, double d3, double d4) {
        class_45882.method_22912(d, -16.0, d2);
        class_45882.method_1344();
        class_45882.method_22912(d, 16.0, d2);
        class_45882.method_1344();
        class_45882.method_22912(d3, 16.0, d4);
        class_45882.method_1344();
        class_45882.method_22912(d3, -16.0, d4);
        class_45882.method_1344();
    }

    private void buildHalf(class_4588 class_45882, double d, double d2, boolean bl) {
        if (bl) {
            d = -d;
            d2 = -d2;
        }
        this.buildQuad(class_45882, d, -d2, d2, -d);
        this.buildQuad(class_45882, d, d2, d, -d2);
        this.buildQuad(class_45882, d2, d, d, d2);
        this.buildQuad(class_45882, -d2, d, d2, d);
    }

    private void buildOctagonalPrism(class_4588 class_45882, double d, double d2) {
        this.buildHalf(class_45882, d, d2, false);
        this.buildHalf(class_45882, d, d2, true);
    }

    private void buildRegularOctagonalPrism(class_4588 class_45882, double d) {
        this.buildOctagonalPrism(class_45882, d * COS_22_5, d * SIN_22_5);
    }

    private void buildBottomPlane(class_4588 class_45882, int n) {
        for (int i = -n; i <= n; i += 64) {
            for (int j = -n; j <= n; j += 64) {
                class_45882.method_22912((double)(i + 64), -16.0, (double)j);
                class_45882.method_1344();
                class_45882.method_22912((double)i, -16.0, (double)j);
                class_45882.method_1344();
                class_45882.method_22912((double)i, -16.0, (double)(j + 64));
                class_45882.method_1344();
                class_45882.method_22912((double)(i + 64), -16.0, (double)(j + 64));
                class_45882.method_1344();
            }
        }
    }

    private void buildTopPlane(class_4588 class_45882, int n) {
        for (int i = -n; i <= n; i += 64) {
            for (int j = -n; j <= n; j += 64) {
                class_45882.method_22912((double)(i + 64), 16.0, (double)j);
                class_45882.method_1344();
                class_45882.method_22912((double)(i + 64), 16.0, (double)(j + 64));
                class_45882.method_1344();
                class_45882.method_22912((double)i, 16.0, (double)(j + 64));
                class_45882.method_1344();
                class_45882.method_22912((double)i, 16.0, (double)j);
                class_45882.method_1344();
            }
        }
    }

    private void buildHorizon(class_4588 class_45882) {
        int n = this.getRenderDistanceInBlocks();
        if (n > 256) {
            n = 256;
        }
        this.buildRegularOctagonalPrism(class_45882, n);
        this.buildTopPlane(class_45882, 384);
        this.buildBottomPlane(class_45882, 384);
    }

    private int getRenderDistanceInBlocks() {
        return class_310.method_1551().field_1690.method_38521() * 16;
    }

    public void renderHorizon(class_1159 class_11592, class_1159 class_11593, class_5944 class_59442) {
        if (this.cachedRenderDistance != class_310.method_1551().field_1690.method_38521()) {
            this.cachedRenderDistance = class_310.method_1551().field_1690.method_38521();
            this.createBuffer();
        }
        this.buffer.method_1353();
        this.buffer.method_34427(class_11592, class_11593, class_59442);
        class_291.method_1354();
    }
}

