/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import com.mojang.blaze3d.systems.RenderSystem;
import net.coderbot.iris.gl.state.StateUpdateNotifiers;
import net.coderbot.iris.gl.uniform.DynamicUniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.vendored.joml.Vector3f;
import net.minecraft.class_6854;

public class FogUniforms {
    private FogUniforms() {
    }

    public static void addFogUniforms(DynamicUniformHolder dynamicUniformHolder, FogMode fogMode) {
        if (fogMode == FogMode.OFF) {
            dynamicUniformHolder.uniform1f(UniformUpdateFrequency.ONCE, "fogDensity", () -> 0.0f);
            dynamicUniformHolder.uniform1i(UniformUpdateFrequency.ONCE, "fogMode", () -> 0);
            dynamicUniformHolder.uniform1i(UniformUpdateFrequency.ONCE, "fogShape", () -> -1);
        } else if (fogMode == FogMode.PER_VERTEX || fogMode == FogMode.PER_FRAGMENT) {
            dynamicUniformHolder.uniform1i("fogMode", () -> {
                float f = CapturedRenderingState.INSTANCE.getFogDensity();
                if (f < 0.0f) {
                    return 9729;
                }
                return 2049;
            }, runnable -> {});
        }
        dynamicUniformHolder.uniform1f("fogDensity", () -> Math.max(0.0f, CapturedRenderingState.INSTANCE.getFogDensity()), runnable -> {});
        dynamicUniformHolder.uniform1i(UniformUpdateFrequency.PER_FRAME, "fogShape", () -> RenderSystem.getShaderFogShape() == class_6854.field_36351 ? 1 : 0);
        dynamicUniformHolder.uniform1f("fogStart", RenderSystem::getShaderFogStart, runnable -> StateUpdateNotifiers.fogStartNotifier.setListener(runnable));
        dynamicUniformHolder.uniform1f("fogEnd", RenderSystem::getShaderFogEnd, runnable -> StateUpdateNotifiers.fogEndNotifier.setListener(runnable));
        dynamicUniformHolder.uniform3f(UniformUpdateFrequency.PER_FRAME, "fogColor", () -> {
            float[] fArray = RenderSystem.getShaderFogColor();
            return new Vector3f(fArray[0], fArray[1], fArray[2]);
        });
    }
}

