/*
 * Decompiled with CFR 0.152.
 */
package xaero.map;

import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2189;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2356;
import net.minecraft.class_2368;
import net.minecraft.class_2378;
import net.minecraft.class_2404;
import net.minecraft.class_2464;
import net.minecraft.class_2521;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_2806;
import net.minecraft.class_2812;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3610;
import net.minecraft.class_3620;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_773;
import net.minecraft.class_777;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.biome.BiomeColorCalculator;
import xaero.map.biome.BiomeGetter;
import xaero.map.biome.BiomeKey;
import xaero.map.biome.BlockTintProvider;
import xaero.map.cache.BlockStateShortShapeCache;
import xaero.map.core.XaeroWorldMapCore;
import xaero.map.exception.SilentException;
import xaero.map.misc.CachedFunction;
import xaero.map.region.MapBlock;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.OverlayBuilder;
import xaero.map.region.OverlayManager;

public class MapWriter {
    public static final int NO_Y_VALUE = Short.MAX_VALUE;
    public static final int MAX_TRANSPARENCY_BLEND_DEPTH = 5;
    public static final String[] DEFAULT_RESOURCE = new String[]{"minecraft", ""};
    private int X;
    private int Z;
    private int playerChunkX;
    private int playerChunkZ;
    private int loadDistance;
    private int startTileChunkX;
    private int startTileChunkZ;
    private int endTileChunkX;
    private int endTileChunkZ;
    private int insideX;
    private int insideZ;
    private long updateCounter;
    private boolean clearCachedColours;
    private MapBlock loadingObject;
    private OverlayBuilder overlayBuilder;
    private final class_2338.class_2339 mutableLocalPos;
    private final class_2338.class_2339 mutableGlobalPos;
    private class_5819 usedRandom = class_5819.method_43049((long)0L);
    private long lastWrite = -1L;
    private long lastWriteTry = -1L;
    private int workingFrameCount;
    private long framesFreedTime = -1L;
    public long writeFreeSinceLastWrite = -1L;
    private int writeFreeSizeTiles;
    private int writeFreeFullUpdateTargetTime;
    private MapProcessor mapProcessor;
    private ArrayList<class_2680> buggedStates;
    private BlockStateShortShapeCache blockStateShortShapeCache;
    private int topH;
    private final CachedFunction<class_2688<?, ?>, Boolean> transparentCache;
    private int firstTransparentStateY;
    private final class_2338.class_2339 mutableBlockPos3;
    private CachedFunction<class_3610, class_2680> fluidToBlock;
    private BiomeGetter biomeGetter;
    private HashMap<String, Integer> textureColours;
    private HashMap<class_2680, Integer> blockColours;
    private class_2680 lastBlockStateForTextureColor = null;
    private int lastBlockStateForTextureColorResult = -1;

    public MapWriter(OverlayManager overlayManager, BlockStateShortShapeCache blockStateShortShapeCache, BiomeGetter biomeGetter) {
        this.loadingObject = new MapBlock();
        this.textureColours = new HashMap();
        this.blockColours = new HashMap();
        this.overlayBuilder = new OverlayBuilder(overlayManager);
        this.mutableLocalPos = new class_2338.class_2339();
        this.mutableGlobalPos = new class_2338.class_2339();
        this.buggedStates = new ArrayList();
        this.blockStateShortShapeCache = blockStateShortShapeCache;
        this.transparentCache = new CachedFunction<class_2688, Boolean>(state -> this.shouldOverlay((class_2688<?, ?>)state));
        this.mutableBlockPos3 = new class_2338.class_2339();
        this.fluidToBlock = new CachedFunction<class_3610, class_2680>(class_3610::method_15759);
        this.biomeGetter = biomeGetter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRender(BiomeColorCalculator biomeColorCalculator, OverlayManager overlayManager) {
        block23: {
            long before = System.nanoTime();
            try {
                if (WorldMap.crashHandler.getCrashedBy() != null) break block23;
                Object object = this.mapProcessor.renderThreadPauseSync;
                synchronized (object) {
                    if (!this.mapProcessor.isWritingPaused() && !this.mapProcessor.isWaitingForWorldUpdate() && this.mapProcessor.getMapSaveLoad().isRegionDetectionComplete() && this.mapProcessor.isCurrentMultiworldWritable()) {
                        if (this.mapProcessor.getWorld() == null || !this.mapProcessor.caveStartIsDetermined() || this.mapProcessor.isCurrentMapLocked()) {
                            return;
                        }
                        if (this.mapProcessor.getCurrentWorldId() != null && !this.mapProcessor.ignoreWorld((class_1937)this.mapProcessor.getWorld()) && (WorldMap.settings.updateChunks || WorldMap.settings.loadChunks)) {
                            long passed;
                            double playerZ;
                            double playerY;
                            double playerX;
                            Object object2 = this.mapProcessor.mainStuffSync;
                            synchronized (object2) {
                                if (this.mapProcessor.mainWorld != this.mapProcessor.getWorld()) {
                                    return;
                                }
                                playerX = this.mapProcessor.mainPlayerX;
                                playerY = this.mapProcessor.mainPlayerY;
                                playerZ = this.mapProcessor.mainPlayerZ;
                            }
                            XaeroWorldMapCore.ensureField();
                            int lengthX = this.endTileChunkX - this.startTileChunkX + 1;
                            int lengthZ = this.endTileChunkZ - this.startTileChunkZ + 1;
                            if (this.lastWriteTry == -1L) {
                                lengthX = 3;
                                lengthZ = 3;
                            }
                            int sizeTileChunks = lengthX * lengthZ;
                            int sizeTiles = sizeTileChunks * 4 * 4;
                            int sizeBasedTargetTime = sizeTiles * 1000 / 1500;
                            int fullUpdateTargetTime = Math.max(100, sizeBasedTargetTime);
                            long time = System.currentTimeMillis();
                            long l = passed = this.lastWrite == -1L ? 0L : time - this.lastWrite;
                            if (this.lastWriteTry == -1L || this.writeFreeSizeTiles != sizeTiles || this.writeFreeFullUpdateTargetTime != fullUpdateTargetTime || this.workingFrameCount > 30) {
                                this.framesFreedTime = time;
                                this.writeFreeSizeTiles = sizeTiles;
                                this.writeFreeFullUpdateTargetTime = fullUpdateTargetTime;
                                this.workingFrameCount = 0;
                            }
                            long sinceLastWrite = Math.min(passed, this.writeFreeSinceLastWrite);
                            if (this.framesFreedTime != -1L) {
                                sinceLastWrite = time - this.framesFreedTime;
                            }
                            long tilesToUpdate = Math.min(sinceLastWrite * (long)sizeTiles / (long)fullUpdateTargetTime, 100L);
                            if (this.lastWrite == -1L || tilesToUpdate != 0L) {
                                this.lastWrite = time;
                            }
                            if (tilesToUpdate != 0L) {
                                if (this.framesFreedTime == -1L) {
                                    int timeLimit = (int)(Math.min(sinceLastWrite, 50L) * 86960L);
                                    long writeStartNano = System.nanoTime();
                                    class_2378<class_1959> biomeRegistry = this.mapProcessor.worldBiomeRegistry;
                                    boolean loadChunks = WorldMap.settings.loadChunks;
                                    boolean updateChunks = WorldMap.settings.updateChunks;
                                    boolean ignoreHeightmaps = this.mapProcessor.getMapWorld().isIgnoreHeightmaps();
                                    boolean flowers = WorldMap.settings.flowers;
                                    boolean detailedDebug = WorldMap.settings.detailed_debug;
                                    class_2338.class_2339 mutableBlockPos3 = this.mutableBlockPos3;
                                    BlockTintProvider blockTintProvider = this.mapProcessor.getWorldBlockTintProvider();
                                    int i = 0;
                                    while ((long)i < tilesToUpdate) {
                                        if (this.writeMap((class_1937)this.mapProcessor.getWorld(), playerX, playerY, playerZ, biomeRegistry, biomeColorCalculator, overlayManager, loadChunks, updateChunks, ignoreHeightmaps, flowers, detailedDebug, mutableBlockPos3, blockTintProvider)) {
                                            --i;
                                        }
                                        if (System.nanoTime() - writeStartNano >= (long)timeLimit) break;
                                        ++i;
                                    }
                                    ++this.workingFrameCount;
                                } else {
                                    this.writeFreeSinceLastWrite = sinceLastWrite;
                                    this.framesFreedTime = -1L;
                                }
                            }
                            this.lastWriteTry = time;
                            int startRegionX = this.startTileChunkX >> 3;
                            int startRegionZ = this.startTileChunkZ >> 3;
                            int endRegionX = this.endTileChunkX >> 3;
                            int endRegionZ = this.endTileChunkZ >> 3;
                            for (int visitRegionX = startRegionX; visitRegionX <= endRegionX; ++visitRegionX) {
                                for (int visitRegionZ = startRegionZ; visitRegionZ <= endRegionZ; ++visitRegionZ) {
                                    MapRegion visitRegion = this.mapProcessor.getMapRegion(visitRegionX, visitRegionZ, false);
                                    if (visitRegion == null || visitRegion.getLoadState() != 2) continue;
                                    visitRegion.registerVisit();
                                }
                            }
                        }
                    }
                }
            }
            catch (Throwable e) {
                WorldMap.crashHandler.setCrashedBy(e);
            }
        }
    }

    public int getWriteDistance() {
        return Math.min(32, (Integer)class_310.method_1551().field_1690.method_42503().method_41753());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeMap(class_1937 world, double playerX, double playerY, double playerZ, class_2378<class_1959> biomeRegistry, BiomeColorCalculator biomeColorCalculator, OverlayManager overlayManager, boolean loadChunks, boolean updateChunks, boolean ignoreHeightmaps, boolean flowers, boolean detailedDebug, class_2338.class_2339 mutableBlockPos3, BlockTintProvider blockTintProvider) {
        boolean onlyLoad = loadChunks && (!updateChunks || this.updateCounter % 5L != 0L);
        class_1937 class_19372 = world;
        synchronized (class_19372) {
            if (this.insideX == 0 && this.insideZ == 0) {
                this.playerChunkX = (int)Math.floor(playerX) >> 4;
                this.playerChunkZ = (int)Math.floor(playerZ) >> 4;
                this.loadDistance = this.getWriteDistance();
                this.startTileChunkX = this.playerChunkX - this.loadDistance >> 2;
                this.startTileChunkZ = this.playerChunkZ - this.loadDistance >> 2;
                this.endTileChunkX = this.playerChunkX + this.loadDistance >> 2;
                this.endTileChunkZ = this.playerChunkZ + this.loadDistance >> 2;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl13 : MonitorExitStatement: MONITOREXIT : var19_16
            int tileChunkX = this.startTileChunkX + this.X;
            int tileChunkZ = this.startTileChunkZ + this.Z;
            int tileChunkLocalX = tileChunkX & 7;
            int tileChunkLocalZ = tileChunkZ & 7;
            int chunkX = tileChunkX * 4 + this.insideX;
            int chunkZ = tileChunkZ * 4 + this.insideZ;
            boolean wasSkipped = this.writeChunk(world, this.loadDistance, onlyLoad, biomeRegistry, biomeColorCalculator, overlayManager, loadChunks, updateChunks, ignoreHeightmaps, flowers, detailedDebug, mutableBlockPos3, blockTintProvider, tileChunkX, tileChunkZ, tileChunkLocalX, tileChunkLocalZ, chunkX, chunkZ);
            return wasSkipped && (Math.abs(chunkX - this.playerChunkX) > 8 || Math.abs(chunkZ - this.playerChunkZ) > 8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeChunk(class_1937 world, int distance, boolean onlyLoad, class_2378<class_1959> biomeRegistry, BiomeColorCalculator biomeColorCalculator, OverlayManager overlayManager, boolean loadChunks, boolean updateChunks, boolean ignoreHeightmaps, boolean flowers, boolean detailedDebug, class_2338.class_2339 mutableBlockPos3, BlockTintProvider blockTintProvider, int tileChunkX, int tileChunkZ, int tileChunkLocalX, int tileChunkLocalZ, int chunkX, int chunkZ) {
        int regionX = tileChunkX >> 3;
        int regionZ = tileChunkZ >> 3;
        MapRegion region = this.mapProcessor.getMapRegion(regionX, regionZ, true);
        MapTileChunk tileChunk = null;
        MapTileChunk rightChunk = null;
        MapTileChunk bottomChunk = null;
        MapTileChunk bottomRightChunk = null;
        int worldBottomY = world.method_31607();
        int worldTopY = world.method_31600();
        boolean wasSkipped = true;
        Object object = region.writerThreadPauseSync;
        synchronized (object) {
            if (!region.isWritingPaused()) {
                boolean regionIsResting;
                boolean createdTileChunk = false;
                MapRegion mapRegion = region;
                synchronized (mapRegion) {
                    if (region.getLoadState() == 2) {
                        region.registerVisit();
                    }
                    if (regionIsResting = region.isResting()) {
                        region.setBeingWritten(true);
                        tileChunk = region.getChunk(tileChunkLocalX, tileChunkLocalZ);
                        if (region.getLoadState() == 2 && tileChunk == null) {
                            tileChunk = new MapTileChunk(region, tileChunkX, tileChunkZ);
                            region.setChunk(tileChunkLocalX, tileChunkLocalZ, tileChunk);
                            tileChunk.setLoadState((byte)2);
                            region.setAllCachePrepared(false);
                            createdTileChunk = true;
                        } else if (!(region.reloadHasBeenRequested() || region.recacheHasBeenRequested() || region.getLoadState() != 0 && region.getLoadState() != 4)) {
                            this.mapProcessor.getMapSaveLoad().requestLoad(region, "writing");
                        }
                    }
                }
                if (regionIsResting && region.getLoadState() == 2 && tileChunk != null && tileChunk.getLoadState() == 2) {
                    if (!tileChunk.getLeafTexture().shouldUpload()) {
                        int caveStart = this.mapProcessor.getCaveStart();
                        if (chunkX >= this.playerChunkX - distance && chunkX < this.playerChunkX + distance && chunkZ >= this.playerChunkZ - distance && chunkZ < this.playerChunkZ + distance) {
                            class_2818 chunk = (class_2818)world.method_8402(chunkX, chunkZ, class_2806.field_12803, false);
                            MapTile mapTile = tileChunk.getTile(this.insideX, this.insideZ);
                            boolean chunkUpdated = false;
                            try {
                                chunkUpdated = chunk != null && (mapTile == null || (Boolean)XaeroWorldMapCore.chunkCleanField.get(chunk) == false);
                            }
                            catch (IllegalAccessException | IllegalArgumentException e) {
                                throw new RuntimeException(e);
                            }
                            if (chunkUpdated && !(chunk instanceof class_2812)) {
                                boolean edgeChunk = false;
                                block16: for (int i = -1; i < 2; ++i) {
                                    for (int j = -1; j < 2; ++j) {
                                        class_2818 neighbor;
                                        if (i == 0 && j == 0 || (neighbor = world.method_8497(chunkX + i, chunkZ + j)) != null && !(neighbor instanceof class_2812)) continue;
                                        edgeChunk = true;
                                        break block16;
                                    }
                                }
                                if (!edgeChunk && (mapTile == null && loadChunks || mapTile != null && updateChunks && !onlyLoad)) {
                                    wasSkipped = false;
                                    if (mapTile == null) {
                                        mapTile = this.mapProcessor.getTilePool().get(this.mapProcessor.getCurrentDimension(), chunkX, chunkZ);
                                        tileChunk.setChanged(true);
                                    }
                                    MapTileChunk prevTileChunk = tileChunk.getNeighbourTileChunk(0, -1, this.mapProcessor, false);
                                    MapTileChunk prevTileChunkDiagonal = tileChunk.getNeighbourTileChunk(-1, -1, this.mapProcessor, false);
                                    MapTileChunk prevTileChunkHorisontal = tileChunk.getNeighbourTileChunk(-1, 0, this.mapProcessor, false);
                                    int sectionBasedHeight = this.getSectionBasedHeight(chunk, 64);
                                    class_2902.class_2903 typeWorldSurface = class_2902.class_2903.field_13202;
                                    MapTile bottomTile = this.insideZ < 3 ? tileChunk.getTile(this.insideX, this.insideZ + 1) : null;
                                    MapTile rightTile = this.insideX < 3 ? tileChunk.getTile(this.insideX + 1, this.insideZ) : null;
                                    for (int x = 0; x < 16; ++x) {
                                        for (int z = 0; z < 16; ++z) {
                                            boolean xEdge;
                                            int startHeight;
                                            if (caveStart != Short.MAX_VALUE) {
                                                startHeight = caveStart;
                                            } else {
                                                int mappedHeight = chunk.method_12005(typeWorldSurface, x, z);
                                                startHeight = ignoreHeightmaps || mappedHeight < worldBottomY ? sectionBasedHeight : mappedHeight;
                                            }
                                            if (startHeight >= worldTopY) {
                                                startHeight = worldTopY - 1;
                                            }
                                            MapBlock currentPixel = mapTile.isLoaded() ? mapTile.getBlock(x, z) : null;
                                            this.loadPixel(world, this.loadingObject, currentPixel, chunk, x, z, startHeight, worldBottomY, caveStart != Short.MAX_VALUE, mapTile.wasWrittenOnce(), biomeRegistry, flowers, worldBottomY, mutableBlockPos3);
                                            this.loadingObject.fixHeightType(x, z, mapTile, tileChunk, prevTileChunk, prevTileChunkDiagonal, prevTileChunkHorisontal, this.loadingObject.getEffectiveHeight(this.blockStateShortShapeCache), true, this.blockStateShortShapeCache);
                                            boolean equalsSlopesExcluded = this.loadingObject.equalsSlopesExcluded(currentPixel);
                                            boolean fullyEqual = this.loadingObject.equals(currentPixel, equalsSlopesExcluded);
                                            if (fullyEqual) continue;
                                            MapBlock loadedBlock = this.loadingObject;
                                            mapTile.setBlock(x, z, loadedBlock);
                                            this.loadingObject = currentPixel != null ? currentPixel : new MapBlock();
                                            if (equalsSlopesExcluded) continue;
                                            tileChunk.setChanged(true);
                                            boolean zEdge = z == 15;
                                            boolean bl = xEdge = x == 15;
                                            if (!zEdge && !xEdge || currentPixel != null && currentPixel.getEffectiveHeight(this.blockStateShortShapeCache) == loadedBlock.getEffectiveHeight(this.blockStateShortShapeCache)) continue;
                                            if (zEdge) {
                                                MapTile bottomRightTile;
                                                if (bottomTile == null && this.insideZ == 3 && tileChunkLocalZ < 7) {
                                                    if (bottomChunk == null && (bottomChunk = region.getChunk(tileChunkLocalX, tileChunkLocalZ + 1)) != null) {
                                                        bottomChunk.setChanged(true);
                                                    }
                                                    MapTile mapTile2 = bottomTile = bottomChunk != null ? bottomChunk.getTile(this.insideX, 0) : null;
                                                }
                                                if (bottomTile != null) {
                                                    bottomTile.getBlock(x, 0).setSlopeUnknown(true);
                                                    if (!xEdge) {
                                                        bottomTile.getBlock(x + 1, 0).setSlopeUnknown(true);
                                                    }
                                                }
                                                if (!xEdge) continue;
                                                MapTile mapTile3 = bottomRightTile = this.insideX < 3 && this.insideZ < 3 ? tileChunk.getTile(this.insideX + 1, this.insideZ + 1) : null;
                                                if (bottomRightTile == null && this.insideX == 3 && tileChunkLocalX < 7) {
                                                    if (this.insideZ == 3) {
                                                        if (bottomRightChunk == null && tileChunkLocalZ < 7 && (bottomRightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ + 1)) != null) {
                                                            bottomRightChunk.setChanged(true);
                                                        }
                                                        bottomRightTile = bottomRightChunk != null ? bottomRightChunk.getTile(0, 0) : null;
                                                    } else {
                                                        if (rightChunk == null && (rightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ)) != null) {
                                                            rightChunk.setChanged(true);
                                                        }
                                                        MapTile mapTile4 = bottomRightTile = rightChunk != null ? rightChunk.getTile(0, this.insideZ + 1) : null;
                                                    }
                                                }
                                                if (bottomRightTile == null) continue;
                                                bottomRightTile.getBlock(0, 0).setSlopeUnknown(true);
                                                continue;
                                            }
                                            if (!xEdge) continue;
                                            if (rightTile == null && this.insideX == 3 && rightChunk == null && tileChunkLocalX < 7) {
                                                rightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ);
                                                if (rightChunk != null) {
                                                    rightChunk.setChanged(true);
                                                }
                                                MapTile mapTile5 = rightTile = rightChunk != null ? rightChunk.getTile(0, this.insideZ) : null;
                                            }
                                            if (rightTile == null) continue;
                                            rightTile.getBlock(0, z + 1).setSlopeUnknown(true);
                                        }
                                    }
                                    mapTile.setWorldInterpretationVersion(1);
                                    tileChunk.setTile(this.insideX, this.insideZ, mapTile, this.blockStateShortShapeCache);
                                    mapTile.setWrittenOnce(true);
                                    mapTile.setLoaded(true);
                                    try {
                                        XaeroWorldMapCore.chunkCleanField.set(chunk, true);
                                    }
                                    catch (IllegalAccessException | IllegalArgumentException e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                            }
                        }
                    }
                    if (createdTileChunk) {
                        if (tileChunk.includeInSave()) {
                            region.setHasHadTerrain();
                        }
                        this.mapProcessor.getMapRegionHighlightsPreparer().prepare(region, tileChunkLocalX, tileChunkLocalZ);
                        if (!tileChunk.includeInSave() && !tileChunk.hasHighlightsIfUndiscovered()) {
                            region.setChunk(tileChunkLocalX, tileChunkLocalZ, null);
                            tileChunk = null;
                        }
                    }
                }
            }
        }
        ++this.insideZ;
        if (this.insideZ > 3) {
            this.insideZ = 0;
            ++this.insideX;
            if (this.insideX > 3) {
                this.insideX = 0;
                object = region.writerThreadPauseSync;
                synchronized (object) {
                    if (tileChunk != null && !region.isWritingPaused()) {
                        boolean regionIsStillWritable = false;
                        MapRegion mapRegion = region;
                        synchronized (mapRegion) {
                            boolean bl = regionIsStillWritable = region.isResting() && region.getLoadState() == 2;
                            if (regionIsStillWritable) {
                                region.setBeingWritten(true);
                            }
                        }
                        if (regionIsStillWritable && tileChunk.wasChanged()) {
                            tileChunk.updateBuffers(this.mapProcessor, blockTintProvider, overlayManager, detailedDebug, this.blockStateShortShapeCache);
                            if (bottomChunk == null && tileChunkLocalZ < 7) {
                                bottomChunk = region.getChunk(tileChunkLocalX, tileChunkLocalZ + 1);
                            }
                            if (rightChunk == null && tileChunkLocalX < 7) {
                                rightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ);
                            }
                            if (bottomRightChunk == null && tileChunkLocalX < 7 && tileChunkLocalZ < 7) {
                                bottomRightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ + 1);
                            }
                            if (bottomChunk != null && bottomChunk.wasChanged()) {
                                bottomChunk.updateBuffers(this.mapProcessor, blockTintProvider, overlayManager, detailedDebug, this.blockStateShortShapeCache);
                                bottomChunk.setChanged(false);
                            }
                            if (rightChunk != null && rightChunk.wasChanged()) {
                                rightChunk.setToUpdateBuffers(true);
                                rightChunk.setChanged(false);
                            }
                            if (bottomRightChunk != null && bottomRightChunk.wasChanged()) {
                                bottomRightChunk.setToUpdateBuffers(true);
                                bottomRightChunk.setChanged(false);
                            }
                            tileChunk.setChanged(false);
                        }
                    }
                }
                ++this.Z;
                if (this.Z > this.endTileChunkZ - this.startTileChunkZ) {
                    this.Z = 0;
                    ++this.X;
                    if (this.X > this.endTileChunkX - this.startTileChunkX) {
                        this.X = 0;
                        ++this.updateCounter;
                    }
                }
            }
        }
        return wasSkipped;
    }

    public int getSectionBasedHeight(class_2818 bchunk, int startY) {
        class_2826 searchedSection;
        int i;
        class_2826[] sections = bchunk.method_12006();
        if (sections.length == 0) {
            return 0;
        }
        int chunkBottomY = bchunk.method_31607();
        int playerSection = Math.min(startY - chunkBottomY >> 4, sections.length - 1);
        if (playerSection < 0) {
            playerSection = 0;
        }
        int result = 0;
        for (i = playerSection; i < sections.length; ++i) {
            searchedSection = sections[i];
            if (searchedSection.method_38292()) continue;
            result = chunkBottomY + (i << 4) + 15;
        }
        if (playerSection > 0 && result == 0) {
            for (i = playerSection - 1; i >= 0; --i) {
                searchedSection = sections[i];
                if (searchedSection.method_38292()) continue;
                result = chunkBottomY + (i << 4) + 15;
                break;
            }
        }
        return result;
    }

    public boolean isGlowing(class_2680 state) {
        return (double)state.method_26213() >= 0.5;
    }

    private boolean shouldOverlayCached(class_2688<?, ?> state) {
        return this.transparentCache.apply(state);
    }

    public boolean shouldOverlay(class_2688<?, ?> state) {
        if (state instanceof class_2680) {
            class_2680 blockState = (class_2680)state;
            return blockState.method_26204() instanceof class_2189 || blockState.method_26204() instanceof class_2368 || class_4696.method_23679((class_2680)blockState) == class_1921.method_23583();
        }
        class_3610 fluidState = (class_3610)state;
        return class_4696.method_23680((class_3610)fluidState) == class_1921.method_23583();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInvisible(class_1937 world, class_2680 state, class_2248 b, boolean flowers) {
        if (!(b instanceof class_2404) && state.method_26217() == class_2464.field_11455) {
            return true;
        }
        if (b == class_2246.field_10336) {
            return true;
        }
        if (b == class_2246.field_10479) {
            return true;
        }
        if (b instanceof class_2320 && !(b instanceof class_2521)) {
            return true;
        }
        if ((b instanceof class_2356 || b instanceof class_2521) && !flowers) {
            return true;
        }
        ArrayList<class_2680> arrayList = this.buggedStates;
        synchronized (arrayList) {
            if (this.buggedStates.contains(state)) {
                return true;
            }
        }
        class_3620 materialColor = null;
        try {
            materialColor = state.method_26205((class_1922)world, (class_2338)this.mutableGlobalPos);
        }
        catch (Throwable t) {
            ArrayList<class_2680> arrayList2 = this.buggedStates;
            synchronized (arrayList2) {
                this.buggedStates.add(state);
            }
            WorldMap.LOGGER.info("Broken vanilla map color definition found: " + class_2378.field_11146.method_10221((Object)b));
        }
        return materialColor == null || materialColor.field_16011 == 0;
    }

    public void loadPixel(class_1937 world, MapBlock pixel, MapBlock currentPixel, class_2818 bchunk, int insideX, int insideZ, int highY, int lowY, boolean cave, boolean canReuseBiomeColours, class_2378<class_1959> biomeRegistry, boolean flowers, int worldBottomY, class_2338.class_2339 mutableBlockPos3) {
        pixel.prepareForWriting(worldBottomY);
        this.overlayBuilder.startBuilding();
        boolean underair = !cave;
        class_2680 opaqueState = null;
        byte workingLight = -1;
        this.topH = lowY;
        this.mutableGlobalPos.method_10103((bchunk.method_12004().field_9181 << 4) + insideX, lowY - 1, (bchunk.method_12004().field_9180 << 4) + insideZ);
        boolean shouldExtendTillTheBottom = false;
        int transparentSkipY = 0;
        int h = highY;
        while (h >= lowY) {
            class_2248 b;
            this.mutableLocalPos.method_10103(insideX, h, insideZ);
            class_2680 state = bchunk.method_8320((class_2338)this.mutableLocalPos);
            class_3610 fluidFluidState = bchunk.method_8316((class_2338)this.mutableLocalPos);
            boolean bl = shouldExtendTillTheBottom = !shouldExtendTillTheBottom && !this.overlayBuilder.isEmpty() && this.firstTransparentStateY - h >= 5;
            if (shouldExtendTillTheBottom) {
                for (transparentSkipY = h - 1; transparentSkipY >= lowY; --transparentSkipY) {
                    class_2680 traceState = bchunk.method_8320((class_2338)mutableBlockPos3.method_10103(insideX, transparentSkipY, insideZ));
                    class_3610 traceFluidState = traceState.method_26227();
                    if (!traceFluidState.method_15769()) {
                        if (!this.shouldOverlayCached((class_2688<?, ?>)traceFluidState)) break;
                        if (!(traceState.method_26204() instanceof class_2189) && traceState.method_26204() == this.fluidToBlock.apply(traceFluidState).method_26204()) continue;
                    }
                    if (!this.shouldOverlayCached((class_2688<?, ?>)traceState)) break;
                }
            }
            this.mutableGlobalPos.method_33098(h + 1);
            workingLight = (byte)world.method_8314(class_1944.field_9282, (class_2338)this.mutableGlobalPos);
            this.mutableGlobalPos.method_33098(h);
            if (!fluidFluidState.method_15769()) {
                underair = true;
                class_2680 fluidState = this.fluidToBlock.apply(fluidFluidState);
                if (this.loadPixelHelp(pixel, currentPixel, world, fluidState, workingLight, bchunk, insideX, insideZ, h, canReuseBiomeColours, cave, fluidFluidState, biomeRegistry, transparentSkipY, shouldExtendTillTheBottom, flowers)) {
                    opaqueState = state;
                    break;
                }
            }
            if ((b = state.method_26204()) instanceof class_2189) {
                underair = true;
            } else if (underair && state != null && state.method_26204() != this.fluidToBlock.apply(fluidFluidState).method_26204() && this.loadPixelHelp(pixel, currentPixel, world, state, workingLight, bchunk, insideX, insideZ, h, canReuseBiomeColours, cave, null, biomeRegistry, transparentSkipY, shouldExtendTillTheBottom, flowers)) {
                opaqueState = state;
                break;
            }
            h = shouldExtendTillTheBottom ? transparentSkipY : h - 1;
        }
        if (h < lowY) {
            h = lowY;
        }
        BiomeKey blockBiome = null;
        class_2680 state = opaqueState == null ? class_2246.field_10124.method_9564() : opaqueState;
        byte light = opaqueState == null ? (byte)0 : workingLight;
        this.overlayBuilder.finishBuilding(pixel);
        blockBiome = !canReuseBiomeColours || currentPixel == null || currentPixel.getState() != state ? this.biomeGetter.getBiome(world, (class_2338)this.mutableGlobalPos, biomeRegistry) : currentPixel.getBiome();
        if (this.overlayBuilder.getOverlayBiome() != null) {
            blockBiome = this.overlayBuilder.getOverlayBiome();
        }
        boolean glowing = this.isGlowing(state);
        pixel.write(state, h, this.topH, blockBiome, light, glowing, cave);
    }

    private boolean loadPixelHelp(MapBlock pixel, MapBlock currentPixel, class_1937 world, class_2680 state, byte light, class_2818 bchunk, int insideX, int insideZ, int h, boolean canReuseBiomeColours, boolean cave, class_3610 fluidFluidState, class_2378<class_1959> biomeRegistry, int transparentSkipY, boolean shouldExtendTillTheBottom, boolean flowers) {
        class_2248 b = state.method_26204();
        if (this.isInvisible(world, state, b, flowers)) {
            return false;
        }
        if (this.shouldOverlayCached((class_2688<?, ?>)(fluidFluidState == null ? state : fluidFluidState))) {
            if (h > this.topH) {
                this.topH = h;
            }
            if (this.overlayBuilder.isEmpty()) {
                this.firstTransparentStateY = h;
            }
            if (shouldExtendTillTheBottom) {
                this.overlayBuilder.getCurrentOverlay().increaseOpacity(this.overlayBuilder.getCurrentOverlay().getState().method_26193((class_1922)world, (class_2338)this.mutableGlobalPos) * (h - transparentSkipY));
            } else {
                BiomeKey overlayBiome = this.overlayBuilder.getOverlayBiome();
                if (overlayBiome == null) {
                    overlayBiome = canReuseBiomeColours && currentPixel != null && currentPixel.getNumberOfOverlays() > 0 && currentPixel.getOverlays().get(0).getState() == state ? currentPixel.getBiome() : this.biomeGetter.getBiome(world, (class_2338)this.mutableGlobalPos, biomeRegistry);
                }
                this.overlayBuilder.build(state, state.method_26193((class_1922)world, (class_2338)this.mutableGlobalPos), light, this.mapProcessor, overlayBiome);
            }
            return false;
        }
        if (h > this.topH) {
            this.topH = h;
        }
        return true;
    }

    public int loadBlockColourFromTexture(class_2680 state, boolean convert, class_1937 world, class_2338 globalPos) {
        if (this.clearCachedColours) {
            this.textureColours.clear();
            this.blockColours.clear();
            this.lastBlockStateForTextureColor = null;
            this.lastBlockStateForTextureColorResult = -1;
            this.clearCachedColours = false;
            if (WorldMap.settings.debug) {
                WorldMap.LOGGER.info("Xaero's World Map cache cleared!");
            }
        }
        if (state == this.lastBlockStateForTextureColor) {
            return this.lastBlockStateForTextureColorResult;
        }
        Integer c = this.blockColours.get(state);
        int red = 0;
        int green = 0;
        int blue = 0;
        class_2248 b = state.method_26204();
        if (c == null) {
            String name = null;
            try {
                Integer cachedColour;
                List upQuads = null;
                class_773 bms = class_310.method_1551().method_1541().method_3351();
                if (convert) {
                    upQuads = bms.method_3335(state).method_4707(state, class_2350.field_11036, this.usedRandom);
                }
                class_1058 missingTexture = class_310.method_1551().method_1554().method_24153(class_1059.field_5275).method_4608((class_2960)null);
                class_1058 texture = upQuads == null || upQuads.isEmpty() || ((class_777)upQuads.get(0)).method_35788() == missingTexture ? bms.method_3339(state) : ((class_777)upQuads.get(0)).method_35788();
                if (texture == null) {
                    throw new SilentException("No texture for " + state);
                }
                name = texture.method_4598() + ".png";
                c = -1;
                String[] args = name.split(":");
                if (args.length < 2) {
                    MapWriter.DEFAULT_RESOURCE[1] = args[0];
                    args = DEFAULT_RESOURCE;
                }
                if ((cachedColour = this.textureColours.get(name)) == null) {
                    class_2960 location = new class_2960(args[0], "textures/" + args[1]);
                    class_3298 resource = (class_3298)class_310.method_1551().method_1478().method_14486(location).get();
                    InputStream input = resource.method_14482();
                    BufferedImage img = ImageIO.read(input);
                    red = 0;
                    green = 0;
                    blue = 0;
                    int total = 0;
                    int ts = Math.min(img.getWidth(), img.getHeight());
                    if (ts > 0) {
                        int diff = Math.max(1, Math.min(4, ts / 8));
                        int parts = ts / diff;
                        for (int i = 0; i < parts; ++i) {
                            for (int j = 0; j < parts; ++j) {
                                int rgb = img.getRGB(i * diff, j * diff);
                                int alpha = rgb >> 24 & 0xFF;
                                if (rgb == 0 || alpha == 0) continue;
                                red += rgb >> 16 & 0xFF;
                                green += rgb >> 8 & 0xFF;
                                blue += rgb & 0xFF;
                                ++total;
                            }
                        }
                    }
                    input.close();
                    if (total == 0) {
                        total = 1;
                    }
                    if (convert && (red /= total) == 0 && (green /= total) == 0 && (blue /= total) == 0) {
                        throw new SilentException("Black texture " + ts);
                    }
                    c = 0xFF000000 | red << 16 | green << 8 | blue;
                    this.textureColours.put(name, c);
                } else {
                    c = cachedColour;
                }
            }
            catch (FileNotFoundException e) {
                if (convert) {
                    return this.loadBlockColourFromTexture(state, false, world, globalPos);
                }
                WorldMap.LOGGER.info("Block file not found: " + class_2378.field_11146.method_10221((Object)b));
                c = 0;
                if (state != null && state.method_26205((class_1922)world, globalPos) != null) {
                    c = state.method_26205((class_1922)world, (class_2338)globalPos).field_16011;
                }
                if (name != null) {
                    this.textureColours.put(name, c);
                }
            }
            catch (Exception e) {
                WorldMap.LOGGER.info("Exception when loading " + class_2378.field_11146.method_10221((Object)b) + " texture, using material colour.");
                c = 0;
                if (state.method_26205((class_1922)world, globalPos) != null) {
                    c = state.method_26205((class_1922)world, (class_2338)globalPos).field_16011;
                }
                if (name != null) {
                    this.textureColours.put(name, c);
                }
                if (e instanceof SilentException) {
                    WorldMap.LOGGER.info(e.getMessage());
                }
                WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
            }
            if (c != null) {
                this.blockColours.put(state, c);
            }
        }
        this.lastBlockStateForTextureColor = state;
        this.lastBlockStateForTextureColorResult = c;
        return c;
    }

    public long getUpdateCounter() {
        return this.updateCounter;
    }

    public void resetPosition() {
        this.X = 0;
        this.Z = 0;
        this.insideX = 0;
        this.insideZ = 0;
    }

    public void requestCachedColoursClear() {
        this.clearCachedColours = true;
    }

    public void setMapProcessor(MapProcessor mapProcessor) {
        this.mapProcessor = mapProcessor;
    }

    public void setDirtyInWriteDistance(class_1657 player, class_1937 level) {
        int writeDistance = this.getWriteDistance();
        int playerChunkX = player.method_24515().method_10263() >> 4;
        int playerChunkZ = player.method_24515().method_10260() >> 4;
        int startChunkX = playerChunkX - writeDistance;
        int startChunkZ = playerChunkZ - writeDistance;
        int endChunkX = playerChunkX + writeDistance;
        int endChunkZ = playerChunkZ + writeDistance;
        for (int x = startChunkX; x < endChunkX; ++x) {
            for (int z = startChunkZ; z < endChunkZ; ++z) {
                class_2818 chunk = level.method_8497(x, z);
                if (chunk == null) continue;
                try {
                    XaeroWorldMapCore.chunkCleanField.set(chunk, false);
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

