/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.minimap.element;

import java.util.function.Supplier;
import net.minecraft.class_1060;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import xaero.common.AXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.minimap.element.render.MinimapElementRenderLocation;
import xaero.common.minimap.element.render.MinimapElementRenderer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.map.element.MapElementRenderer;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.map.mods.SupportMods;
import xaero.map.mods.minimap.element.MinimapElementReaderWrapper;
import xaero.map.mods.minimap.element.MinimapElementRenderProviderWrapper;

public final class MinimapElementRendererWrapper<E, C>
extends MapElementRenderer<E, C, MinimapElementRendererWrapper<E, C>> {
    private final int order;
    private final AXaeroMinimap modMain;
    private final MinimapElementRenderer<E, C> renderer;
    private final Supplier<Boolean> shouldRenderSupplier;

    private MinimapElementRendererWrapper(AXaeroMinimap modMain, C context, MinimapElementRenderProviderWrapper<E, C> provider, MinimapElementReaderWrapper<E, C> reader, MinimapElementRenderer<E, C> renderer, Supplier<Boolean> shouldRenderSupplier, int order) {
        super(context, provider, reader);
        this.order = order;
        this.renderer = renderer;
        this.modMain = modMain;
        this.shouldRenderSupplier = shouldRenderSupplier;
    }

    @Override
    public void beforeRender(int location, class_310 mc, class_4587 matrixStack, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double screenSizeBasedScale, class_1060 textureManager, class_327 fontRenderer, class_4597.class_4598 renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, boolean pre) {
        renderTypeBuffers = this.modMain.getInterfaceRenderer().getCustomVertexConsumers().getBetterPVPRenderTypeBuffers();
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider minimapMultiTextureRender = minimapSession.getMultiTextureRenderTypeRenderers();
        this.renderer.preRender(MinimapElementRenderLocation.fromWorldMap((int)location), mc.method_1560(), (class_1657)mc.field_1724, cameraX, -1.0, cameraZ, this.modMain, renderTypeBuffers, minimapMultiTextureRender);
    }

    @Override
    public void afterRender(int location, class_310 mc, class_4587 matrixStack, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double screenSizeBasedScale, class_1060 textureManager, class_327 fontRenderer, class_4597.class_4598 renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, boolean pre) {
        renderTypeBuffers = this.modMain.getInterfaceRenderer().getCustomVertexConsumers().getBetterPVPRenderTypeBuffers();
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider minimapMultiTextureRender = minimapSession.getMultiTextureRenderTypeRenderers();
        this.renderer.postRender(MinimapElementRenderLocation.fromWorldMap((int)location), mc.method_1560(), (class_1657)mc.field_1724, cameraX, -1.0, cameraZ, this.modMain, renderTypeBuffers, minimapMultiTextureRender);
    }

    @Override
    public void renderElementPre(int location, E element, boolean hovered, class_310 mc, class_4587 matrixStack, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double screenSizeBasedScale, class_1060 textureManager, class_327 fontRenderer, class_4597.class_4598 renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, float optionalScale, double partialX, double partialY, boolean cave, float partialTicks) {
    }

    @Override
    public boolean renderElement(int location, E element, boolean hovered, class_310 mc, class_4587 matrixStack, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double screenSizeBasedScale, class_1060 textureManager, class_327 fontRenderer, class_4597.class_4598 renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, int elementIndex, double optionalDepth, float optionalScale, double partialX, double partialY, boolean cave, float partialTicks) {
        renderTypeBuffers = this.modMain.getInterfaceRenderer().getCustomVertexConsumers().getBetterPVPRenderTypeBuffers();
        MinimapRendererHelper helper = this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().getHelper();
        if (SupportMods.xaeroMinimap.compatibilityVersion >= 12) {
            return this.renderer.renderElement(MinimapElementRenderLocation.fromWorldMap((int)location), hovered, false, matrixStack, renderTypeBuffers, fontRenderer, null, helper, mc.method_1560(), (class_1657)mc.field_1724, cameraX, -1.0, cameraZ, elementIndex, optionalDepth, optionalScale, element, partialX, partialY, cave, partialTicks);
        }
        return this.renderer.renderElement(MinimapElementRenderLocation.fromWorldMap((int)location), hovered, matrixStack, renderTypeBuffers, fontRenderer, null, helper, mc.method_1560(), (class_1657)mc.field_1724, cameraX, -1.0, cameraZ, elementIndex, optionalDepth, optionalScale, element, partialX, partialY, cave, partialTicks);
    }

    @Override
    public boolean shouldRender(int location, boolean pre) {
        return !pre && this.shouldRenderSupplier.get() != false && this.renderer.shouldRender(location);
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public static final class Builder<E, C> {
        private final MinimapElementRenderer<E, C> renderer;
        private Supplier<Boolean> shouldRenderSupplier;
        private AXaeroMinimap modMain;
        private int order;

        private Builder(MinimapElementRenderer<E, C> renderer) {
            this.renderer = renderer;
        }

        private Builder<E, C> setDefault() {
            this.setModMain(null);
            this.setShouldRenderSupplier(() -> true);
            this.setOrder(0);
            return this;
        }

        public Builder<E, C> setModMain(AXaeroMinimap modMain) {
            this.modMain = modMain;
            return this;
        }

        public Builder<E, C> setShouldRenderSupplier(Supplier<Boolean> shouldRenderSupplier) {
            this.shouldRenderSupplier = shouldRenderSupplier;
            return this;
        }

        public Builder<E, C> setOrder(int order) {
            this.order = order;
            return this;
        }

        public MinimapElementRendererWrapper<E, C> build() {
            if (this.modMain == null || this.shouldRenderSupplier == null) {
                throw new IllegalStateException();
            }
            MinimapElementRenderProviderWrapper providerWrapper = new MinimapElementRenderProviderWrapper(this.renderer.getProvider());
            MinimapElementReaderWrapper readerWrapper = new MinimapElementReaderWrapper(this.renderer.getElementReader());
            Object context = this.renderer.getContext();
            return new MinimapElementRendererWrapper(this.modMain, context, providerWrapper, readerWrapper, this.renderer, this.shouldRenderSupplier, this.order);
        }

        public static <E, C> Builder<E, C> begin(MinimapElementRenderer<E, C> renderer) {
            return new Builder<E, C>(renderer).setDefault();
        }
    }
}

