/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.world;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_5321;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.file.MapSaveLoad;
import xaero.map.world.MapDimension;

public class MapWorld {
    private MapProcessor mapProcessor;
    private boolean isMultiplayer;
    private String mainId;
    private String oldUnfixedMainId;
    private Hashtable<class_5321<class_1937>, MapDimension> dimensions;
    private class_5321<class_1937> currentDimensionId;
    private class_5321<class_1937> futureDimensionId;
    private int futureMultiworldType;
    private int currentMultiworldType;
    private boolean futureMultiworldTypeConfirmed = true;
    private boolean currentMultiworldTypeConfirmed = false;
    private boolean ignoreServerLevelId;
    private boolean ignoreHeightmaps;
    private String playerTeleportCommandFormat = "/tp @s {name}";

    public MapWorld(String mainId, String oldUnfixedMainId, MapProcessor mapProcessor) {
        this.mainId = mainId;
        this.oldUnfixedMainId = oldUnfixedMainId;
        this.mapProcessor = mapProcessor;
        this.isMultiplayer = mapProcessor.isWorldMultiplayer(mapProcessor.isWorldRealms(mainId), mainId);
        this.dimensions = new Hashtable();
        this.currentMultiworldType = 0;
        this.futureMultiworldType = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapDimension getDimension(class_5321<class_1937> dimId) {
        Hashtable<class_5321<class_1937>, MapDimension> hashtable = this.dimensions;
        synchronized (hashtable) {
            return this.dimensions.get(dimId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapDimension createDimensionUnsynced(class_5321<class_1937> dimId) {
        Hashtable<class_5321<class_1937>, MapDimension> hashtable = this.dimensions;
        synchronized (hashtable) {
            MapDimension result = this.dimensions.get(dimId);
            if (result == null) {
                result = new MapDimension(this, dimId, this.mapProcessor.getHighlighterRegistry());
                this.dimensions.put(dimId, result);
                result.loadConfigUnsynced();
            }
            return result;
        }
    }

    public String getMainId() {
        return this.mainId;
    }

    public String getOldUnfixedMainId() {
        return this.oldUnfixedMainId;
    }

    public String getCurrentMultiworld() {
        MapDimension container = this.getDimension(this.currentDimensionId);
        return container.getCurrentMultiworld();
    }

    public String getFutureMultiworldUnsynced() {
        MapDimension container = this.getDimension(this.futureDimensionId);
        return container.getFutureMultiworldUnsynced();
    }

    public MapDimension getCurrentDimension() {
        return this.getDimension(this.currentDimensionId);
    }

    public MapDimension getFutureDimension() {
        return this.getDimension(this.futureDimensionId);
    }

    public class_5321<class_1937> getCurrentDimensionId() {
        return this.currentDimensionId;
    }

    public class_5321<class_1937> getFutureDimensionId() {
        return this.futureDimensionId;
    }

    public void setFutureDimensionId(class_5321<class_1937> dimension) {
        this.futureDimensionId = dimension;
    }

    public void switchToFutureUnsynced() {
        this.currentDimensionId = this.futureDimensionId;
        this.getDimension(this.currentDimensionId).switchToFutureUnsynced();
    }

    public List<MapDimension> getDimensionsList() {
        ArrayList<MapDimension> destList = new ArrayList<MapDimension>();
        this.getDimensions(destList);
        return destList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDimensions(List<MapDimension> dest) {
        Hashtable<class_5321<class_1937>, MapDimension> hashtable = this.dimensions;
        synchronized (hashtable) {
            dest.addAll(this.dimensions.values());
        }
    }

    public int getCurrentMultiworldType() {
        return this.currentMultiworldType;
    }

    public boolean isMultiplayer() {
        return this.isMultiplayer;
    }

    public boolean isCurrentMultiworldTypeConfirmed() {
        return this.currentMultiworldTypeConfirmed;
    }

    public int getFutureMultiworldType(MapDimension dim) {
        return dim.isFutureMultiworldServerBased() ? 2 : this.futureMultiworldType;
    }

    public void toggleMultiworldTypeUnsynced() {
        this.unconfirmMultiworldTypeUnsynced();
        this.futureMultiworldType = (this.futureMultiworldType + 1) % 3;
        this.getCurrentDimension().resetCustomMultiworldUnsynced();
        this.saveConfig();
    }

    public void unconfirmMultiworldTypeUnsynced() {
        this.futureMultiworldTypeConfirmed = false;
    }

    public void confirmMultiworldTypeUnsynced() {
        this.futureMultiworldTypeConfirmed = true;
    }

    public boolean isFutureMultiworldTypeConfirmed(MapDimension dim) {
        return dim.isFutureMultiworldServerBased() ? true : this.futureMultiworldTypeConfirmed;
    }

    public void switchToFutureMultiworldTypeUnsynced() {
        MapDimension futureDim = this.getFutureDimension();
        this.currentMultiworldType = this.getFutureMultiworldType(this.getFutureDimension());
        this.currentMultiworldTypeConfirmed = this.isFutureMultiworldTypeConfirmed(futureDim);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfig() {
        MapProcessor mp = this.mapProcessor;
        mp.getMapSaveLoad();
        Path rootSavePath = MapSaveLoad.getRootFolder(this.mainId);
        BufferedReader reader = null;
        try {
            if (!Files.exists(rootSavePath, new LinkOption[0])) {
                Files.createDirectories(rootSavePath, new FileAttribute[0]);
            }
            Path configFile = rootSavePath.resolve("server_config.txt");
            Path oldOverworldSavePath = mp.getMapSaveLoad().getOldFolder(this.oldUnfixedMainId, "null");
            Path oldConfigFile = oldOverworldSavePath.resolve("server_config.txt");
            if (!Files.exists(configFile, new LinkOption[0]) && Files.exists(oldConfigFile, new LinkOption[0])) {
                Files.move(oldConfigFile, configFile, new CopyOption[0]);
            }
            if (Files.exists(configFile, new LinkOption[0])) {
                String line;
                reader = new BufferedReader(new FileReader(configFile.toFile()));
                while ((line = reader.readLine()) != null) {
                    String[] args = line.split(":");
                    if (args[0].equals("multiworldType")) {
                        this.futureMultiworldType = Integer.parseInt(args[1]);
                        continue;
                    }
                    if (args[0].equals("ignoreServerLevelId")) {
                        this.ignoreServerLevelId = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equals("ignoreHeightmaps")) {
                        this.ignoreHeightmaps = args[1].equals("true");
                        continue;
                    }
                    if (!args[0].equals("playerTeleportCommandFormat")) continue;
                    this.playerTeleportCommandFormat = args[1];
                }
            } else {
                this.saveConfig();
            }
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfig() {
        MapProcessor mp = this.mapProcessor;
        mp.getMapSaveLoad();
        Path rootSavePath = MapSaveLoad.getRootFolder(this.mainId);
        try (PrintWriter writer = null;){
            writer = new PrintWriter(new FileWriter(rootSavePath.resolve("server_config.txt").toFile()));
            writer.println("multiworldType:" + this.futureMultiworldType);
            writer.println("ignoreServerLevelId:" + this.ignoreServerLevelId);
            writer.println("ignoreHeightmaps:" + this.ignoreHeightmaps);
            writer.println("playerTeleportCommandFormat:" + this.playerTeleportCommandFormat);
        }
    }

    MapProcessor getMapProcessor() {
        return this.mapProcessor;
    }

    public boolean isIgnoreServerLevelId() {
        return this.ignoreServerLevelId;
    }

    public boolean isIgnoreHeightmaps() {
        return this.ignoreHeightmaps;
    }

    public void setIgnoreHeightmaps(boolean ignoreHeightmaps) {
        this.ignoreHeightmaps = ignoreHeightmaps;
    }

    public String getPlayerTeleportCommandFormat() {
        return this.playerTeleportCommandFormat;
    }

    public void setPlayerTeleportCommandFormat(String playerTeleportCommandFormat) {
        this.playerTeleportCommandFormat = playerTeleportCommandFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllCachedHighlightHashes() {
        Hashtable<class_5321<class_1937>, MapDimension> hashtable = this.dimensions;
        synchronized (hashtable) {
            for (MapDimension dim : this.dimensions.values()) {
                dim.getHighlightHandler().clearCachedHashes();
            }
        }
    }
}

