/*
 * Decompiled with CFR 0.152.
 */
package edu.jorbonism.cool_elytra.mixin;

import edu.jorbonism.cool_elytra.CoolElytraClient;
import edu.jorbonism.cool_elytra.config.CoolElytraConfig;
import net.minecraft.class_1160;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_757.class})
public class GameRendererMixin {
    @Final
    @Shadow
    private class_310 field_4015;

    @Inject(at={@At(value="HEAD")}, method={"renderWorld"})
    public void renderWorld(float tickDelta, long limitTime, class_4587 matrix, CallbackInfo ci) {
        if (CoolElytraConfig.mode == 1) {
            if (this.field_4015.field_1724 != null && this.field_4015.field_1724.method_6128() && !this.field_4015.field_1724.method_5799() && !this.field_4015.field_1724.method_5771()) {
                class_243 facing = this.field_4015.field_1724.method_5663();
                class_243 velocity = this.getPlayerInstantaneousVelocity(tickDelta);
                double horizontalFacing2 = facing.method_37268();
                double horizontalSpeed2 = velocity.method_37268();
                float rollAngle = 0.0f;
                if (horizontalFacing2 > 0.0 && horizontalSpeed2 > 0.0) {
                    double dot = (velocity.field_1352 * facing.field_1352 + velocity.field_1350 * facing.field_1350) / Math.sqrt(horizontalFacing2 * horizontalSpeed2);
                    if (dot >= 1.0) {
                        dot = 1.0;
                    } else if (dot <= -1.0) {
                        dot = -1.0;
                    }
                    double direction = Math.signum(velocity.field_1352 * facing.field_1350 - velocity.field_1350 * facing.field_1352);
                    rollAngle = (float)(Math.atan(Math.sqrt(horizontalSpeed2) * Math.acos(dot) * CoolElytraConfig.wingPower) * direction * 57.29577951308232);
                }
                rollAngle = (float)((1.0 - CoolElytraConfig.rollSmoothing) * (double)rollAngle + CoolElytraConfig.rollSmoothing * CoolElytraClient.lastRollAngle);
                CoolElytraClient.lastRollAngle = rollAngle;
                matrix.method_22907(class_1160.field_20707.method_23214(rollAngle));
            } else {
                CoolElytraClient.lastRollAngle = 0.0;
            }
        } else if (CoolElytraConfig.mode == 2) {
            if (this.field_4015.field_1724 == null || !this.field_4015.field_1724.method_6128()) {
                return;
            }
            double angle = -Math.acos(CoolElytraClient.left.method_1026(CoolElytraClient.getAssumedLeft(this.field_4015.field_1724.method_36454()))) * 57.29577951308232;
            if (CoolElytraClient.left.method_10214() < 0.0) {
                angle *= -1.0;
            }
            matrix.method_22907(class_1160.field_20707.method_23214((float)angle));
            CoolElytraClient.lastRollAngle = (float)angle;
        }
    }

    public class_243 getPlayerInstantaneousVelocity(float tickDelta) {
        assert (this.field_4015.field_1724 != null);
        class_243 velocity = this.field_4015.field_1724.method_18798();
        if (tickDelta < 0.01f) {
            return velocity;
        }
        double newvx = velocity.field_1352;
        double newvy = velocity.field_1351;
        double newvz = velocity.field_1350;
        double gravity = 0.08;
        class_243 facing = this.field_4015.field_1724.method_5720();
        float pitchRadians = this.field_4015.field_1724.method_36455() * ((float)Math.PI / 180);
        double horizontalFacing2 = facing.method_37268();
        double horizontalFacing = Math.sqrt(horizontalFacing2);
        double horizontalSpeed = velocity.method_37267();
        newvy += gravity * (-1.0 + horizontalFacing2 * 0.75);
        if (horizontalFacing > 0.0) {
            double lift;
            if (velocity.field_1351 < 0.0) {
                lift = newvy * -0.1 * horizontalFacing2;
                newvx += facing.field_1352 * lift / horizontalFacing;
                newvy += lift;
                newvz += facing.field_1350 * lift / horizontalFacing;
            }
            if (pitchRadians < 0.0f) {
                lift = horizontalSpeed * -((double)class_3532.method_15374((float)pitchRadians)) * 0.04;
                newvx += -facing.field_1352 * lift / horizontalFacing;
                newvy += lift * 3.2;
                newvz += -facing.field_1350 * lift / horizontalFacing;
            }
            newvx += (facing.field_1352 / horizontalFacing * horizontalSpeed - velocity.field_1352) * 0.1;
            newvz += (facing.field_1350 / horizontalFacing * horizontalSpeed - velocity.field_1350) * 0.1;
        }
        newvx *= (double)0.99f;
        newvy *= (double)0.98f;
        newvz *= (double)0.99f;
        if (CoolElytraClient.isRocketing) {
            newvx += facing.field_1352 * 0.1 + (facing.field_1352 * 1.5 - newvx) * 0.5;
            newvy += facing.field_1351 * 0.1 + (facing.field_1351 * 1.5 - newvy) * 0.5;
            newvz += facing.field_1350 * 0.1 + (facing.field_1350 * 1.5 - newvz) * 0.5;
        }
        return new class_243(class_3532.method_16436((double)tickDelta, (double)velocity.field_1352, (double)newvx), class_3532.method_16436((double)tickDelta, (double)velocity.field_1351, (double)newvy), class_3532.method_16436((double)tickDelta, (double)velocity.field_1350, (double)newvz));
    }
}

