/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.server;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xaero.common.AXaeroMinimap;
import xaero.common.server.events.ServerEvents;
import xaero.common.server.level.LevelMapProperties;
import xaero.common.server.level.LevelMapPropertiesIO;

public class XaeroMinimapServer {
    private final Logger LOGGER = LogManager.getLogger();
    private AXaeroMinimap modMain;
    private Map<Path, LevelMapProperties> levelProperties;
    private LevelMapPropertiesIO propertiesIO;
    private ServerEvents serverEvents;

    public XaeroMinimapServer(AXaeroMinimap modMain) {
        this.modMain = modMain;
        this.levelProperties = new HashMap<Path, LevelMapProperties>();
        this.propertiesIO = new LevelMapPropertiesIO();
    }

    public void load() {
        this.LOGGER.info("Loading Xaero's Minimap - Stage 1/2 (Server)");
        this.serverEvents = new ServerEvents(this);
    }

    public void loadLater() {
        this.LOGGER.info("Loading Xaero's Minimap - Stage 2/2 (Server)");
    }

    public LevelMapProperties getLevelProperties(Path path) {
        LevelMapProperties properties = this.levelProperties.get(path);
        if (properties == null) {
            properties = new LevelMapProperties();
            try {
                this.propertiesIO.load(path, properties);
            }
            catch (FileNotFoundException fnfe) {
                this.propertiesIO.save(path, properties);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.levelProperties.put(path, properties);
        }
        return properties;
    }

    public AXaeroMinimap getModMain() {
        return this.modMain;
    }

    public ServerEvents getServerEvents() {
        return this.serverEvents;
    }
}

