/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.flighthud;

import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import net.torocraft.flighthud.FlightHud;

public class FlightComputer {
    private static final float TICKS_PER_SECOND = 20.0f;
    private float previousRollAngle = 0.0f;
    public class_243 velocity;
    public float speed;
    public float pitch;
    public float heading;
    public class_243 flightPath;
    public float flightPitch;
    public float flightHeading;
    public float roll;
    public float altitude;
    public Integer groundLevel;
    public Float distanceFromGround;
    public Float elytraHealth;

    public void update(class_310 client, float partial) {
        this.velocity = client.field_1724.method_18798();
        this.pitch = this.computePitch(client, partial);
        this.speed = this.computeSpeed(client);
        this.roll = this.computeRoll(client, partial);
        this.heading = this.computeHeading(client);
        this.altitude = this.computeAltitude(client);
        this.groundLevel = this.computeGroundLevel(client);
        this.distanceFromGround = this.computeDistanceFromGround(client, this.altitude, this.groundLevel);
        this.flightPitch = this.computeFlightPitch(this.velocity, this.pitch);
        this.flightHeading = this.computeFlightHeading(this.velocity, this.heading);
        this.elytraHealth = this.computeElytraHealth(client);
    }

    private Float computeElytraHealth(class_310 client) {
        class_1799 stack = client.field_1724.method_6118(class_1304.field_6174);
        if (stack != null && stack.method_7909() == class_1802.field_8833) {
            float remain = ((float)stack.method_7936() - (float)stack.method_7919()) / (float)stack.method_7936();
            return Float.valueOf(remain * 100.0f);
        }
        return null;
    }

    private float computeFlightPitch(class_243 velocity, float pitch) {
        if (velocity.method_1033() < 0.01) {
            return pitch;
        }
        class_243 n = velocity.method_1029();
        return (float)(90.0 - Math.toDegrees(Math.acos(n.field_1351)));
    }

    private float computeFlightHeading(class_243 velocity, float heading) {
        if (velocity.method_1033() < 0.01) {
            return heading;
        }
        return this.toHeading((float)Math.toDegrees(-Math.atan2(velocity.field_1352, velocity.field_1350)));
    }

    private float computeRoll(class_310 client, float partial) {
        if (!FlightHud.CONFIG_SETTINGS.calculateRoll) {
            return 0.0f;
        }
        float wingPower = FlightHud.CONFIG_SETTINGS.rollTurningForce;
        float rollSmoothing = FlightHud.CONFIG_SETTINGS.rollSmoothing;
        class_243 facing = client.field_1724.method_5663();
        class_243 velocity = client.field_1724.method_18798();
        double horizontalFacing2 = facing.method_37268();
        double horizontalSpeed2 = velocity.method_37268();
        float rollAngle = 0.0f;
        if (horizontalFacing2 > 0.0 && horizontalSpeed2 > 0.0) {
            double dot = (velocity.field_1352 * facing.field_1352 + velocity.field_1350 * facing.field_1350) / Math.sqrt(horizontalFacing2 * horizontalSpeed2);
            dot = class_3532.method_15350((double)dot, (double)-1.0, (double)1.0);
            double direction = Math.signum(velocity.field_1352 * facing.field_1350 - velocity.field_1350 * facing.field_1352);
            rollAngle = (float)(Math.atan(Math.sqrt(horizontalSpeed2) * Math.acos(dot) * (double)wingPower) * direction * 57.29577951308);
        }
        this.previousRollAngle = rollAngle = (float)((1.0 - (double)rollSmoothing) * (double)rollAngle + (double)(rollSmoothing * this.previousRollAngle));
        return rollAngle;
    }

    private float computePitch(class_310 client, float parital) {
        return client.field_1724.method_5695(parital) * -1.0f;
    }

    private boolean isGround(class_2338 pos, class_310 client) {
        class_2680 block = client.field_1687.method_8320(pos);
        return !block.method_26215();
    }

    public class_2338 findGround(class_310 client) {
        class_2338 pos = client.field_1724.method_24515();
        while (pos.method_10264() >= 0) {
            if (!this.isGround(pos = pos.method_10074(), client)) continue;
            return pos;
        }
        return null;
    }

    private Integer computeGroundLevel(class_310 client) {
        class_2338 ground = this.findGround(client);
        return ground == null ? null : Integer.valueOf(ground.method_10264());
    }

    private Float computeDistanceFromGround(class_310 client, float altitude, Integer groundLevel) {
        if (groundLevel == null) {
            return null;
        }
        return Float.valueOf(Math.max(0.0f, altitude - (float)groundLevel.intValue()));
    }

    private float computeAltitude(class_310 client) {
        return (float)client.field_1724.method_19538().field_1351 - 1.0f;
    }

    private float computeHeading(class_310 client) {
        return this.toHeading(client.field_1724.method_36454());
    }

    private float computeSpeed(class_310 client) {
        float speed = 0.0f;
        class_746 player = client.field_1724;
        if (player.method_5765()) {
            class_1297 entity = player.method_5854();
            speed = (float)entity.method_18798().method_1033() * 20.0f;
        } else {
            speed = (float)client.field_1724.method_18798().method_1033() * 20.0f;
        }
        return speed;
    }

    private float toHeading(float yawDegrees) {
        return (yawDegrees + 180.0f) % 360.0f;
    }
}

