/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.flighthud;

import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.torocraft.flighthud.Dimensions;
import net.torocraft.flighthud.FlightComputer;
import net.torocraft.flighthud.FlightHud;
import net.torocraft.flighthud.HudComponent;
import net.torocraft.flighthud.components.AltitudeIndicator;
import net.torocraft.flighthud.components.ElytraHealthIndicator;
import net.torocraft.flighthud.components.FlightPathIndicator;
import net.torocraft.flighthud.components.HeadingIndicator;
import net.torocraft.flighthud.components.LocationIndicator;
import net.torocraft.flighthud.components.PitchIndicator;
import net.torocraft.flighthud.components.SpeedIndicator;
import net.torocraft.flighthud.config.SettingsConfig;

public class HudRenderer
extends HudComponent {
    private final Dimensions dim = new Dimensions();
    private final FlightComputer computer = new FlightComputer();
    private static final String FULL = SettingsConfig.DisplayMode.FULL.toString();
    private static final String MIN = SettingsConfig.DisplayMode.MIN.toString();
    private final HudComponent[] components = new HudComponent[]{new FlightPathIndicator(this.computer, this.dim), new LocationIndicator(this.dim), new HeadingIndicator(this.computer, this.dim), new SpeedIndicator(this.computer, this.dim), new AltitudeIndicator(this.computer, this.dim), new PitchIndicator(this.computer, this.dim), new ElytraHealthIndicator(this.computer, this.dim)};

    private void setupConfig(class_310 client) {
        HudComponent.CONFIG = null;
        if (client.field_1724.method_6128()) {
            if (FlightHud.CONFIG_SETTINGS.displayModeWhenFlying.equals(FULL)) {
                HudComponent.CONFIG = FlightHud.CONFIG_FULL;
            } else if (FlightHud.CONFIG_SETTINGS.displayModeWhenFlying.equals(MIN)) {
                HudComponent.CONFIG = FlightHud.CONFIG_MIN;
            }
        } else if (FlightHud.CONFIG_SETTINGS.displayModeWhenNotFlying.equals(FULL)) {
            HudComponent.CONFIG = FlightHud.CONFIG_FULL;
        } else if (FlightHud.CONFIG_SETTINGS.displayModeWhenNotFlying.equals(MIN)) {
            HudComponent.CONFIG = FlightHud.CONFIG_MIN;
        }
    }

    @Override
    public void render(class_4587 m, float partial, class_310 client) {
        this.setupConfig(client);
        if (HudComponent.CONFIG == null) {
            return;
        }
        try {
            m.method_22903();
            if ((double)HudComponent.CONFIG.scale != 1.0) {
                float scale = 1.0f / HudComponent.CONFIG.scale;
                m.method_22905(scale, scale, scale);
            }
            this.computer.update(client, partial);
            this.dim.update(client);
            for (HudComponent component : this.components) {
                component.render(m, partial, client);
            }
            m.method_22909();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

