/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.flighthud.components;

import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.torocraft.flighthud.Dimensions;
import net.torocraft.flighthud.FlightComputer;
import net.torocraft.flighthud.HudComponent;

public class FlightPathIndicator
extends HudComponent {
    private final Dimensions dim;
    private final FlightComputer computer;

    public FlightPathIndicator(FlightComputer computer, Dimensions dim) {
        this.computer = computer;
        this.dim = dim;
    }

    @Override
    public void render(class_4587 m, float partial, class_310 client) {
        if (!FlightPathIndicator.CONFIG.flightPath_show) {
            return;
        }
        float deltaPitch = this.computer.pitch - this.computer.flightPitch;
        float deltaHeading = this.wrapHeading(this.computer.flightHeading) - this.wrapHeading(this.computer.heading);
        if (deltaHeading < -180.0f) {
            deltaHeading += 360.0f;
        }
        float y = this.dim.yMid;
        float x = this.dim.xMid;
        x += (float)this.i(deltaHeading * this.dim.degreesPerPixel);
        if ((y += (float)this.i(deltaPitch * this.dim.degreesPerPixel)) < this.dim.tFrame || y > this.dim.bFrame || x < this.dim.lFrame || x > this.dim.rFrame) {
            return;
        }
        float l = x - 3.0f;
        float r = x + 3.0f;
        float t = y - 3.0f - FlightPathIndicator.CONFIG.halfThickness;
        float b = y + 3.0f - FlightPathIndicator.CONFIG.halfThickness;
        this.drawVerticalLine(m, l, t, b);
        this.drawVerticalLine(m, r, t, b);
        this.drawHorizontalLine(m, l, r, t);
        this.drawHorizontalLine(m, l, r, b);
        this.drawVerticalLine(m, x, t - 5.0f, t);
        this.drawHorizontalLine(m, l - 4.0f, l, y - FlightPathIndicator.CONFIG.halfThickness);
        this.drawHorizontalLine(m, r, r + 4.0f, y - FlightPathIndicator.CONFIG.halfThickness);
    }
}

