/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.flighthud.components;

import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.torocraft.flighthud.Dimensions;
import net.torocraft.flighthud.FlightComputer;
import net.torocraft.flighthud.HudComponent;

public class HeadingIndicator
extends HudComponent {
    private final Dimensions dim;
    private final FlightComputer computer;

    public HeadingIndicator(FlightComputer computer, Dimensions dim) {
        this.computer = computer;
        this.dim = dim;
    }

    @Override
    public void render(class_4587 m, float partial, class_310 mc) {
        float left = this.dim.lFrame;
        float right = this.dim.rFrame;
        float top = this.dim.tFrame - 10.0f;
        float yText = top - 7.0f;
        float northOffset = this.computer.heading * this.dim.degreesPerPixel;
        float xNorth = this.dim.xMid - northOffset;
        if (HeadingIndicator.CONFIG.heading_showReadout) {
            this.drawFont(mc, m, String.format("%03d", this.i(this.wrapHeading(this.computer.heading))), this.dim.xMid - 8.0f, yText);
            this.drawBox(m, this.dim.xMid - 15.0f, yText - 1.5f, 30.0f, 10.0f);
        }
        if (HeadingIndicator.CONFIG.heading_showScale) {
            this.drawPointer(m, this.dim.xMid, top + 10.0f, 0.0f);
            for (int i = -540; i < 540; i += 5) {
                float x = (float)i * this.dim.degreesPerPixel + xNorth;
                if (x < left || x > right) continue;
                if (i % 15 == 0) {
                    if (i % 90 == 0) {
                        this.drawFont(mc, m, this.headingToDirection(i), x - 2.0f, yText + 10.0f);
                        this.drawFont(mc, m, this.headingToAxis(i), x - 8.0f, yText + 20.0f);
                    } else {
                        this.drawVerticalLine(m, x, top + 3.0f, top + 10.0f);
                    }
                    if (HeadingIndicator.CONFIG.heading_showReadout && !(x <= this.dim.xMid - 26.0f) && !(x >= this.dim.xMid + 26.0f)) continue;
                    this.drawFont(mc, m, String.format("%03d", this.i(this.wrapHeading(i))), x - 8.0f, yText);
                    continue;
                }
                this.drawVerticalLine(m, x, top + 6.0f, top + 10.0f);
            }
        }
    }

    private String headingToDirection(int degrees) {
        degrees = this.i(this.wrapHeading(degrees));
        switch (degrees) {
            case 0: 
            case 360: {
                return "N";
            }
            case 90: {
                return "E";
            }
            case 180: {
                return "S";
            }
            case 270: {
                return "W";
            }
        }
        return "";
    }

    private String headingToAxis(int degrees) {
        degrees = this.i(this.wrapHeading(degrees));
        switch (degrees) {
            case 0: 
            case 360: {
                return "-Z";
            }
            case 90: {
                return "+X";
            }
            case 180: {
                return "+Z";
            }
            case 270: {
                return "-X";
            }
        }
        return "";
    }
}

