/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.flighthud.components;

import net.minecraft.class_1160;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.torocraft.flighthud.Dimensions;
import net.torocraft.flighthud.FlightComputer;
import net.torocraft.flighthud.HudComponent;

public class PitchIndicator
extends HudComponent {
    private final Dimensions dim;
    private final FlightComputer computer;
    private final PitchIndicatorData pitchData = new PitchIndicatorData();

    public PitchIndicator(FlightComputer computer, Dimensions dim) {
        this.computer = computer;
        this.dim = dim;
    }

    @Override
    public void render(class_4587 m, float partial, class_310 mc) {
        this.pitchData.update(this.dim);
        float horizonOffset = this.computer.pitch * this.dim.degreesPerPixel;
        float yHorizon = this.dim.yMid + horizonOffset;
        float a = this.dim.yMid;
        float b = this.dim.xMid;
        float roll = this.computer.roll * (float)(PitchIndicator.CONFIG.pitchLadder_reverseRoll ? -1 : 1);
        if (PitchIndicator.CONFIG.pitchLadder_showRoll) {
            m.method_22903();
            m.method_22904((double)b, (double)a, 0.0);
            m.method_22907(class_1160.field_20707.method_23214(roll));
            m.method_22904((double)(-b), (double)(-a), 0.0);
        }
        if (PitchIndicator.CONFIG.pitchLadder_showLadder) {
            this.drawLadder(mc, m, yHorizon);
        }
        this.drawReferenceMark(mc, m, yHorizon, PitchIndicator.CONFIG.pitchLadder_optimumClimbAngle);
        this.drawReferenceMark(mc, m, yHorizon, PitchIndicator.CONFIG.pitchLadder_optimumGlideAngle);
        if (PitchIndicator.CONFIG.pitchLadder_showHorizon) {
            this.pitchData.l1 -= this.pitchData.margin;
            this.pitchData.r2 += this.pitchData.margin;
            this.drawDegreeBar(mc, m, 0.0f, yHorizon);
        }
        if (PitchIndicator.CONFIG.pitchLadder_showRoll) {
            m.method_22909();
        }
    }

    private void drawLadder(class_310 mc, class_4587 m, float yHorizon) {
        int degreesPerBar = PitchIndicator.CONFIG.pitchLadder_degreesPerBar;
        if (degreesPerBar < 1) {
            degreesPerBar = 20;
        }
        for (int i = degreesPerBar; i <= 90; i += degreesPerBar) {
            float offset = this.dim.degreesPerPixel * (float)i;
            this.drawDegreeBar(mc, m, -i, yHorizon + offset);
            this.drawDegreeBar(mc, m, i, yHorizon - offset);
        }
    }

    private void drawReferenceMark(class_310 mc, class_4587 m, float yHorizon, float degrees) {
        if (degrees == 0.0f) {
            return;
        }
        float y = -degrees * this.dim.degreesPerPixel + yHorizon;
        if (y < this.dim.tFrame || y > this.dim.bFrame) {
            return;
        }
        float width = (this.pitchData.l2 - this.pitchData.l1) * 0.45f;
        float l1 = this.pitchData.l2 - width;
        float r2 = this.pitchData.r1 + width;
        this.drawHorizontalLineDashed(m, l1, this.pitchData.l2, y, 3);
        this.drawHorizontalLineDashed(m, this.pitchData.r1, r2, y, 3);
    }

    private void drawDegreeBar(class_310 mc, class_4587 m, float degree, float y) {
        if (y < this.dim.tFrame || y > this.dim.bFrame) {
            return;
        }
        int dashes = degree < 0.0f ? 4 : 1;
        this.drawHorizontalLineDashed(m, this.pitchData.l1, this.pitchData.l2, y, dashes);
        this.drawHorizontalLineDashed(m, this.pitchData.r1, this.pitchData.r2, y, dashes);
        int sideTickHeight = degree >= 0.0f ? 5 : -5;
        this.drawVerticalLine(m, this.pitchData.l1, y, y + (float)sideTickHeight);
        this.drawVerticalLine(m, this.pitchData.r2, y, y + (float)sideTickHeight);
        int fontVerticalOffset = degree >= 0.0f ? 0 : 6;
        this.drawFont(mc, m, String.format("%d", this.i(Math.abs(degree))), this.pitchData.r2 + 6.0f, y - (float)fontVerticalOffset);
        this.drawFont(mc, m, String.format("%d", this.i(Math.abs(degree))), this.pitchData.l1 - 17.0f, y - (float)fontVerticalOffset);
    }

    private static class PitchIndicatorData {
        public float width;
        public float mid;
        public float margin;
        public float sideWidth;
        public float l1;
        public float l2;
        public float r1;
        public float r2;

        private PitchIndicatorData() {
        }

        public void update(Dimensions dim) {
            float left = this.width = (float)this.i(dim.wScreen / 3.0f);
            this.mid = this.i(this.width / 2.0f + left);
            this.margin = this.i((double)this.width * 0.3);
            this.l1 = left + this.margin;
            this.l2 = this.mid - 7.0f;
            this.sideWidth = this.l2 - this.l1;
            this.r1 = this.mid + 8.0f;
            this.r2 = this.r1 + this.sideWidth;
        }

        private int i(double d) {
            return (int)Math.round(d);
        }
    }
}

