/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.flighthud.components;

import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.torocraft.flighthud.Dimensions;
import net.torocraft.flighthud.FlightComputer;
import net.torocraft.flighthud.HudComponent;

public class SpeedIndicator
extends HudComponent {
    private final Dimensions dim;
    private final FlightComputer computer;

    public SpeedIndicator(FlightComputer computer, Dimensions dim) {
        this.computer = computer;
        this.dim = dim;
    }

    @Override
    public void render(class_4587 m, float partial, class_310 mc) {
        float top = this.dim.tFrame;
        float bottom = this.dim.bFrame;
        float left = this.dim.lFrame - 2.0f;
        float right = this.dim.lFrame;
        float unitPerPixel = 30.0f;
        float floorOffset = this.computer.speed * unitPerPixel;
        float yFloor = this.dim.yMid - floorOffset;
        float xSpeedText = left - 5.0f;
        if (SpeedIndicator.CONFIG.speed_showReadout) {
            this.drawRightAlignedFont(mc, m, String.format("%.2f", Float.valueOf(this.computer.speed)), xSpeedText, this.dim.yMid - 3.0f);
            this.drawBox(m, xSpeedText - 29.5f, this.dim.yMid - 4.5f, 30.0f, 10.0f);
        }
        if (SpeedIndicator.CONFIG.speed_showScale) {
            for (float i = 0.0f; i <= 100.0f; i += 0.25f) {
                float y = this.dim.hScreen - i * unitPerPixel - yFloor;
                if (y < top || y > bottom - 5.0f) continue;
                if (i % 1.0f == 0.0f) {
                    this.drawHorizontalLine(m, left - 2.0f, right, y);
                    if (!SpeedIndicator.CONFIG.speed_showReadout || y > this.dim.yMid + 7.0f || y < this.dim.yMid - 7.0f) {
                        this.drawRightAlignedFont(mc, m, String.format("%.0f", Float.valueOf(i)), xSpeedText, y - 3.0f);
                    }
                }
                this.drawHorizontalLine(m, left, right, y);
            }
        }
    }
}

