/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.flighthud.config.loader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.function.Consumer;
import net.torocraft.flighthud.config.loader.ConfigFolder;
import net.torocraft.flighthud.config.loader.FileWatcher;
import net.torocraft.flighthud.config.loader.IConfig;

public class ConfigLoader<T extends IConfig> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Consumer<T> onLoad;
    private final File file;
    private final T defaultConfig;
    private FileWatcher watcher;

    public ConfigLoader(T defaultConfig, String filename, Consumer<T> onLoad) {
        this.defaultConfig = defaultConfig;
        this.onLoad = onLoad;
        this.file = new File(ConfigFolder.get(), filename);
    }

    public void load() {
        T config = this.defaultConfig;
        if (!this.file.exists()) {
            this.save(config);
        }
        config = this.read();
        config.update();
        this.onLoad.accept(config);
        if (config.shouldWatch()) {
            this.watch(this.file);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T read() {
        try (FileReader reader = new FileReader(this.file);){
            IConfig iConfig = (IConfig)GSON.fromJson((Reader)reader, this.defaultConfig.getClass());
            return (T)iConfig;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.defaultConfig;
        }
    }

    public void save(T config) {
        try (FileWriter writer = new FileWriter(this.file);){
            writer.write(GSON.toJson(config));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void watch(File file) {
        if (this.watcher != null) {
            return;
        }
        this.watcher = FileWatcher.watch(file, () -> this.load());
    }
}

