/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.hud;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.ITooltipLine;
import mcp.mobius.waila.api.component.GrowingComponent;
import mcp.mobius.waila.api.component.WrappedComponent;
import mcp.mobius.waila.util.DisplayUtil;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;

public class Line
implements ITooltipLine {
    @Nullable
    public final class_2960 tag;
    public final List<ITooltipComponent> components = new ArrayList<ITooltipComponent>();
    private int width = -1;
    private int height = -1;
    private int growingCount = 0;

    public Line(@Nullable class_2960 tag) {
        this.tag = tag;
    }

    @Override
    public Line with(ITooltipComponent component) {
        this.components.add(component);
        this.height = Math.max(component.getHeight(), this.height);
        if (component instanceof GrowingComponent) {
            ++this.growingCount;
        }
        return this;
    }

    @Override
    public Line with(class_2561 component) {
        return this.with(new WrappedComponent(component));
    }

    public void calculateDimension() {
        if (this.width == -1) {
            this.width = this.components.stream().mapToInt(c -> {
                int width = c.getWidth();
                return width > 0 ? width + 1 : 0;
            }).sum();
            if (this.width > 0) {
                --this.width;
            }
        }
        if (this.height == -1) {
            this.height = this.components.stream().mapToInt(ITooltipComponent::getHeight).max().orElse(0);
        }
    }

    public int getWidth() {
        this.assertDimension();
        return this.width;
    }

    public int getHeight() {
        this.assertDimension();
        return this.height;
    }

    public void render(class_332 ctx, int x, int y, int maxWidth, float delta) {
        this.assertDimension();
        int cx = x;
        int growingWidth = -1;
        for (ITooltipComponent component : this.components) {
            if (component instanceof GrowingComponent) {
                if (growingWidth == -1 && (growingWidth = (maxWidth - this.width) / this.growingCount) % 2 == 1 && this.growingCount > 1) {
                    ++cx;
                }
                cx += growingWidth;
                continue;
            }
            int w = component.getWidth();
            int h = component.getHeight();
            if (w <= 0) continue;
            int cy = y + (h < this.height ? (this.height - h) / 2 : 0);
            DisplayUtil.renderComponent(ctx, component, cx, cy, delta);
            cx += w + 1;
        }
    }

    private void assertDimension() {
        Preconditions.checkState((this.width != -1 && this.height != -1 ? 1 : 0) != 0);
    }
}

