/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.pac.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1060;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_640;
import xaero.map.WorldMap;
import xaero.map.animation.SlowingAnimation;
import xaero.map.element.MapElementRenderer;
import xaero.map.graphics.CustomRenderTypes;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.map.icon.XaeroIcon;
import xaero.map.icon.XaeroIconAtlas;
import xaero.map.mods.pac.SupportOpenPartiesAndClaims;
import xaero.map.mods.pac.gui.PartyPlayerIconManager;
import xaero.map.mods.pac.gui.PlayerDynamicInfoMapElement;
import xaero.map.mods.pac.gui.PlayerDynamicInfoReader;
import xaero.map.mods.pac.gui.PlayerDynamicInfoRenderContext;
import xaero.map.mods.pac.gui.PlayerDynamicInfoRenderProvider;
import xaero.pac.common.parties.party.api.IPartyMemberDynamicInfoSyncableAPI;

public final class PlayerDynamicInfoRenderer
extends MapElementRenderer<PlayerDynamicInfoMapElement, PlayerDynamicInfoRenderContext, PlayerDynamicInfoRenderer> {
    private final SupportOpenPartiesAndClaims pac;
    private PartyPlayerIconManager partyPlayerIconManager;

    private PlayerDynamicInfoRenderer(SupportOpenPartiesAndClaims pac, PlayerDynamicInfoRenderContext context, PlayerDynamicInfoRenderProvider<PlayerDynamicInfoRenderContext> provider, PlayerDynamicInfoReader reader) {
        super(context, provider, reader);
        this.pac = pac;
    }

    public void setPartyPlayerIconManager(PartyPlayerIconManager partyPlayerIconManager) {
        this.partyPlayerIconManager = partyPlayerIconManager;
    }

    public PartyPlayerIconManager getPartyPlayerIconManager() {
        return this.partyPlayerIconManager;
    }

    @Override
    public void beforeRender(int location, class_310 mc, class_332 guiGraphics, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double guiBasedScale, class_1060 textureManager, class_327 fontRenderer, class_4597.class_4598 renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, boolean pre) {
        ((PlayerDynamicInfoRenderContext)this.context).textBGConsumer = renderTypeBuffers.getBuffer(CustomRenderTypes.MAP_ELEMENT_TEXT_BG);
        ((PlayerDynamicInfoRenderContext)this.context).uniqueTextureUIObjectRenderer = rendererProvider.getRenderer(t -> RenderSystem.setShaderTexture((int)0, (int)t), MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.GUI_BILINEAR_PREMULTIPLIED);
    }

    @Override
    public void afterRender(int location, class_310 mc, class_332 guiGraphics, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double guiBasedScale, class_1060 textureManager, class_327 fontRenderer, class_4597.class_4598 renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, boolean pre) {
        rendererProvider.draw(((PlayerDynamicInfoRenderContext)this.context).uniqueTextureUIObjectRenderer);
        renderTypeBuffers.method_22993();
        if (!pre) {
            this.pac.resetRenderedOnRadarFlags();
        }
    }

    @Override
    public void renderElementPre(int location, PlayerDynamicInfoMapElement element, boolean hovered, class_310 mc, class_332 guiGraphics, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double guiBasedScale, class_1060 textureManager, class_327 fontRenderer, class_4597.class_4598 renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, float optionalScale, double partialX, double partialY, boolean cave, float partialTicks) {
    }

    @Override
    public boolean renderElement(int location, PlayerDynamicInfoMapElement e, boolean hovered, class_310 mc, class_332 guiGraphics, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double guiBasedScale, class_1060 textureManager, class_327 fontRenderer, class_4597.class_4598 renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, int elementIndex, double optionalDepth, float optionalScale, double partialX, double partialY, boolean cave, float partialTicks) {
        class_4587 matrixStack = guiGraphics.method_51448();
        IPartyMemberDynamicInfoSyncableAPI syncable = e.getSyncable();
        class_640 info = class_310.method_1551().method_1562().method_2871(syncable.getPlayerId());
        if (info != null) {
            boolean firstTime;
            class_1657 clientPlayer = mc.field_1687.method_18470(syncable.getPlayerId());
            matrixStack.method_22903();
            double fadeDest = hovered ? 1.0 : 0.0;
            boolean bl = firstTime = e.getFadeAnim() == null;
            if (firstTime || e.getFadeAnim().getDestination() != fadeDest) {
                e.setFadeAnim(new SlowingAnimation(e.getFadeAnim() == null ? 0.0 : e.getFadeAnim().getCurrent(), fadeDest, 0.8, 0.001));
            }
            float alpha = (float)e.getFadeAnim().getCurrent();
            if (!e.wasRenderedOnRadar() || alpha > 0.0f) {
                if (alpha > 0.0f) {
                    matrixStack.method_22903();
                    matrixStack.method_22905(2.0f, 2.0f, 1.0f);
                    String name = info.method_2966().getName();
                    int nameWidth = fontRenderer.method_1727(name);
                    MapRenderHelper.fillIntoExistingBuffer(matrixStack.method_23760().method_23761(), ((PlayerDynamicInfoRenderContext)this.context).textBGConsumer, -8 - nameWidth - 2, -6, -7, 6, 0.0f, 0.0f, 0.0f, alpha * 119.0f / 255.0f);
                    int textAlphaComponent = (int)(alpha * 255.0f);
                    if (textAlphaComponent > 3) {
                        int tc = 0xFFFFFF | textAlphaComponent << 24;
                        guiGraphics.method_25303(fontRenderer, name, -8 - nameWidth, -4, tc);
                    }
                    matrixStack.method_22909();
                }
                matrixStack.method_22904(partialX, partialY, 0.0);
                matrixStack.method_22905((2.0f + alpha) / 3.0f, (2.0f + alpha) / 3.0f, 1.0f);
                XaeroIcon icon = this.getPartyPlayerIconManager().getIcon(guiGraphics, clientPlayer, info, e);
                XaeroIconAtlas atlas = icon.getTextureAtlas();
                MapRenderHelper.blitIntoMultiTextureRenderer(matrixStack.method_23760().method_23761(), ((PlayerDynamicInfoRenderContext)this.context).uniqueTextureUIObjectRenderer, -15.0f, -15.0f, icon.getOffsetX() + 1, icon.getOffsetY() + 31, 30, 30, 30, -30, 1.0f, 1.0f, 1.0f, 1.0f, atlas.getWidth(), atlas.getWidth(), atlas.getTextureId());
            }
            matrixStack.method_22909();
        }
        return false;
    }

    @Override
    public boolean shouldRender(int location, boolean pre) {
        return WorldMap.settings.pacPlayers;
    }

    public static final class Builder {
        private SupportOpenPartiesAndClaims pac;

        private Builder() {
        }

        private Builder setDefault() {
            this.setPac(null);
            return this;
        }

        public Builder setPac(SupportOpenPartiesAndClaims pac) {
            this.pac = pac;
            return this;
        }

        public PlayerDynamicInfoRenderer build() {
            if (this.pac == null) {
                throw new IllegalStateException();
            }
            return new PlayerDynamicInfoRenderer(this.pac, new PlayerDynamicInfoRenderContext(), new PlayerDynamicInfoRenderProvider<PlayerDynamicInfoRenderContext>(this.pac), new PlayerDynamicInfoReader());
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

