/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.render;

import java.util.function.Consumer;
import java.util.function.Function;
import link.infra.indium.mixin.sodium.AccessBlockRenderer;
import link.infra.indium.renderer.accessor.AccessBlockRenderCache;
import link.infra.indium.renderer.aocalc.AoCalculator;
import link.infra.indium.renderer.render.AbstractRenderContext;
import link.infra.indium.renderer.render.BaseFallbackConsumer;
import link.infra.indium.renderer.render.BaseMeshConsumer;
import link.infra.indium.renderer.render.ChunkQuadBufferer;
import link.infra.indium.renderer.render.ChunkRenderInfo;
import link.infra.indium.renderer.render.TerrainBlockRenderInfo;
import me.jellysquid.mods.sodium.client.gl.compile.ChunkBuildContext;
import me.jellysquid.mods.sodium.client.model.light.cache.ArrayLightDataCache;
import me.jellysquid.mods.sodium.client.model.light.data.LightDataAccess;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderCache;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderContext;
import me.jellysquid.mods.sodium.client.render.occlusion.BlockOcclusionCache;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_5539;
import org.joml.Vector3fc;

public class TerrainRenderContext
extends AbstractRenderContext {
    private final TerrainBlockRenderInfo blockInfo;
    private final ChunkRenderInfo chunkInfo;
    private final AoCalculator aoCalc;
    private Vector3fc origin;
    private class_243 modelOffset;
    private final BaseMeshConsumer meshConsumer;
    private final BaseFallbackConsumer fallbackConsumer;

    public TerrainRenderContext(BlockRenderCache renderCache) {
        WorldSlice worldSlice = renderCache.getWorldSlice();
        BlockOcclusionCache blockOcclusionCache = ((AccessBlockRenderer)renderCache.getBlockRenderer()).indium$occlusionCache();
        ArrayLightDataCache lightCache = ((AccessBlockRenderCache)renderCache).indium$getLightDataCache();
        this.blockInfo = new TerrainBlockRenderInfo(blockOcclusionCache);
        this.blockInfo.prepareForWorld((class_1920)worldSlice, true);
        this.chunkInfo = new ChunkRenderInfo((class_1920)worldSlice);
        this.aoCalc = new AoCalculator(this.blockInfo, (LightDataAccess)lightCache);
        this.meshConsumer = new BaseMeshConsumer(new QuadBufferer(this.chunkInfo::getChunkModelBuilder), this.blockInfo, this.aoCalc, this::transform);
        this.fallbackConsumer = new BaseFallbackConsumer(new QuadBufferer(this.chunkInfo::getChunkModelBuilder), this.blockInfo, this.aoCalc, this::transform);
    }

    public static TerrainRenderContext get(ChunkBuildContext buildContext) {
        return ((AccessBlockRenderCache)buildContext.cache).indium$getTerrainRenderContext();
    }

    public void prepare(ChunkBuildContext buildContext) {
        this.chunkInfo.prepare(buildContext.buffers);
    }

    public void release() {
        this.blockInfo.release();
        this.chunkInfo.release();
    }

    public boolean tessellateBlock(BlockRenderContext ctx) {
        this.origin = ctx.origin();
        this.modelOffset = ctx.state().method_26226((class_1922)ctx.world(), ctx.pos());
        try {
            this.chunkInfo.didOutput = false;
            this.aoCalc.clear();
            this.blockInfo.prepareForBlock(ctx.state(), ctx.pos(), ctx.model().method_4708(), ctx.seed());
            ((FabricBakedModel)ctx.model()).emitBlockQuads(this.blockInfo.blockView, this.blockInfo.blockState, this.blockInfo.blockPos, this.blockInfo.randomSupplier, (RenderContext)this);
        }
        catch (Throwable throwable) {
            class_128 crashReport = class_128.method_560((Throwable)throwable, (String)"Tessellating block in world - Indium Renderer");
            class_129 crashReportSection = crashReport.method_562("Block being tessellated");
            class_129.method_586((class_129)crashReportSection, (class_5539)this.chunkInfo.blockView, (class_2338)ctx.pos(), (class_2680)ctx.state());
            throw new class_148(crashReport);
        }
        return this.chunkInfo.didOutput;
    }

    public Consumer<Mesh> meshConsumer() {
        return this.meshConsumer;
    }

    public RenderContext.BakedModelConsumer bakedModelConsumer() {
        return this.fallbackConsumer;
    }

    public QuadEmitter getEmitter() {
        return this.meshConsumer.getEmitter();
    }

    private class QuadBufferer
    extends ChunkQuadBufferer {
        QuadBufferer(Function<class_1921, ChunkModelBuilder> builderFunc) {
            super(builderFunc);
        }

        @Override
        protected Vector3fc origin() {
            return TerrainRenderContext.this.origin;
        }

        @Override
        protected class_243 blockOffset() {
            return TerrainRenderContext.this.modelOffset;
        }
    }
}

