/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.impl.client.gui.toast.ExportRecipeIdentifierToast;
import me.shedaniel.rei.impl.display.DisplaySpec;
import net.minecraft.class_1011;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_6367;
import net.minecraft.class_8251;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;

@ApiStatus.Internal
public final class RecipeDisplayExporter {
    private RecipeDisplayExporter() {
    }

    public static void exportRecipeDisplay(Rectangle rectangle, DisplaySpec display, List<Widget> widgets, boolean toast) {
        RecipeDisplayExporter.exportRecipe(rectangle, display, widgets);
        if (toast) {
            ExportRecipeIdentifierToast.addToast(class_1074.method_4662((String)"msg.rei.exported_recipe", (Object[])new Object[0]), class_1074.method_4662((String)"msg.rei.exported_recipe.desc", (Object[])new Object[0]));
        }
    }

    private static File getExportFilename(DisplaySpec display, File directory) {
        Collection<class_2960> locations = display.provideInternalDisplayIds();
        String string = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date());
        if (!locations.isEmpty()) {
            string = locations.iterator().next().toString().replace('/', '_').replace(':', '_');
        }
        int i = 1;
        File file;
        while ((file = new File(directory, string + (String)(i == 1 ? "" : "_" + i) + ".png")).exists()) {
            ++i;
        }
        return file;
    }

    private static void exportRecipe(Rectangle rectangle, DisplaySpec display, List<Widget> widgets) {
        class_310 client = class_310.method_1551();
        class_1041 window = client.method_22683();
        class_6367 renderTarget = new class_6367(window.method_4489(), window.method_4506(), true, false);
        renderTarget.method_1235(true);
        RenderSystem.clear((int)256, (boolean)class_310.field_1703);
        Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)((double)window.method_4489() / window.method_4495()), 0.0f, (float)((double)window.method_4506() / window.method_4495()), 1000.0f, 3000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (class_8251)class_8251.field_43361);
        class_4587 poseStack = RenderSystem.getModelViewStack();
        poseStack.method_22903();
        poseStack.method_34426();
        poseStack.method_22904(0.0, 0.0, -2000.0);
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
        class_332 graphics = new class_332(client, client.method_22940().method_23000());
        for (Widget widget : widgets) {
            widget.method_25394(graphics, -1, -1, 0.0f);
        }
        class_1011 nativeImage = new class_1011(renderTarget.field_1482, renderTarget.field_1481, false);
        RenderSystem.bindTexture((int)renderTarget.method_30277());
        nativeImage.method_4327(0, false);
        nativeImage.method_4319();
        int outWidth = (int)((double)rectangle.width * window.method_4495());
        int outHeight = (int)((double)rectangle.height * window.method_4495());
        class_1011 strippedImage = new class_1011(outWidth, outHeight, false);
        for (int y = 0; y < outHeight; ++y) {
            for (int x = 0; x < outWidth; ++x) {
                strippedImage.method_4305(x, y, nativeImage.method_4315(x + (int)((double)rectangle.x * window.method_4495()), y + (int)((double)rectangle.y * window.method_4495())));
            }
        }
        class_156.method_27958().execute(() -> {
            try {
                File export = new File(class_310.method_1551().field_1697, "rei_exports/" + display.provideInternalDisplay().getCategoryIdentifier().toString().replace('/', '_').replace(':', '_'));
                export.mkdirs();
                strippedImage.method_4325(RecipeDisplayExporter.getExportFilename(display, export));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                nativeImage.close();
                strippedImage.close();
            }
        });
        renderTarget.method_1238();
        class_310.method_1551().field_1769.method_35774();
        class_310.method_1551().method_1522().method_1235(true);
        poseStack.method_22909();
        RenderSystem.applyModelViewMatrix();
    }
}

