/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.registries.fabric;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarBuilder;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.architectury.registry.registries.options.RegistrarOption;
import dev.architectury.registry.registries.options.StandardRegistrarOption;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class RegistrarManagerImpl {
    private static final Multimap<RegistryEntryId<?>, Consumer<?>> LISTENERS = HashMultimap.create();
    private static final Set<class_5321<?>> LISTENED_REGISTRIES = new HashSet();

    private static void listen(class_5321<?> resourceKey, class_2960 id, Consumer<?> listener) {
        if (LISTENED_REGISTRIES.add(resourceKey)) {
            class_2378 registry = Objects.requireNonNull((class_2378)class_7923.field_41167.method_10223(resourceKey.method_29177()), "Registry " + resourceKey + " not found!");
            RegistryEntryAddedCallback.event((class_2378)registry).register((rawId, entryId, object) -> {
                RegistryEntryId registryEntryId = new RegistryEntryId(resourceKey, entryId);
                for (Consumer consumer : LISTENERS.get(registryEntryId)) {
                    consumer.accept(object);
                }
                LISTENERS.removeAll(registryEntryId);
            });
        }
        LISTENERS.put(new RegistryEntryId(resourceKey, id), listener);
    }

    public static RegistrarManager.RegistryProvider _get(String modId) {
        return new RegistryProviderImpl(modId);
    }

    public static class RegistryEntryId<T> {
        private final class_5321<T> registryKey;
        private final class_2960 id;

        public RegistryEntryId(class_5321<T> registryKey, class_2960 id) {
            this.registryKey = registryKey;
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RegistryEntryId)) {
                return false;
            }
            RegistryEntryId that = (RegistryEntryId)o;
            return Objects.equals(this.registryKey, that.registryKey) && Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.registryKey, this.id);
        }
    }

    public static class RegistryProviderImpl
    implements RegistrarManager.RegistryProvider {
        private final String modId;

        public RegistryProviderImpl(String modId) {
            this.modId = modId;
        }

        @Override
        public <T> Registrar<T> get(class_5321<class_2378<T>> key) {
            return new RegistrarImpl(this.modId, Objects.requireNonNull((class_2378)class_7923.field_41167.method_10223(key.method_29177()), "Registry " + key + " not found!"));
        }

        @Override
        public <T> Registrar<T> get(class_2378<T> registry) {
            return new RegistrarImpl<T>(this.modId, registry);
        }

        @Override
        public <T> void forRegistry(class_5321<class_2378<T>> key, Consumer<Registrar<T>> consumer) {
            consumer.accept(this.get(key));
        }

        @Override
        public <T> RegistrarBuilder<T> builder(Class<T> type, class_2960 registryId) {
            return new RegistrarBuilderWrapper(this.modId, FabricRegistryBuilder.createSimple(type, (class_2960)registryId));
        }
    }

    public static class RegistrarImpl<T>
    implements Registrar<T> {
        private final String modId;
        private class_2378<T> delegate;

        public RegistrarImpl(String modId, class_2378<T> delegate) {
            this.modId = modId;
            this.delegate = delegate;
        }

        @Override
        public RegistrySupplier<T> delegate(final class_2960 id) {
            Supplier value = Suppliers.memoize(() -> this.get(id));
            final RegistrarImpl registrar = this;
            return new RegistrySupplier<T>((java.util.function.Supplier)value){
                final /* synthetic */ java.util.function.Supplier val$value;
                {
                    this.val$value = supplier;
                }

                @Override
                public RegistrarManager getRegistrarManager() {
                    return RegistrarManager.get(modId);
                }

                @Override
                public Registrar<T> getRegistrar() {
                    return registrar;
                }

                @Override
                public class_2960 getRegistryId() {
                    return delegate.method_30517().method_29177();
                }

                @Override
                public class_2960 getId() {
                    return id;
                }

                @Override
                public boolean isPresent() {
                    return this.contains(id);
                }

                @Override
                public T get() {
                    return this.val$value.get();
                }

                public int hashCode() {
                    return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.getRegistryId(), this.getId()});
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (!(obj instanceof RegistrySupplier)) {
                        return false;
                    }
                    RegistrySupplier other = (RegistrySupplier)obj;
                    return other.getRegistryId().equals((Object)this.getRegistryId()) && other.getId().equals((Object)this.getId());
                }

                public String toString() {
                    return this.getRegistryId().toString() + "@" + id.toString();
                }
            };
        }

        @Override
        public <E extends T> RegistrySupplier<E> register(class_2960 id, java.util.function.Supplier<E> supplier) {
            class_2378.method_10230(this.delegate, (class_2960)id, supplier.get());
            return this.delegate(id);
        }

        @Override
        @Nullable
        public class_2960 getId(T obj) {
            return this.delegate.method_10221(obj);
        }

        @Override
        public int getRawId(T obj) {
            return this.delegate.method_10206(obj);
        }

        @Override
        public Optional<class_5321<T>> getKey(T obj) {
            return this.delegate.method_29113(obj);
        }

        @Override
        @Nullable
        public T get(class_2960 id) {
            return (T)this.delegate.method_10223(id);
        }

        @Override
        public T byRawId(int rawId) {
            return (T)this.delegate.method_10200(rawId);
        }

        @Override
        public boolean contains(class_2960 id) {
            return this.delegate.method_10235().contains(id);
        }

        @Override
        public boolean containsValue(T obj) {
            return this.delegate.method_29113(obj).isPresent();
        }

        @Override
        public Set<class_2960> getIds() {
            return this.delegate.method_10235();
        }

        @Override
        public Set<Map.Entry<class_5321<T>, T>> entrySet() {
            return this.delegate.method_29722();
        }

        @Override
        public class_5321<? extends class_2378<T>> key() {
            return this.delegate.method_30517();
        }

        @Override
        public Iterator<T> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public void listen(class_2960 id, Consumer<T> callback) {
            if (this.contains(id)) {
                callback.accept(this.get(id));
            } else {
                RegistrarManagerImpl.listen(this.key(), id, callback);
            }
        }
    }

    public static class RegistrarBuilderWrapper<T>
    implements RegistrarBuilder<T> {
        private final String modId;
        private FabricRegistryBuilder<T, class_2370<T>> builder;

        public RegistrarBuilderWrapper(String modId, FabricRegistryBuilder<T, class_2370<T>> builder) {
            this.modId = modId;
            this.builder = builder;
        }

        @Override
        public Registrar<T> build() {
            return RegistrarManager.get(this.modId).get(this.builder.buildAndRegister());
        }

        @Override
        public RegistrarBuilder<T> option(RegistrarOption option) {
            if (option == StandardRegistrarOption.SAVE_TO_DISC) {
                this.builder.attribute(RegistryAttribute.PERSISTED);
            } else if (option == StandardRegistrarOption.SYNC_TO_CLIENTS) {
                this.builder.attribute(RegistryAttribute.SYNCED);
            }
            return this;
        }
    }
}

