/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.lightoverlay.common;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.function.Consumer;
import java.util.function.Function;
import me.shedaniel.lightoverlay.common.CubicChunkPos;
import me.shedaniel.lightoverlay.common.LightOverlay;
import me.shedaniel.lightoverlay.common.LightOverlayTicker;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_265;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_4668;
import net.minecraft.class_746;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class LightOverlayRenderer
implements Consumer<class_4587> {
    private static final Function<Double, class_1921.class_4687> LINE = class_156.method_34866(double_ -> class_1921.method_24048((String)"light_overlay_lines", (class_293)class_290.field_1576, (class_293.class_5596)class_293.class_5596.field_29344, (int)256, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(class_4668.field_29442).method_23609(new class_4668.class_4677(OptionalDouble.of(double_))).method_23615(class_4668.field_21364).method_23603(class_4668.field_21345).method_23617(false)));
    private final class_310 minecraft = class_310.method_1551();
    public class_4604 frustum;
    public LightOverlayTicker ticker;

    public LightOverlayRenderer(LightOverlayTicker ticker) {
        this.ticker = ticker;
    }

    @Override
    public void accept(class_4587 poses) {
        if (LightOverlay.enabled) {
            class_746 playerEntity = this.minecraft.field_1724;
            class_2338 playerPos = new class_2338(playerEntity.method_31477(), playerEntity.method_31478(), playerEntity.method_31479());
            int playerPosX = playerPos.method_10263() >> 4;
            int playerPosY = playerPos.method_10264() >> 5;
            int playerPosZ = playerPos.method_10260() >> 4;
            class_3726 collisionContext = class_3726.method_16195((class_1297)playerEntity);
            class_4184 camera = this.minecraft.field_1773.method_19418();
            int chunkRange = LightOverlay.getChunkRange();
            if (LightOverlay.showNumber) {
                this.renderLevels(poses, camera, playerPos, playerPosX, playerPosY, playerPosZ, chunkRange, collisionContext);
            } else {
                this.renderCrosses(poses, camera, playerPos, playerPosX, playerPosY, playerPosZ, chunkRange, collisionContext);
            }
            class_310.method_1551().method_22940().method_23000().method_37104();
        }
    }

    private void renderLevels(class_4587 poses, class_4184 camera, class_2338 playerPos, int playerPosX, int playerPosY, int playerPosZ, int chunkRange, class_3726 collisionContext) {
        RenderSystem.depthMask((boolean)true);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        class_2338.class_2339 downMutable = new class_2338.class_2339();
        class_4597.class_4598 source = class_310.method_1551().method_22940().method_23000();
        for (Map.Entry<CubicChunkPos, Long2ByteMap> entry : this.ticker.CHUNK_MAP.entrySet()) {
            CubicChunkPos chunkPos = entry.getKey();
            if (LightOverlay.caching && (class_3532.method_15382((int)(chunkPos.x - playerPosX)) > chunkRange || class_3532.method_15382((int)(chunkPos.y - playerPosY)) > Math.max(1, chunkRange >> 1) || class_3532.method_15382((int)(chunkPos.z - playerPosZ)) > chunkRange)) continue;
            for (Long2ByteMap.Entry objectEntry : entry.getValue().long2ByteEntrySet()) {
                mutable.method_16363(objectEntry.getLongKey());
                if (!mutable.method_19771((class_2382)playerPos, (double)LightOverlay.reach) || !this.isFrustumVisible(mutable.method_10263(), mutable.method_10264(), mutable.method_10260(), mutable.method_10263() + 1, mutable.method_10263() + 1, mutable.method_10263() + 1)) continue;
                downMutable.method_10103(mutable.method_10263(), mutable.method_10264() - 1, mutable.method_10260());
                this.renderLevel(poses, source, camera, (class_1937)this.minecraft.field_1687, (class_2338)mutable, (class_2338)downMutable, objectEntry.getByteValue(), collisionContext);
            }
        }
        RenderSystem.enableDepthTest();
    }

    public void renderLevel(class_4587 poses, class_4597.class_4598 source, class_4184 camera, class_1937 world, class_2338 pos, class_2338 down, byte level, class_3726 collisionContext) {
        String text = String.valueOf(level);
        class_327 font = this.minecraft.field_1772;
        double cameraX = camera.method_19326().field_1352;
        double cameraY = camera.method_19326().field_1351;
        class_265 upperOutlineShape = world.method_8320(down).method_26172((class_1922)world, down, collisionContext);
        if (!upperOutlineShape.method_1110()) {
            cameraY += 1.0 - upperOutlineShape.method_1105(class_2350.class_2351.field_11052);
        }
        double cameraZ = camera.method_19326().field_1350;
        poses.method_22903();
        poses.method_22904((double)pos.method_10263() + 0.5 - cameraX, (double)pos.method_10264() - cameraY + 0.005, (double)pos.method_10260() + 0.5 - cameraZ);
        poses.method_22907(new Quaternionf().fromAxisAngleDeg(1.0f, 0.0f, 0.0f, 90.0f));
        float size = 0.07f;
        poses.method_22905(-size, -size, size);
        float float_3 = (float)(-font.method_1727(text)) / 2.0f + 0.4f;
        font.method_27521(text, float_3, -3.5f, level > LightOverlay.higherCrossLevel ? -16505852 : (LightOverlay.lowerCrossLevel >= 0 && level > LightOverlay.lowerCrossLevel ? -16750849 : -9236207), false, poses.method_23760().method_23761(), (class_4597)source, class_327.class_6415.field_33994, 0, 0xF000F0);
        poses.method_22909();
    }

    private void renderCrosses(class_4587 poses, class_4184 camera, class_2338 playerPos, int playerPosX, int playerPosY, int playerPosZ, int chunkRange, class_3726 collisionContext) {
        class_4597.class_4598 source = class_310.method_1551().method_22940().method_23000();
        class_4588 buffer = source.getBuffer((class_1921)LINE.apply(Double.valueOf(LightOverlay.lineWidth)));
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (Map.Entry<CubicChunkPos, Long2ByteMap> entry : this.ticker.CHUNK_MAP.entrySet()) {
            CubicChunkPos chunkPos = entry.getKey();
            if (LightOverlay.caching && (class_3532.method_15382((int)(chunkPos.x - playerPosX)) > chunkRange || class_3532.method_15382((int)(chunkPos.y - playerPosY)) > Math.max(1, chunkRange >> 1) || class_3532.method_15382((int)(chunkPos.z - playerPosZ)) > chunkRange)) continue;
            for (Long2ByteMap.Entry objectEntry : entry.getValue().long2ByteEntrySet()) {
                byte crossType = objectEntry.getByteValue();
                mutable.method_16363(objectEntry.getLongKey());
                if (!mutable.method_19771((class_2382)playerPos, (double)LightOverlay.reach) || !this.isFrustumVisible(mutable.method_10263(), mutable.method_10264(), mutable.method_10260(), mutable.method_10263() + 1, mutable.method_10263() + 1, mutable.method_10263() + 1)) continue;
                int color = switch (crossType) {
                    case 1 -> LightOverlay.redColor;
                    case 0 -> LightOverlay.yellowColor;
                    default -> LightOverlay.secondaryColor;
                };
                this.renderCross(poses.method_23760().method_23761(), buffer, camera, (class_1937)this.minecraft.field_1687, (class_2338)mutable, color, collisionContext);
            }
        }
    }

    public void renderCross(Matrix4f pose, class_4588 builder, class_4184 camera, class_1937 world, class_2338 pos, int color, class_3726 collisionContext) {
        float cameraX = (float)camera.method_19326().field_1352;
        float cameraY = (float)camera.method_19326().field_1351 - 0.005f;
        float blockOffset = 0.0f;
        class_265 upperOutlineShape = world.method_8320(pos).method_26172((class_1922)world, pos, collisionContext);
        if (!upperOutlineShape.method_1110()) {
            blockOffset = (float)((double)blockOffset + upperOutlineShape.method_1105(class_2350.class_2351.field_11052));
        }
        float cameraZ = (float)camera.method_19326().field_1350;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        float x = (float)pos.method_10263() - cameraX;
        float y = (float)pos.method_10264() - cameraY + blockOffset;
        float z = (float)pos.method_10260() - cameraZ;
        builder.method_22918(pose, x + 0.01f, y, z + 0.01f).method_1336(red, green, blue, 255).method_1344();
        builder.method_22918(pose, x + 0.99f, y, z + 0.99f).method_1336(red, green, blue, 255).method_1344();
        builder.method_22918(pose, x + 0.99f, y, z + 0.01f).method_1336(red, green, blue, 255).method_1344();
        builder.method_22918(pose, x + 0.01f, y, z + 0.99f).method_1336(red, green, blue, 255).method_1344();
    }

    public boolean isFrustumVisible(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return this.frustum.method_23093(new class_238(minX, minY, minZ, maxX, maxY, maxZ));
    }
}

