/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp;

import me.jellysquid.mods.sodium.client.render.vertex.type.ChunkVertexEncoder;
import net.coderbot.iris.compat.sodium.impl.block_context.BlockContextHolder;
import net.coderbot.iris.compat.sodium.impl.block_context.ContextAwareVertexWriter;
import net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp.QuadViewTerrain;
import net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp.XHFPModelVertexType;
import net.coderbot.iris.vertices.ExtendedDataHelper;
import net.coderbot.iris.vertices.NormalHelper;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryUtil;

public class XHFPTerrainVertex
implements ChunkVertexEncoder,
ContextAwareVertexWriter {
    private final QuadViewTerrain.QuadViewTerrainUnsafe quad = new QuadViewTerrain.QuadViewTerrainUnsafe();
    private final Vector3f normal = new Vector3f();
    private BlockContextHolder contextHolder;
    private int vertexCount;
    private float uSum;
    private float vSum;
    private boolean flipUpcomingNormal;

    @Override
    public void iris$setContextHolder(BlockContextHolder blockContextHolder) {
        this.contextHolder = blockContextHolder;
    }

    @Override
    public void flipUpcomingQuadNormal() {
        this.flipUpcomingNormal = true;
    }

    public long write(long l, ChunkVertexEncoder.Vertex vertex, int n) {
        this.uSum += vertex.u;
        this.vSum += vertex.v;
        ++this.vertexCount;
        MemoryUtil.memPutShort((long)(l + 0L), (short)XHFPModelVertexType.encodePosition(vertex.x));
        MemoryUtil.memPutShort((long)(l + 2L), (short)XHFPModelVertexType.encodePosition(vertex.y));
        MemoryUtil.memPutShort((long)(l + 4L), (short)XHFPModelVertexType.encodePosition(vertex.z));
        MemoryUtil.memPutShort((long)(l + 6L), (short)((short)n));
        MemoryUtil.memPutInt((long)(l + 8L), (int)vertex.color);
        MemoryUtil.memPutShort((long)(l + 12L), (short)XHFPModelVertexType.encodeBlockTexture(vertex.u));
        MemoryUtil.memPutShort((long)(l + 14L), (short)XHFPModelVertexType.encodeBlockTexture(vertex.v));
        MemoryUtil.memPutInt((long)(l + 16L), (int)vertex.light);
        MemoryUtil.memPutShort((long)(l + 32L), (short)this.contextHolder.blockId);
        MemoryUtil.memPutShort((long)(l + 34L), (short)this.contextHolder.renderType);
        MemoryUtil.memPutInt((long)(l + 36L), (int)(this.contextHolder.ignoreMidBlock ? 0 : ExtendedDataHelper.computeMidBlock(vertex.x, vertex.y, vertex.z, this.contextHolder.localPosX, this.contextHolder.localPosY, this.contextHolder.localPosZ)));
        if (this.vertexCount == 4) {
            this.vertexCount = 0;
            this.uSum *= 0.25f;
            this.vSum *= 0.25f;
            short s = XHFPModelVertexType.encodeBlockTexture(this.uSum);
            short s2 = XHFPModelVertexType.encodeBlockTexture(this.vSum);
            MemoryUtil.memPutShort((long)(l + 20L), (short)s);
            MemoryUtil.memPutShort((long)(l + 20L - 40L), (short)s);
            MemoryUtil.memPutShort((long)(l + 20L - 80L), (short)s);
            MemoryUtil.memPutShort((long)(l + 20L - 120L), (short)s);
            MemoryUtil.memPutShort((long)(l + 22L), (short)s2);
            MemoryUtil.memPutShort((long)(l + 22L - 40L), (short)s2);
            MemoryUtil.memPutShort((long)(l + 22L - 80L), (short)s2);
            MemoryUtil.memPutShort((long)(l + 22L - 120L), (short)s2);
            this.uSum = 0.0f;
            this.vSum = 0.0f;
            this.quad.setup(l, 40);
            if (this.flipUpcomingNormal) {
                NormalHelper.computeFaceNormalFlipped(this.normal, this.quad);
                this.flipUpcomingNormal = false;
            } else {
                NormalHelper.computeFaceNormal(this.normal, this.quad);
            }
            int n2 = NormalHelper.packNormal(this.normal, 0.0f);
            MemoryUtil.memPutInt((long)(l + 28L), (int)n2);
            MemoryUtil.memPutInt((long)(l + 28L - 40L), (int)n2);
            MemoryUtil.memPutInt((long)(l + 28L - 80L), (int)n2);
            MemoryUtil.memPutInt((long)(l + 28L - 120L), (int)n2);
            int n3 = NormalHelper.computeTangent(this.normal.x, this.normal.y, this.normal.z, this.quad);
            MemoryUtil.memPutInt((long)(l + 24L), (int)n3);
            MemoryUtil.memPutInt((long)(l + 24L - 40L), (int)n3);
            MemoryUtil.memPutInt((long)(l + 24L - 80L), (int)n3);
            MemoryUtil.memPutInt((long)(l + 24L - 120L), (int)n3);
        }
        return l + 40L;
    }
}

