/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.worldtime;

import de.guntram.mcmod.fabrictools.ConfigChangedEvent;
import de.guntram.mcmod.fabrictools.Configuration;
import de.guntram.mcmod.fabrictools.ModConfigurationHandler;
import java.io.File;

public class ConfigurationHandler
implements ModConfigurationHandler {
    private static ConfigurationHandler instance;
    private Configuration config;
    private String configFileName;
    private boolean wantGameTime;
    private int offsetLeft;
    private int offsetTop;
    private String prefix;
    private String GTFormat;
    private boolean wantRealTime;
    private int offsetRTLeft;
    private int offsetRTTop;
    private String RTFormat;
    private String RTPrefix;
    private int RTOffset;
    private boolean wantCoords;
    private int offsetCOLeft;
    private int offsetCOTop;
    private String COFormat;
    private String COPrefix;
    private final String CONF_GT = "worldtime.config.gametime";
    private final String CONF_GTX = "worldtime.config.gametimex";
    private final String CONF_GTY = "worldtime.config.gametimey";
    private final String CONF_GTFORMAT = "worldtime.config.gametimeformat";
    private final String CONF_GTPREFIX = "worldtime.config.gametimeprefix";
    private final String CONF_RT = "worldtime.config.realtime";
    private final String CONF_RTX = "worldtime.config.realtimex";
    private final String CONF_RTY = "worldtime.config.realtimey";
    private final String CONF_RTFORMAT = "worldtime.config.realtimeformat";
    private final String CONF_RTPREFIX = "worldtime.config.realtimeprefix";
    private final String CONF_RTOFFSET = "worldtime.config.realtimeoffset";
    private final String CONF_CO = "worldtime.config.coords";
    private final String CONF_COX = "worldtime.config.coordsx";
    private final String CONF_COY = "worldtime.config.coordsy";
    private final String CONF_COPREFIX = "worldtime.config.coordsprefix";
    private final String CONF_COFORMAT = "worldtime.config.coordsformat";

    public static ConfigurationHandler getInstance() {
        if (instance == null) {
            instance = new ConfigurationHandler();
        }
        return instance;
    }

    public void load(File configFile) {
        if (this.config == null) {
            this.config = new Configuration(configFile);
            this.configFileName = configFile.getPath();
            this.loadConfig();
        }
    }

    public static String getConfigFileName() {
        return ConfigurationHandler.getInstance().configFileName;
    }

    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("World Time")) {
            this.loadConfig();
        }
    }

    public void onConfigChanging(ConfigChangedEvent.OnConfigChangingEvent event) {
        if (event.getModID().equals("World Time")) {
            switch (event.getItem()) {
                case "worldtime.config.gametime": {
                    this.wantGameTime = (Boolean)event.getNewValue();
                    break;
                }
                case "worldtime.config.gametimex": {
                    this.offsetLeft = (Integer)event.getNewValue();
                    break;
                }
                case "worldtime.config.gametimey": {
                    this.offsetTop = (Integer)event.getNewValue();
                    break;
                }
                case "worldtime.config.gametimeformat": {
                    this.GTFormat = (String)event.getNewValue();
                    break;
                }
                case "worldtime.config.gametimeprefix": {
                    this.prefix = (String)event.getNewValue();
                    break;
                }
                case "worldtime.config.realtime": {
                    this.wantRealTime = (Boolean)event.getNewValue();
                    break;
                }
                case "worldtime.config.realtimex": {
                    this.offsetRTLeft = (Integer)event.getNewValue();
                    break;
                }
                case "worldtime.config.realtimey": {
                    this.offsetRTTop = (Integer)event.getNewValue();
                    break;
                }
                case "worldtime.config.realtimeformat": {
                    this.RTFormat = (String)event.getNewValue();
                    break;
                }
                case "worldtime.config.realtimeprefix": {
                    this.RTPrefix = (String)event.getNewValue();
                    break;
                }
                case "worldtime.config.realtimeoffset": {
                    try {
                        this.RTOffset = Integer.parseInt((String)event.getNewValue());
                    }
                    catch (NumberFormatException ex) {
                        this.RTOffset = 0;
                    }
                    break;
                }
                case "worldtime.config.coords": {
                    this.wantCoords = (Boolean)event.getNewValue();
                    break;
                }
                case "worldtime.config.coordsx": {
                    this.offsetCOLeft = (Integer)event.getNewValue();
                    break;
                }
                case "worldtime.config.coordsy": {
                    this.offsetCOTop = (Integer)event.getNewValue();
                    break;
                }
                case "worldtime.config.coordsformat": {
                    this.COFormat = (String)event.getNewValue();
                    break;
                }
                case "worldtime.config.coordsprefix": {
                    this.COPrefix = (String)event.getNewValue();
                }
            }
        }
    }

    private void loadConfig() {
        this.config.migrate("X Percent", "worldtime.config.gametimex");
        this.config.migrate("Y Percent", "worldtime.config.gametimey");
        this.config.migrate("Prefix", "worldtime.config.gametimeprefix");
        this.config.migrate("Game Time", "worldtime.config.gametime");
        this.config.migrate("Game Time X Percent", "worldtime.config.gametimex");
        this.config.migrate("Game Time Y Percent", "worldtime.config.gametimey");
        this.config.migrate("Game Time Prefix", "worldtime.config.gametimeprefix");
        this.config.migrate("Real Time", "worldtime.config.realtime");
        this.config.migrate("Real Time X Percent", "worldtime.config.realtimex");
        this.config.migrate("Real Time Y Percent", "worldtime.config.realtimey");
        this.config.migrate("Real Time Prefix", "worldtime.config.realtimeprefix");
        this.config.migrate("Real Time Format", "worldtime.config.realtimeformat");
        this.wantGameTime = this.config.getBoolean("worldtime.config.gametime", 0, true, "worldtime.config.tt.gametime");
        this.offsetLeft = this.config.getInt("worldtime.config.gametimex", 0, 0, 0, 100, "worldtime.config.tt.offsetleft");
        this.offsetTop = this.config.getInt("worldtime.config.gametimey", 0, 5, 0, 100, "worldtime.config.tt.offsettop");
        this.prefix = this.config.getString("worldtime.config.gametimeprefix", 0, "", "worldtime.config.tt.prefix");
        this.GTFormat = this.config.getString("worldtime.config.gametimeformat", 0, "HH:mm", "worldtime.config.tt.gametimeformat");
        this.wantRealTime = this.config.getBoolean("worldtime.config.realtime", 0, false, "worldtime.config.tt.realtime");
        this.offsetRTLeft = this.config.getInt("worldtime.config.realtimex", 0, 0, 0, 100, "worldtime.config.tt.offsetleft");
        this.offsetRTTop = this.config.getInt("worldtime.config.realtimey", 0, 10, 0, 100, "worldtime.config.tt.offsettop");
        this.RTFormat = this.config.getString("worldtime.config.realtimeformat", 0, "HH:mm:ss", "worldtime.config.tt.realtimeformat");
        this.RTPrefix = this.config.getString("worldtime.config.realtimeprefix", 0, "", "worldtime.config.tt.prefix");
        try {
            this.RTOffset = Integer.parseInt(this.config.getString("worldtime.config.realtimeoffset", 0, "0", "worldtime.config.tt.realtimeoffset"));
        }
        catch (NumberFormatException ex) {
            this.RTOffset = 0;
        }
        this.wantCoords = this.config.getBoolean("worldtime.config.coords", 0, false, "worldtime.config.tt.coords");
        this.offsetCOLeft = this.config.getInt("worldtime.config.coordsx", 0, 0, 0, 100, "worldtime.config.tt.offsetleft");
        this.offsetCOTop = this.config.getInt("worldtime.config.coordsy", 0, 10, 0, 100, "worldtime.config.tt.offsettop");
        this.COFormat = this.config.getString("worldtime.config.coordsformat", 0, "Position {X}/{Z} Height {Y}", "worldtime.config.tt.coordformat");
        this.COPrefix = this.config.getString("worldtime.config.coordsprefix", 0, "", "worldtime.config.tt.prefix");
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public Configuration getConfig() {
        return ConfigurationHandler.getInstance().config;
    }

    public static boolean wantGameTime() {
        return ConfigurationHandler.getInstance().wantGameTime;
    }

    public static String getGameTimeFormat() {
        return ConfigurationHandler.getInstance().GTFormat;
    }

    public static int getOffsetLeft() {
        return ConfigurationHandler.getInstance().offsetLeft;
    }

    public static int getOffsetTop() {
        return ConfigurationHandler.getInstance().offsetTop;
    }

    public static String getPrefix() {
        return ConfigurationHandler.getInstance().prefix.replace('&', '\u00a7');
    }

    public static boolean wantRealTime() {
        return ConfigurationHandler.getInstance().wantRealTime;
    }

    public static String getRealTimeFormat() {
        return ConfigurationHandler.getInstance().RTFormat;
    }

    public static int getRealTimeOffsetLeft() {
        return ConfigurationHandler.getInstance().offsetRTLeft;
    }

    public static int getRealTimeOffsetTop() {
        return ConfigurationHandler.getInstance().offsetRTTop;
    }

    public static String getRealTimePrefix() {
        return ConfigurationHandler.getInstance().RTPrefix.replace('&', '\u00a7');
    }

    public static int getOffsetMinutes() {
        return ConfigurationHandler.getInstance().RTOffset;
    }

    public static boolean wantCoords() {
        return ConfigurationHandler.getInstance().wantCoords;
    }

    public static String getCoordsFormat() {
        return ConfigurationHandler.getInstance().COFormat.replace('&', '\u00a7');
    }

    public static int getCoordsOffsetLeft() {
        return ConfigurationHandler.getInstance().offsetCOLeft;
    }

    public static int getCoordsOffsetTop() {
        return ConfigurationHandler.getInstance().offsetCOTop;
    }

    public static String getCoordsPrefix() {
        return ConfigurationHandler.getInstance().COPrefix.replace('&', '\u00a7');
    }
}

