/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.worldtime;

import de.guntram.mcmod.worldtime.ConfigurationHandler;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class GuiWorldTime {
    class_310 minecraft = class_310.method_1551();

    public void onRenderGameOverlayPost(class_332 context, float partialticks) {
        if (this.minecraft == null || this.minecraft.field_1724 == null || this.minecraft.field_1724.method_37908() == null) {
            return;
        }
        if (ConfigurationHandler.wantGameTime()) {
            Object clock;
            long daytime = this.minecraft.field_1724.method_37908().method_8532() + 6000L;
            int hours = (int)(daytime / 1000L) % 24;
            int minutes = (int)(daytime % 1000L * 60L / 1000L);
            int day = (int)daytime / 1000 / 24;
            try {
                String strDateFormat = ConfigurationHandler.getGameTimeFormat().replace("J", Integer.toString(day));
                SimpleDateFormat dateFormat = new SimpleDateFormat(strDateFormat);
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.set(2000, 0, day + 1, hours, minutes, 0);
                clock = ConfigurationHandler.getPrefix() + dateFormat.format(calendar.getTimeInMillis());
            }
            catch (IllegalArgumentException ex) {
                clock = "illegal clock format; google for Java SimpleDateFormat";
            }
            this.displayStringAtPercentages(context, (String)clock, ConfigurationHandler.getOffsetLeft(), ConfigurationHandler.getOffsetTop());
        }
        if (ConfigurationHandler.wantRealTime()) {
            Object clock;
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(ConfigurationHandler.getRealTimeFormat());
                clock = ConfigurationHandler.getRealTimePrefix() + dateFormat.format(new Date(new Date().getTime() + (long)(ConfigurationHandler.getOffsetMinutes() * 60 * 1000)));
            }
            catch (IllegalArgumentException ex) {
                clock = "illegal clock format; google for Java SimpleDateFormat";
            }
            this.displayStringAtPercentages(context, (String)clock, ConfigurationHandler.getRealTimeOffsetLeft(), ConfigurationHandler.getRealTimeOffsetTop());
        }
        if (ConfigurationHandler.wantCoords()) {
            String coords = ConfigurationHandler.getCoordsPrefix() + ConfigurationHandler.getCoordsFormat().replace("{X}", String.format("%.1f", this.minecraft.field_1724.method_19538().field_1352)).replace("{Y}", String.format("%.1f", this.minecraft.field_1724.method_19538().field_1351)).replace("{Z}", String.format("%.1f", this.minecraft.field_1724.method_19538().field_1350));
            this.displayStringAtPercentages(context, coords, ConfigurationHandler.getCoordsOffsetLeft(), ConfigurationHandler.getCoordsOffsetTop());
        }
    }

    private void displayStringAtPercentages(class_332 context, String string, int xperc, int yperc) {
        class_1041 mainWindow = this.minecraft.method_22683();
        int xneed = this.minecraft.field_1772.method_1727(string);
        Objects.requireNonNull(this.minecraft.field_1772);
        int yneed = 9;
        int xpos = (mainWindow.method_4486() - xneed) * xperc / 100;
        int ypos = (mainWindow.method_4502() - yneed) * yperc / 100;
        context.method_25303(this.minecraft.field_1772, string, xpos, ypos, 0xFFFFFF);
    }
}

