/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui.options.control;

import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.control.Control;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlElement;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.class_332;
import net.minecraft.class_768;

public class TickBoxControl
implements Control<Boolean> {
    private final Option<Boolean> option;

    public TickBoxControl(Option<Boolean> option) {
        this.option = option;
    }

    @Override
    public ControlElement<Boolean> createElement(Dim2i dim) {
        return new TickBoxControlElement(this.option, dim);
    }

    @Override
    public int getMaxWidth() {
        return 30;
    }

    @Override
    public Option<Boolean> getOption() {
        return this.option;
    }

    private static class TickBoxControlElement
    extends ControlElement<Boolean> {
        private final class_768 button;

        public TickBoxControlElement(Option<Boolean> option, Dim2i dim) {
            super(option, dim);
            this.button = new class_768(dim.getLimitX() - 16, dim.getCenterY() - 5, 10, 10);
        }

        @Override
        public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
            boolean ticked;
            super.method_25394(drawContext, mouseX, mouseY, delta);
            int x = this.button.method_3321();
            int y = this.button.method_3322();
            int w = x + this.button.method_3319();
            int h = y + this.button.method_3320();
            boolean enabled = this.option.isAvailable();
            boolean bl = ticked = enabled && (Boolean)this.option.getValue() != false;
            int color = enabled ? (ticked ? -7019309 : -1) : -5592406;
            if (ticked) {
                this.drawRect(x + 2, y + 2, w - 2, h - 2, color);
            }
            this.drawRectOutline(x, y, w, h, color);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.option.isAvailable() && button == 0 && this.dim.containsCursor(mouseX, mouseY)) {
                this.toggleControl();
                this.playClickSound();
                return true;
            }
            return false;
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (!this.method_25370()) {
                return false;
            }
            if (keyCode == 257) {
                this.toggleControl();
                this.playClickSound();
                return true;
            }
            return false;
        }

        public void toggleControl() {
            this.option.setValue((Boolean)this.option.getValue() == false);
        }

        protected void drawRectOutline(int x, int y, int w, int h, int color) {
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            this.drawQuads(vertices -> {
                TickBoxControlElement.addQuad(vertices, x, y, w, y + 1, a, r, g, b);
                TickBoxControlElement.addQuad(vertices, x, h - 1, w, h, a, r, g, b);
                TickBoxControlElement.addQuad(vertices, x, y, x + 1, h, a, r, g, b);
                TickBoxControlElement.addQuad(vertices, w - 1, y, w, h, a, r, g, b);
            });
        }
    }
}

