/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll;

import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3540;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import nl.enjarai.doabarrelroll.DoABarrelRoll;
import nl.enjarai.doabarrelroll.api.RollEntity;
import nl.enjarai.doabarrelroll.api.RollMouse;
import nl.enjarai.doabarrelroll.api.event.RollEvents;
import nl.enjarai.doabarrelroll.api.event.RollGroup;
import nl.enjarai.doabarrelroll.config.ActivationBehaviour;
import nl.enjarai.doabarrelroll.config.ModConfig;
import nl.enjarai.doabarrelroll.config.SyncedModConfig;
import nl.enjarai.doabarrelroll.flight.RotationModifiers;
import nl.enjarai.doabarrelroll.net.HandshakeClient;
import nl.enjarai.doabarrelroll.render.HorizonLineWidget;
import nl.enjarai.doabarrelroll.render.MomentumCrosshairWidget;
import nl.enjarai.doabarrelroll.util.MixinHooks;
import org.joml.Vector2d;
import org.joml.Vector2dc;

public class DoABarrelRollClient {
    public static final HandshakeClient<SyncedModConfig> HANDSHAKE_CLIENT = new HandshakeClient<SyncedModConfig>(SyncedModConfig.TRANSFER_CODEC, ModConfig.INSTANCE::notifyPlayerOfServerConfig);
    public static final class_3540 PITCH_SMOOTHER = new class_3540();
    public static final class_3540 YAW_SMOOTHER = new class_3540();
    public static final class_3540 ROLL_SMOOTHER = new class_3540();
    public static final RollGroup FALL_FLYING_GROUP = RollGroup.of(DoABarrelRoll.id("fall_flying"));
    public static double throttle = 0.0;

    public static void init() {
        FALL_FLYING_GROUP.trueIf(DoABarrelRollClient::isFallFlying);
        RollEvents.EARLY_CAMERA_MODIFIERS.register(context -> context.useModifier(RotationModifiers::manageThrottle, ModConfig.INSTANCE::getEnableThrust).useModifier(RotationModifiers.buttonControls(1800.0)), 2000, FALL_FLYING_GROUP);
        RollEvents.EARLY_CAMERA_MODIFIERS.register(context -> context.useModifier(ModConfig.INSTANCE::configureRotation), 1000, FALL_FLYING_GROUP);
        RollEvents.LATE_CAMERA_MODIFIERS.register(context -> context.useModifier(RotationModifiers.smoothing(PITCH_SMOOTHER, YAW_SMOOTHER, ROLL_SMOOTHER, ModConfig.INSTANCE.getSmoothing()), ModConfig.INSTANCE::getSmoothingEnabled).useModifier(RotationModifiers::banking, ModConfig.INSTANCE::getEnableBanking), 1000, FALL_FLYING_GROUP);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (!DoABarrelRollClient.isFallFlying()) {
                DoABarrelRollClient.clearValues();
            }
        });
    }

    public static void onRenderCrosshair(class_332 context, float tickDelta, int scaledWidth, int scaledHeight) {
        if (!DoABarrelRollClient.isFallFlying()) {
            return;
        }
        class_4587 matrices = context.method_51448();
        class_1297 entity = class_310.method_1551().method_1560();
        RollEntity rollEntity = (RollEntity)entity;
        if (entity != null) {
            if (ModConfig.INSTANCE.getShowHorizon()) {
                HorizonLineWidget.render(matrices, scaledWidth, scaledHeight, rollEntity.doABarrelRoll$getRoll(tickDelta), entity.method_5695(tickDelta));
            }
            if (ModConfig.INSTANCE.getMomentumBasedMouse() && ModConfig.INSTANCE.getShowMomentumWidget()) {
                RollMouse rollMouse = (RollMouse)class_310.method_1551().field_1729;
                MomentumCrosshairWidget.render(matrices, scaledWidth, scaledHeight, new Vector2d((Vector2dc)rollMouse.doABarrelRoll$getMouseTurnVec()));
            }
        }
    }

    private static void clearValues() {
        PITCH_SMOOTHER.method_15428();
        YAW_SMOOTHER.method_15428();
        ROLL_SMOOTHER.method_15428();
        throttle = 0.0;
    }

    public static boolean isFallFlying() {
        class_746 player;
        if (!HANDSHAKE_CLIENT.getConfig().map(SyncedModConfig::forceEnabled).orElse(false).booleanValue()) {
            boolean hybrid;
            boolean bl = hybrid = ModConfig.INSTANCE.getActivationBehaviour() == ActivationBehaviour.HYBRID || ModConfig.INSTANCE.getActivationBehaviour() == ActivationBehaviour.HYBRID_TOGGLE;
            if (hybrid && !MixinHooks.thirdJump) {
                return false;
            }
            if (!ModConfig.INSTANCE.getModEnabled()) {
                return false;
            }
        }
        return (player = class_310.method_1551().field_1724) != null && player.method_6128();
    }
}

