/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.compat.controlify;

import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.api.bind.BindingSupplier;
import dev.isxander.controlify.api.bind.ControlifyBindingsApi;
import dev.isxander.controlify.api.entrypoint.ControlifyEntrypoint;
import dev.isxander.controlify.bindings.GamepadBinds;
import dev.isxander.controlify.controller.Controller;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import nl.enjarai.doabarrelroll.DoABarrelRoll;
import nl.enjarai.doabarrelroll.DoABarrelRollClient;
import nl.enjarai.doabarrelroll.api.event.RollContext;
import nl.enjarai.doabarrelroll.api.event.RollEvents;
import nl.enjarai.doabarrelroll.api.event.ThrustEvents;
import nl.enjarai.doabarrelroll.api.rotation.RotationInstant;
import nl.enjarai.doabarrelroll.config.ModConfig;
import nl.enjarai.doabarrelroll.config.Sensitivity;

public class ControlifyCompat
implements ControlifyEntrypoint {
    public static BindingSupplier PITCH_UP;
    public static BindingSupplier PITCH_DOWN;
    public static BindingSupplier ROLL_LEFT;
    public static BindingSupplier ROLL_RIGHT;
    public static BindingSupplier YAW_LEFT;
    public static BindingSupplier YAW_RIGHT;
    public static BindingSupplier THRUST_FORWARD;
    public static BindingSupplier THRUST_BACKWARD;

    private RotationInstant applyToRotation(RotationInstant rotationDelta, RollContext context) {
        Controller controller = ControlifyApi.get().currentController();
        Sensitivity sensitivity = ModConfig.INSTANCE.getControllerSensitivity();
        if (PITCH_UP.onController(controller) == null) {
            return rotationDelta;
        }
        double multiplier = context.getRenderDelta() * 1200.0;
        float pitchAxis = PITCH_DOWN.onController(controller).state() - PITCH_UP.onController(controller).state();
        float yawAxis = YAW_RIGHT.onController(controller).state() - YAW_LEFT.onController(controller).state();
        float rollAxis = ROLL_RIGHT.onController(controller).state() - ROLL_LEFT.onController(controller).state();
        pitchAxis = (float)((double)pitchAxis * (multiplier * sensitivity.pitch));
        yawAxis = (float)((double)yawAxis * (multiplier * sensitivity.yaw));
        rollAxis = (float)((double)rollAxis * (multiplier * sensitivity.roll));
        return rotationDelta.add(pitchAxis, yawAxis, rollAxis);
    }

    public static double getThrustModifier() {
        if (ControlifyApi.get().getCurrentController().isEmpty()) {
            return 0.0;
        }
        Controller controller = (Controller)ControlifyApi.get().getCurrentController().get();
        float forward = THRUST_FORWARD.onController(controller).state();
        float backward = THRUST_BACKWARD.onController(controller).state();
        return forward - backward;
    }

    public static RotationInstant manageThrottle(RotationInstant rotationInstant, RollContext context) {
        double delta = context.getRenderDelta();
        DoABarrelRollClient.throttle += ControlifyCompat.getThrustModifier() * delta;
        DoABarrelRollClient.throttle = class_3532.method_15350((double)DoABarrelRollClient.throttle, (double)0.0, (double)ModConfig.INSTANCE.getMaxThrust());
        return rotationInstant;
    }

    public void onControlifyPreInit(ControlifyApi controlifyApi) {
        ControlifyBindingsApi bindings = ControlifyBindingsApi.get();
        PITCH_UP = bindings.registerBind(DoABarrelRoll.id("pitch_up"), builder -> builder.defaultBind(GamepadBinds.RIGHT_STICK_FORWARD).category((class_2561)class_2561.method_43471((String)"controlify.category.do_a_barrel_roll.do_a_barrel_roll")).name((class_2561)class_2561.method_43471((String)"controlify.bind.do_a_barrel_roll.pitch_up")));
        PITCH_DOWN = bindings.registerBind(DoABarrelRoll.id("pitch_down"), builder -> builder.defaultBind(GamepadBinds.RIGHT_STICK_BACKWARD).category((class_2561)class_2561.method_43471((String)"controlify.category.do_a_barrel_roll.do_a_barrel_roll")).name((class_2561)class_2561.method_43471((String)"controlify.bind.do_a_barrel_roll.pitch_down")));
        ROLL_LEFT = bindings.registerBind(DoABarrelRoll.id("roll_left"), builder -> builder.defaultBind(GamepadBinds.RIGHT_STICK_LEFT).category((class_2561)class_2561.method_43471((String)"controlify.category.do_a_barrel_roll.do_a_barrel_roll")).name((class_2561)class_2561.method_43471((String)"controlify.bind.do_a_barrel_roll.roll_left")));
        ROLL_RIGHT = bindings.registerBind(DoABarrelRoll.id("roll_right"), builder -> builder.defaultBind(GamepadBinds.RIGHT_STICK_RIGHT).category((class_2561)class_2561.method_43471((String)"controlify.category.do_a_barrel_roll.do_a_barrel_roll")).name((class_2561)class_2561.method_43471((String)"controlify.bind.do_a_barrel_roll.roll_right")));
        YAW_LEFT = bindings.registerBind(DoABarrelRoll.id("yaw_left"), builder -> builder.defaultBind(GamepadBinds.LEFT_STICK_LEFT).category((class_2561)class_2561.method_43471((String)"controlify.category.do_a_barrel_roll.do_a_barrel_roll")).name((class_2561)class_2561.method_43471((String)"controlify.bind.do_a_barrel_roll.yaw_left")));
        YAW_RIGHT = bindings.registerBind(DoABarrelRoll.id("yaw_right"), builder -> builder.defaultBind(GamepadBinds.LEFT_STICK_RIGHT).category((class_2561)class_2561.method_43471((String)"controlify.category.do_a_barrel_roll.do_a_barrel_roll")).name((class_2561)class_2561.method_43471((String)"controlify.bind.do_a_barrel_roll.yaw_right")));
        THRUST_FORWARD = bindings.registerBind(DoABarrelRoll.id("thrust_forward"), builder -> builder.defaultBind(GamepadBinds.LEFT_STICK_FORWARD).category((class_2561)class_2561.method_43471((String)"controlify.category.do_a_barrel_roll.do_a_barrel_roll")).name((class_2561)class_2561.method_43471((String)"controlify.bind.do_a_barrel_roll.thrust_forward")));
        THRUST_BACKWARD = bindings.registerBind(DoABarrelRoll.id("thrust_backward"), builder -> builder.defaultBind(GamepadBinds.LEFT_STICK_BACKWARD).category((class_2561)class_2561.method_43471((String)"controlify.category.do_a_barrel_roll.do_a_barrel_roll")).name((class_2561)class_2561.method_43471((String)"controlify.bind.do_a_barrel_roll.thrust_backward")));
        RollEvents.EARLY_CAMERA_MODIFIERS.register(context -> context.useModifier(ControlifyCompat::manageThrottle, ModConfig.INSTANCE::getEnableThrust), 8, DoABarrelRollClient::isFallFlying);
        RollEvents.LATE_CAMERA_MODIFIERS.register(context -> context.useModifier(this::applyToRotation), 5, DoABarrelRollClient::isFallFlying);
        ThrustEvents.MODIFY_THRUST_INPUT.register(input -> input + ControlifyCompat.getThrustModifier());
    }

    public void onControllersDiscovered(ControlifyApi controlifyApi) {
    }
}

