/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;
import nl.enjarai.doabarrelroll.DoABarrelRollClient;
import nl.enjarai.doabarrelroll.api.event.RollContext;
import nl.enjarai.doabarrelroll.api.rotation.RotationInstant;
import nl.enjarai.doabarrelroll.config.ActivationBehaviour;
import nl.enjarai.doabarrelroll.config.Sensitivity;
import nl.enjarai.doabarrelroll.config.SyncedModConfig;

public class ModConfig {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Path CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("do_a_barrel_roll-client.json");
    public static ModConfig INSTANCE = ModConfig.loadConfigFile(CONFIG_FILE.toFile());
    General general = new General();
    SensitivityConfig sensitivity = new SensitivityConfig();

    public static void touch() {
    }

    public boolean getModEnabled() {
        return this.general.mod_enabled;
    }

    public boolean getSwitchRollAndYaw() {
        return this.general.controls.switch_roll_and_yaw;
    }

    public boolean getMomentumBasedMouse() {
        return this.general.controls.momentum_based_mouse;
    }

    public double getMomentumMouseDeadzone() {
        return this.general.controls.momentum_mouse_deadzone;
    }

    public boolean getShowMomentumWidget() {
        return this.general.controls.show_momentum_widget;
    }

    public boolean getInvertPitch() {
        return this.general.controls.invert_pitch;
    }

    public ActivationBehaviour getActivationBehaviour() {
        return this.general.controls.activation_behaviour;
    }

    public boolean getShowHorizon() {
        return this.general.hud.show_horizon;
    }

    public boolean getEnableBanking() {
        return this.general.banking.enable_banking;
    }

    public double getBankingStrength() {
        return this.general.banking.banking_strength;
    }

    public boolean getEnableThrust() {
        return this.general.thrust.enable_thrust && DoABarrelRollClient.HANDSHAKE_CLIENT.getConfig().map(SyncedModConfig::allowThrusting).orElse(false) != false;
    }

    public boolean getEnableThrustClient() {
        return this.general.thrust.enable_thrust;
    }

    public double getMaxThrust() {
        return this.general.thrust.max_thrust;
    }

    public double getThrustAcceleration() {
        return this.general.thrust.thrust_acceleration;
    }

    public boolean getThrustParticles() {
        return this.general.thrust.thrust_particles;
    }

    public boolean getSmoothingEnabled() {
        return this.sensitivity.smoothing.smoothing_enabled;
    }

    public double getSmoothingPitch() {
        return this.sensitivity.smoothing.smoothing_pitch;
    }

    public double getSmoothingYaw() {
        return this.sensitivity.smoothing.smoothing_yaw;
    }

    public double getSmoothingRoll() {
        return this.sensitivity.smoothing.smoothing_roll;
    }

    public Sensitivity getSmoothing() {
        return new Sensitivity(this.sensitivity.smoothing.smoothing_pitch, this.sensitivity.smoothing.smoothing_yaw, this.sensitivity.smoothing.smoothing_roll);
    }

    public Sensitivity getDesktopSensitivity() {
        return this.sensitivity.desktop;
    }

    public double getDesktopPitch() {
        return this.sensitivity.desktop.pitch;
    }

    public double getDesktopYaw() {
        return this.sensitivity.desktop.yaw;
    }

    public double getDesktopRoll() {
        return this.sensitivity.desktop.roll;
    }

    public Sensitivity getControllerSensitivity() {
        return this.sensitivity.controller;
    }

    public double getControllerPitch() {
        return this.sensitivity.controller.pitch;
    }

    public double getControllerYaw() {
        return this.sensitivity.controller.yaw;
    }

    public double getControllerRoll() {
        return this.sensitivity.controller.roll;
    }

    public void setModEnabled(boolean enabled) {
        this.general.mod_enabled = enabled;
    }

    public void setSwitchRollAndYaw(boolean enabled) {
        this.general.controls.switch_roll_and_yaw = enabled;
    }

    public void setMomentumBasedMouse(boolean enabled) {
        this.general.controls.momentum_based_mouse = enabled;
    }

    public void setMomentumMouseDeadzone(double deadzone) {
        this.general.controls.momentum_mouse_deadzone = deadzone;
    }

    public void setShowMomentumWidget(boolean enabled) {
        this.general.controls.show_momentum_widget = enabled;
    }

    public void setInvertPitch(boolean enabled) {
        this.general.controls.invert_pitch = enabled;
    }

    public void setActivationBehaviour(ActivationBehaviour behaviour) {
        this.general.controls.activation_behaviour = behaviour;
    }

    public void setShowHorizon(boolean enabled) {
        this.general.hud.show_horizon = enabled;
    }

    public void setEnableBanking(boolean enabled) {
        this.general.banking.enable_banking = enabled;
    }

    public void setBankingStrength(double strength) {
        this.general.banking.banking_strength = strength;
    }

    public void setEnableThrust(boolean enabled) {
        this.general.thrust.enable_thrust = enabled;
    }

    public void setMaxThrust(double thrust) {
        this.general.thrust.max_thrust = thrust;
    }

    public void setThrustAcceleration(double acceleration) {
        this.general.thrust.thrust_acceleration = acceleration;
    }

    public void setThrustParticles(boolean enabled) {
        this.general.thrust.thrust_particles = enabled;
    }

    public void setSmoothingEnabled(boolean enabled) {
        this.sensitivity.smoothing.smoothing_enabled = enabled;
    }

    public void setSmoothingPitch(double pitch) {
        this.sensitivity.smoothing.smoothing_pitch = pitch;
    }

    public void setSmoothingYaw(double yaw) {
        this.sensitivity.smoothing.smoothing_yaw = yaw;
    }

    public void setSmoothingRoll(double roll) {
        this.sensitivity.smoothing.smoothing_roll = roll;
    }

    public void setDesktopSensitivity(Sensitivity sensitivity) {
        this.sensitivity.desktop = sensitivity;
    }

    public void setDesktopPitch(double pitch) {
        this.sensitivity.desktop.pitch = pitch;
    }

    public void setDesktopYaw(double yaw) {
        this.sensitivity.desktop.yaw = yaw;
    }

    public void setDesktopRoll(double roll) {
        this.sensitivity.desktop.roll = roll;
    }

    public void setControllerSensitivity(Sensitivity sensitivity) {
        this.sensitivity.controller = sensitivity;
    }

    public void setControllerPitch(double pitch) {
        this.sensitivity.controller.pitch = pitch;
    }

    public void setControllerYaw(double yaw) {
        this.sensitivity.controller.yaw = yaw;
    }

    public void setControllerRoll(double roll) {
        this.sensitivity.controller.roll = roll;
    }

    public void save() {
        this.saveConfigFile(CONFIG_FILE.toFile());
    }

    public RotationInstant configureRotation(RotationInstant rotationInstant, RollContext context) {
        double pitch = rotationInstant.pitch();
        double yaw = rotationInstant.yaw();
        double roll = rotationInstant.roll();
        if (!this.getSwitchRollAndYaw()) {
            double temp = yaw;
            yaw = roll;
            roll = temp;
        }
        if (this.getInvertPitch()) {
            pitch = -pitch;
        }
        return RotationInstant.of(pitch, yaw, roll);
    }

    public void notifyPlayerOfServerConfig(SyncedModConfig serverConfig) {
        if (!serverConfig.allowThrusting() && this.general.thrust.enable_thrust) {
            class_310.method_1551().method_1566().method_1999((class_368)class_370.method_29047((class_310)class_310.method_1551(), (class_370.class_371)class_370.class_371.field_2218, (class_2561)class_2561.method_43471((String)"toast.do_a_barrel_roll"), (class_2561)class_2561.method_43471((String)"toast.do_a_barrel_roll.thrusting_disabled_by_server")));
        }
        if (serverConfig.forceEnabled() && !this.general.mod_enabled) {
            class_310.method_1551().method_1566().method_1999((class_368)class_370.method_29047((class_310)class_310.method_1551(), (class_370.class_371)class_370.class_371.field_2218, (class_2561)class_2561.method_43471((String)"toast.do_a_barrel_roll"), (class_2561)class_2561.method_43471((String)"toast.do_a_barrel_roll.mod_forced_enabled_by_server")));
        }
    }

    private static ModConfig loadConfigFile(File file) {
        ModConfig config = null;
        if (file.exists()) {
            try (BufferedReader fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
                config = (ModConfig)GSON.fromJson((Reader)fileReader, ModConfig.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Problem occurred when trying to load config: ", e);
            }
        }
        if (config == null) {
            config = new ModConfig();
        }
        config.saveConfigFile(file);
        return config;
    }

    private void saveConfigFile(File file) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static class General {
        boolean mod_enabled = true;
        Controls controls = new Controls();
        Hud hud = new Hud();
        Banking banking = new Banking();
        Thrust thrust = new Thrust();

        General() {
        }

        static class Controls {
            boolean switch_roll_and_yaw = false;
            boolean invert_pitch = false;
            boolean momentum_based_mouse = false;
            double momentum_mouse_deadzone = 0.2;
            boolean show_momentum_widget = true;
            ActivationBehaviour activation_behaviour = ActivationBehaviour.VANILLA;

            Controls() {
            }
        }

        static class Hud {
            boolean show_horizon = false;

            Hud() {
            }
        }

        static class Banking {
            boolean enable_banking = true;
            double banking_strength = 20.0;

            Banking() {
            }
        }

        static class Thrust {
            boolean enable_thrust = false;
            double max_thrust = 2.0;
            double thrust_acceleration = 0.1;
            boolean thrust_particles = true;

            Thrust() {
            }
        }
    }

    static class SensitivityConfig {
        Smoothing smoothing = new Smoothing();
        Sensitivity desktop = new Sensitivity();
        Sensitivity controller = new Sensitivity();

        SensitivityConfig() {
        }

        static class Smoothing {
            boolean smoothing_enabled = true;
            double smoothing_pitch = 1.0;
            double smoothing_yaw = 0.4;
            double smoothing_roll = 1.0;

            Smoothing() {
            }
        }
    }
}

