/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.net;

import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import nl.enjarai.doabarrelroll.DoABarrelRoll;
import nl.enjarai.doabarrelroll.net.SyncableConfig;
import nl.enjarai.doabarrelroll.util.DelayedRunnable;
import org.slf4j.Logger;

public class HandshakeServer<T extends SyncableConfig<T>> {
    private final Supplier<T> configSupplier;
    private final Map<class_3222, HandshakeState> syncStates = new WeakHashMap<class_3222, HandshakeState>();
    private final ArrayList<DelayedRunnable> scheduledTasks = new ArrayList();

    public HandshakeServer(Supplier<T> configSupplier) {
        this.configSupplier = configSupplier;
    }

    public void tick(MinecraftServer server) {
        this.scheduledTasks.removeIf(DelayedRunnable::isDone);
        this.scheduledTasks.forEach(DelayedRunnable::tick);
    }

    public HandshakeState getHandshakeState(class_3222 player) {
        return this.syncStates.getOrDefault(player, HandshakeState.NOT_SENT);
    }

    public class_2540 getConfigSyncBuf(class_3222 player) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(1);
        SyncableConfig config = (SyncableConfig)this.configSupplier.get();
        DataResult data = config.getTransferCodec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)config);
        try {
            buf.method_10814(((JsonElement)data.getOrThrow(false, arg_0 -> ((Logger)DoABarrelRoll.LOGGER).error(arg_0))).toString());
        }
        catch (RuntimeException e) {
            DoABarrelRoll.LOGGER.error("Failed to encode config", (Throwable)e);
            buf.method_10814("{}");
        }
        return buf;
    }

    public void configSentToClient(class_3222 player) {
        this.syncStates.put(player, HandshakeState.SENT);
        SyncableConfig config = (SyncableConfig)this.configSupplier.get();
        if (config.getSyncTimeout() != null) {
            this.scheduledTasks.add(new DelayedRunnable(config.getSyncTimeout(), () -> {
                if (this.syncStates.getOrDefault(player, HandshakeState.NOT_SENT) != HandshakeState.ACCEPTED) {
                    DoABarrelRoll.LOGGER.warn("{} did not accept config syncing, config indicates we kick them.", (Object)player.method_5477().getString());
                    player.field_13987.method_14367(config.getSyncTimeoutMessage());
                }
            }));
        }
    }

    public HandshakeState clientReplied(class_3222 player, class_2540 buf) {
        HandshakeState state = this.getHandshakeState(player);
        if (state == HandshakeState.SENT) {
            int protocolVersion = buf.readInt();
            if (protocolVersion != 1) {
                this.syncStates.put(player, HandshakeState.FAILED);
                DoABarrelRoll.LOGGER.warn("Client of {} sent unknown protocol version, expected 1, got {}. Will attempt to proceed anyway.", (Object)player.method_5477().getString(), (Object)protocolVersion);
            }
            try {
                if (buf.readBoolean()) {
                    this.syncStates.put(player, HandshakeState.ACCEPTED);
                    DoABarrelRoll.LOGGER.info("Client of {} accepted server config.", (Object)player.method_5477().getString());
                    return HandshakeState.ACCEPTED;
                }
                this.syncStates.put(player, HandshakeState.FAILED);
                DoABarrelRoll.LOGGER.warn("Client of {} failed to process server config, check client logs find what went wrong.", (Object)player.method_5477().getString());
                return HandshakeState.FAILED;
            }
            catch (IndexOutOfBoundsException e) {
                this.syncStates.put(player, HandshakeState.FAILED);
                DoABarrelRoll.LOGGER.warn("Client of {} sent invalid config reply.", (Object)player.method_5477().getString());
                return HandshakeState.FAILED;
            }
        }
        return state;
    }

    public void playerDisconnected(class_3222 player) {
        this.syncStates.remove(player);
    }

    public static enum HandshakeState {
        NOT_SENT,
        SENT,
        ACCEPTED,
        FAILED;

    }
}

