/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.render;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.IEntityOwnedInventory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1258;
import net.minecraft.class_1263;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_1723;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2248;
import net.minecraft.class_2260;
import net.minecraft.class_2281;
import net.minecraft.class_2315;
import net.minecraft.class_2363;
import net.minecraft.class_2371;
import net.minecraft.class_2377;
import net.minecraft.class_2480;
import net.minecraft.class_2561;
import net.minecraft.class_2589;
import net.minecraft.class_2601;
import net.minecraft.class_2609;
import net.minecraft.class_2614;
import net.minecraft.class_2627;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4836;
import net.minecraft.class_757;
import net.minecraft.class_8886;
import net.minecraft.class_8887;
import net.minecraft.class_9801;

public class InventoryOverlay {
    public static final class_2960 TEXTURE_BREWING_STAND = class_2960.method_60656((String)"textures/gui/container/brewing_stand.png");
    public static final class_2960 TEXTURE_CRAFTER = class_2960.method_60656((String)"textures/gui/container/crafter.png");
    public static final class_2960 TEXTURE_DISPENSER = class_2960.method_60656((String)"textures/gui/container/dispenser.png");
    public static final class_2960 TEXTURE_DOUBLE_CHEST = class_2960.method_60656((String)"textures/gui/container/generic_54.png");
    public static final class_2960 TEXTURE_FURNACE = class_2960.method_60656((String)"textures/gui/container/furnace.png");
    public static final class_2960 TEXTURE_HOPPER = class_2960.method_60656((String)"textures/gui/container/hopper.png");
    public static final class_2960 TEXTURE_PLAYER_INV = class_2960.method_60656((String)"textures/gui/container/hopper.png");
    public static final class_2960 TEXTURE_SINGLE_CHEST = class_2960.method_60656((String)"textures/gui/container/shulker_box.png");
    private static final class_1304[] VALID_EQUIPMENT_SLOTS = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166};
    public static final InventoryProperties INV_PROPS_TEMP = new InventoryProperties();
    private static final class_2960[] EMPTY_SLOT_TEXTURES = new class_2960[]{class_2960.method_60656((String)"item/empty_armor_slot_boots"), class_2960.method_60656((String)"item/empty_armor_slot_leggings"), class_2960.method_60656((String)"item/empty_armor_slot_chestplate"), class_2960.method_60656((String)"item/empty_armor_slot_helmet")};
    private static class_1799 hoveredStack = null;

    public static void renderInventoryBackground(InventoryRenderType type, int x, int y, int slotsPerRow, int totalSlots, class_310 mc) {
        RenderUtils.setupBlend();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.applyModelViewMatrix();
        if (type == InventoryRenderType.FURNACE) {
            RenderUtils.bindTexture(TEXTURE_FURNACE);
            RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 4, 64, buffer);
            RenderUtils.drawTexturedRectBatched(x + 4, y, 84, 0, 92, 4, buffer);
            RenderUtils.drawTexturedRectBatched(x, y + 64, 0, 162, 92, 4, buffer);
            RenderUtils.drawTexturedRectBatched(x + 92, y + 4, 172, 102, 4, 64, buffer);
            RenderUtils.drawTexturedRectBatched(x + 4, y + 4, 52, 13, 88, 60, buffer);
        } else if (type == InventoryRenderType.BREWING_STAND) {
            RenderUtils.bindTexture(TEXTURE_BREWING_STAND);
            RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 4, 68, buffer);
            RenderUtils.drawTexturedRectBatched(x + 4, y, 63, 0, 113, 4, buffer);
            RenderUtils.drawTexturedRectBatched(x, y + 68, 0, 162, 113, 4, buffer);
            RenderUtils.drawTexturedRectBatched(x + 113, y + 4, 172, 98, 4, 68, buffer);
            RenderUtils.drawTexturedRectBatched(x + 4, y + 4, 13, 13, 109, 64, buffer);
        } else if (type == InventoryRenderType.CRAFTER) {
            RenderUtils.bindTexture(TEXTURE_DISPENSER);
            RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 7, 61, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y, 115, 0, 61, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x, y + 61, 0, 159, 61, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x + 61, y + 7, 169, 105, 7, 61, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y + 7, 61, 16, 54, 54, buffer);
        } else if (type == InventoryRenderType.DISPENSER) {
            RenderUtils.bindTexture(TEXTURE_DISPENSER);
            RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 7, 61, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y, 115, 0, 61, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x, y + 61, 0, 159, 61, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x + 61, y + 7, 169, 105, 7, 61, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y + 7, 61, 16, 54, 54, buffer);
        } else if (type == InventoryRenderType.HOPPER) {
            RenderUtils.bindTexture(TEXTURE_HOPPER);
            RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 7, 25, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y, 79, 0, 97, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x, y + 25, 0, 126, 97, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x + 97, y + 7, 169, 108, 7, 25, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y + 7, 43, 19, 90, 18, buffer);
        } else if (type == InventoryRenderType.VILLAGER) {
            RenderUtils.bindTexture(TEXTURE_DOUBLE_CHEST);
            RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 7, 79, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y, 133, 0, 43, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x, y + 79, 0, 215, 43, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x + 43, y + 7, 169, 143, 7, 79, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y + 7, 7, 17, 36, 72, buffer);
        } else if (type == InventoryRenderType.FIXED_27) {
            InventoryOverlay.renderInventoryBackground27(x, y, buffer, mc);
        } else if (type == InventoryRenderType.FIXED_54) {
            InventoryOverlay.renderInventoryBackground54(x, y, buffer, mc);
        } else {
            RenderUtils.bindTexture(TEXTURE_DOUBLE_CHEST);
            int rows = (int)Math.ceil((double)totalSlots / (double)slotsPerRow);
            int bgw = Math.min(totalSlots, slotsPerRow) * 18 + 7;
            int bgh = rows * 18 + 7;
            RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 7, bgh, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y, 176 - bgw, 0, bgw, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x, y + bgh, 0, 215, bgw, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x + bgw, y + 7, 169, 222 - bgh, 7, bgh, buffer);
            for (int row = 0; row < rows; ++row) {
                int rowLen = class_3532.method_15340((int)(totalSlots - row * slotsPerRow), (int)1, (int)slotsPerRow);
                RenderUtils.drawTexturedRectBatched(x + 7, y + row * 18 + 7, 7, 17, rowLen * 18, 18, buffer);
                if (rows <= 1 || rowLen >= slotsPerRow) continue;
                RenderUtils.drawTexturedRectBatched(x + rowLen * 18 + 7, y + row * 18 + 7, 7, 3, (slotsPerRow - rowLen) * 18, 9, buffer);
                RenderUtils.drawTexturedRectBatched(x + rowLen * 18 + 7, y + row * 18 + 16, 7, 3, (slotsPerRow - rowLen) * 18, 9, buffer);
            }
        }
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        try {
            class_9801 builtBuffer = buffer.method_60800();
            class_286.method_43433((class_9801)builtBuffer);
            builtBuffer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void renderInventoryBackground27(int x, int y, class_287 buffer, class_310 mc) {
        RenderUtils.bindTexture(TEXTURE_SINGLE_CHEST);
        RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 7, 61, buffer);
        RenderUtils.drawTexturedRectBatched(x + 7, y, 7, 0, 169, 7, buffer);
        RenderUtils.drawTexturedRectBatched(x, y + 61, 0, 159, 169, 7, buffer);
        RenderUtils.drawTexturedRectBatched(x + 169, y + 7, 169, 105, 7, 61, buffer);
        RenderUtils.drawTexturedRectBatched(x + 7, y + 7, 7, 17, 162, 54, buffer);
    }

    public static void renderInventoryBackground54(int x, int y, class_287 buffer, class_310 mc) {
        RenderUtils.bindTexture(TEXTURE_DOUBLE_CHEST);
        RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 7, 115, buffer);
        RenderUtils.drawTexturedRectBatched(x + 7, y, 7, 0, 169, 7, buffer);
        RenderUtils.drawTexturedRectBatched(x, y + 115, 0, 215, 169, 7, buffer);
        RenderUtils.drawTexturedRectBatched(x + 169, y + 7, 169, 107, 7, 115, buffer);
        RenderUtils.drawTexturedRectBatched(x + 7, y + 7, 7, 17, 162, 108, buffer);
    }

    public static void renderEquipmentOverlayBackground(int x, int y, class_1309 entity, class_332 drawContext) {
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.applyModelViewMatrix();
        RenderUtils.bindTexture(TEXTURE_DISPENSER);
        RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 50, 83, buffer);
        RenderUtils.drawTexturedRectBatched(x + 50, y, 173, 0, 3, 83, buffer);
        RenderUtils.drawTexturedRectBatched(x, y + 83, 0, 163, 50, 3, buffer);
        RenderUtils.drawTexturedRectBatched(x + 50, y + 83, 173, 163, 3, 3, buffer);
        int i22 = 0;
        int xOff = 7;
        int yOff = 7;
        while (i22 < 4) {
            RenderUtils.drawTexturedRectBatched(x + xOff, y + yOff, 61, 16, 18, 18, buffer);
            ++i22;
            yOff += 18;
        }
        RenderUtils.drawTexturedRectBatched(x + 28, y + 36 + 7, 61, 16, 18, 18, buffer);
        RenderUtils.drawTexturedRectBatched(x + 28, y + 54 + 7, 61, 16, 18, 18, buffer);
        try {
            class_9801 builtBuffer = buffer.method_60800();
            class_286.method_43433((class_9801)builtBuffer);
            builtBuffer.close();
        }
        catch (Exception i22) {
            // empty catch block
        }
        RenderUtils.bindTexture(class_1723.field_21668);
        if (entity.method_6118(class_1304.field_6171).method_7960()) {
            class_2960 texture = class_2960.method_60656((String)"item/empty_armor_slot_shield");
            RenderUtils.renderSprite(x + 28 + 1, y + 54 + 7 + 1, 16, 16, class_1723.field_21668, texture, drawContext);
        }
        int i = 0;
        xOff = 7;
        yOff = 7;
        while (i < 4) {
            class_1304 eqSlot = VALID_EQUIPMENT_SLOTS[i];
            if (entity.method_6118(eqSlot).method_7960()) {
                class_2960 texture = EMPTY_SLOT_TEXTURES[eqSlot.method_5927()];
                RenderUtils.renderSprite(x + xOff + 1, y + yOff + 1, 16, 16, class_1723.field_21668, texture, drawContext);
            }
            ++i;
            yOff += 18;
        }
    }

    public static InventoryRenderType getInventoryType(class_1263 inv) {
        if (inv instanceof class_2627) {
            return InventoryRenderType.FIXED_27;
        }
        if (inv instanceof class_1258) {
            return InventoryRenderType.FIXED_54;
        }
        if (inv instanceof class_2609) {
            return InventoryRenderType.FURNACE;
        }
        if (inv instanceof class_2589) {
            return InventoryRenderType.BREWING_STAND;
        }
        if (inv instanceof class_8887) {
            return InventoryRenderType.CRAFTER;
        }
        if (inv instanceof class_2601) {
            return InventoryRenderType.DISPENSER;
        }
        if (inv instanceof class_2614) {
            return InventoryRenderType.HOPPER;
        }
        if (inv instanceof IEntityOwnedInventory) {
            IEntityOwnedInventory inventory = (IEntityOwnedInventory)inv;
            if (inventory.malilib$getEntityOwner() instanceof class_1496) {
                return InventoryRenderType.HORSE;
            }
            if (inventory.malilib$getEntityOwner() instanceof class_4836) {
                return InventoryRenderType.VILLAGER;
            }
        }
        return InventoryRenderType.GENERIC;
    }

    public static InventoryRenderType getInventoryType(class_1799 stack) {
        class_1792 item = stack.method_7909();
        if (item instanceof class_1747) {
            class_2248 block = ((class_1747)item).method_7711();
            if (block instanceof class_2480 || block instanceof class_2281) {
                return InventoryRenderType.FIXED_27;
            }
            if (block instanceof class_2363) {
                return InventoryRenderType.FURNACE;
            }
            if (block instanceof class_2315) {
                return InventoryRenderType.DISPENSER;
            }
            if (block instanceof class_2377) {
                return InventoryRenderType.HOPPER;
            }
            if (block instanceof class_2260) {
                return InventoryRenderType.BREWING_STAND;
            }
            if (block instanceof class_8886) {
                return InventoryRenderType.CRAFTER;
            }
        }
        return InventoryRenderType.GENERIC;
    }

    public static InventoryProperties getInventoryPropsTemp(InventoryRenderType type, int totalSlots) {
        InventoryOverlay.INV_PROPS_TEMP.totalSlots = totalSlots;
        if (type == InventoryRenderType.FURNACE) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 1;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 0;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 0;
            InventoryOverlay.INV_PROPS_TEMP.width = 96;
            InventoryOverlay.INV_PROPS_TEMP.height = 68;
        } else if (type == InventoryRenderType.BREWING_STAND) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 9;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 0;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 0;
            InventoryOverlay.INV_PROPS_TEMP.width = 127;
            InventoryOverlay.INV_PROPS_TEMP.height = 72;
        } else if (type == InventoryRenderType.CRAFTER) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 3;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 68;
            InventoryOverlay.INV_PROPS_TEMP.height = 68;
        } else if (type == InventoryRenderType.DISPENSER) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 3;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 68;
            InventoryOverlay.INV_PROPS_TEMP.height = 68;
        } else if (type == InventoryRenderType.HORSE) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = Math.max(1, totalSlots / 3);
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = totalSlots * 18 / 3 + 14;
            InventoryOverlay.INV_PROPS_TEMP.height = 68;
        } else if (type == InventoryRenderType.HOPPER) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 5;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 105;
            InventoryOverlay.INV_PROPS_TEMP.height = 32;
        } else if (type == InventoryRenderType.VILLAGER) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 2;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 50;
            InventoryOverlay.INV_PROPS_TEMP.height = 86;
        } else {
            if (type == InventoryRenderType.FIXED_27) {
                totalSlots = 27;
            } else if (type == InventoryRenderType.FIXED_54) {
                totalSlots = 54;
            }
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 9;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            int rows = (int)Math.ceil((double)totalSlots / (double)InventoryOverlay.INV_PROPS_TEMP.slotsPerRow);
            InventoryOverlay.INV_PROPS_TEMP.width = Math.min(InventoryOverlay.INV_PROPS_TEMP.slotsPerRow, totalSlots) * 18 + 14;
            InventoryOverlay.INV_PROPS_TEMP.height = rows * 18 + 14;
        }
        return INV_PROPS_TEMP;
    }

    public static void renderInventoryStacks(InventoryRenderType type, class_1263 inv, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, class_310 mc, class_332 drawContext) {
        InventoryOverlay.renderInventoryStacks(type, inv, startX, startY, slotsPerRow, startSlot, maxSlots, mc, drawContext, 0.0, 0.0);
    }

    public static void renderInventoryStacks(InventoryRenderType type, class_1263 inv, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, class_310 mc, class_332 drawContext, double mouseX, double mouseY) {
        if (type == InventoryRenderType.FURNACE) {
            InventoryOverlay.renderStackAt(inv.method_5438(0), startX + 8, startY + 8, 1.0f, mc, drawContext, mouseX, mouseY);
            InventoryOverlay.renderStackAt(inv.method_5438(1), startX + 8, startY + 44, 1.0f, mc, drawContext, mouseX, mouseY);
            InventoryOverlay.renderStackAt(inv.method_5438(2), startX + 68, startY + 26, 1.0f, mc, drawContext, mouseX, mouseY);
        } else if (type == InventoryRenderType.BREWING_STAND) {
            InventoryOverlay.renderStackAt(inv.method_5438(0), startX + 47, startY + 42, 1.0f, mc, drawContext, mouseX, mouseY);
            InventoryOverlay.renderStackAt(inv.method_5438(1), startX + 70, startY + 49, 1.0f, mc, drawContext, mouseX, mouseY);
            InventoryOverlay.renderStackAt(inv.method_5438(2), startX + 93, startY + 42, 1.0f, mc, drawContext, mouseX, mouseY);
            InventoryOverlay.renderStackAt(inv.method_5438(3), startX + 70, startY + 8, 1.0f, mc, drawContext, mouseX, mouseY);
            InventoryOverlay.renderStackAt(inv.method_5438(4), startX + 8, startY + 8, 1.0f, mc, drawContext, mouseX, mouseY);
        } else {
            int slots = inv.method_5439();
            int x = startX;
            int y = startY;
            if (maxSlots < 0) {
                maxSlots = slots;
            }
            int slot = startSlot;
            int i = 0;
            while (slot < slots && i < maxSlots) {
                for (int column = 0; column < slotsPerRow && slot < slots && i < maxSlots; ++column, ++slot, ++i) {
                    class_1799 stack = inv.method_5438(slot);
                    if (!stack.method_7960()) {
                        InventoryOverlay.renderStackAt(stack, x, y, 1.0f, mc, drawContext, mouseX, mouseY);
                    }
                    x += 18;
                }
                x = startX;
                y += 18;
            }
        }
        if (hoveredStack != null) {
            class_1799 stack = hoveredStack;
            hoveredStack = null;
            drawContext.method_51446(mc.field_1772, stack, (int)mouseX, (int)mouseY);
        }
    }

    public static void renderEquipmentStacks(class_1309 entity, int x, int y, class_310 mc, class_332 drawContext) {
        InventoryOverlay.renderEquipmentStacks(entity, x, y, mc, drawContext, 0.0, 0.0);
    }

    public static void renderEquipmentStacks(class_1309 entity, int x, int y, class_310 mc, class_332 drawContext, double mouseX, double mouseY) {
        int i = 0;
        int xOff = 7;
        int yOff = 7;
        while (i < 4) {
            class_1304 eqSlot = VALID_EQUIPMENT_SLOTS[i];
            class_1799 stack = entity.method_6118(eqSlot);
            if (!stack.method_7960()) {
                InventoryOverlay.renderStackAt(stack, x + xOff + 1, y + yOff + 1, 1.0f, mc, drawContext, mouseX, mouseY);
            }
            ++i;
            yOff += 18;
        }
        class_1799 stack = entity.method_6118(class_1304.field_6173);
        if (!stack.method_7960()) {
            InventoryOverlay.renderStackAt(stack, x + 28, y + 36 + 7 + 1, 1.0f, mc, drawContext, mouseX, mouseY);
        }
        if (!(stack = entity.method_6118(class_1304.field_6171)).method_7960()) {
            InventoryOverlay.renderStackAt(stack, x + 28, y + 54 + 7 + 1, 1.0f, mc, drawContext, mouseX, mouseY);
        }
        if (hoveredStack != null) {
            stack = hoveredStack;
            hoveredStack = null;
            drawContext.method_51446(mc.field_1772, stack, (int)mouseX, (int)mouseY);
        }
    }

    public static void renderItemStacks(class_2371<class_1799> items, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, class_310 mc, class_332 drawContext) {
        int slots = items.size();
        int x = startX;
        int y = startY;
        if (maxSlots < 0) {
            maxSlots = slots;
        }
        int slot = startSlot;
        int i = 0;
        while (slot < slots && i < maxSlots) {
            for (int column = 0; column < slotsPerRow && slot < slots && i < maxSlots; ++column, ++slot, ++i) {
                class_1799 stack = (class_1799)items.get(slot);
                if (!stack.method_7960()) {
                    InventoryOverlay.renderStackAt(stack, x, y, 1.0f, mc, drawContext);
                }
                x += 18;
            }
            x = startX;
            y += 18;
        }
    }

    public static void renderStackAt(class_1799 stack, float x, float y, float scale, class_310 mc, class_332 drawContext) {
        InventoryOverlay.renderStackAt(stack, x, y, scale, mc, drawContext, 0.0, 0.0);
    }

    public static void renderStackAt(class_1799 stack, float x, float y, float scale, class_310 mc, class_332 drawContext, double mouseX, double mouseY) {
        class_4587 matrixStack = drawContext.method_51448();
        matrixStack.method_22903();
        matrixStack.method_46416(x, y, 0.0f);
        matrixStack.method_22905(scale, scale, 1.0f);
        RenderUtils.enableDiffuseLightingGui3D();
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        drawContext.method_51427(stack, 0, 0);
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        drawContext.method_51431(mc.field_1772, stack, 0, 0);
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.method_22909();
        if (mouseX >= (double)x && mouseX < (double)(x + 16.0f * scale) && mouseY >= (double)y && mouseY < (double)(y + 16.0f * scale)) {
            hoveredStack = stack;
        }
    }

    public static void renderStackToolTip(int x, int y, class_1799 stack, class_310 mc, class_332 drawContext) {
        List list = stack.method_7950(class_1792.class_9635.field_51353, (class_1657)mc.field_1724, (class_1836)(mc.field_1690.field_1827 ? class_1836.field_41071 : class_1836.field_41070));
        ArrayList<String> lines = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                lines.add(String.valueOf(stack.method_7932().method_58413()) + ((class_2561)list.get(i)).getString());
                continue;
            }
            lines.add(GuiBase.TXT_DARK_GRAY + ((class_2561)list.get(i)).getString());
        }
        RenderUtils.drawHoverText(x, y, lines, drawContext);
    }

    public static enum InventoryRenderType {
        BREWING_STAND,
        CRAFTER,
        DISPENSER,
        FURNACE,
        HOPPER,
        HORSE,
        FIXED_27,
        FIXED_54,
        VILLAGER,
        GENERIC;

    }

    public static class InventoryProperties {
        public int totalSlots = 1;
        public int width = 176;
        public int height = 83;
        public int slotsPerRow = 9;
        public int slotOffsetX = 8;
        public int slotOffsetY = 8;
    }
}

