/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.mcless.version;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.function.IntPredicate;
import mcp.mobius.waila.mcless.version.FlexVerComparator;

public class VersionRanges {
    private static final String OPERATORS = "<>=|&";
    private final Deque<Deque<Range>> or;

    public static VersionRanges parse(String spec) {
        if (spec.equals("*")) {
            return new VersionRanges(new ArrayDeque<Deque<Range>>());
        }
        ArrayDeque<Deque<Range>> or = new ArrayDeque<Deque<Range>>();
        or.push(new ArrayDeque());
        String[] split = spec.trim().split("\\s+");
        String lastOp = "";
        block25: for (String part : split) {
            StringBuilder opBuilder = new StringBuilder();
            for (char c : part.toCharArray()) {
                if (OPERATORS.indexOf(c) <= -1) break;
                opBuilder.append(c);
            }
            String op = opBuilder.toString();
            String version = part.substring(op.length());
            if (op.isEmpty()) {
                op = lastOp;
            }
            lastOp = "";
            if (version.isEmpty()) {
                switch (op) {
                    case "|": 
                    case "||": {
                        or.push(new ArrayDeque());
                        break;
                    }
                }
                lastOp = op;
                continue;
            }
            Deque<Range> and = Objects.requireNonNull(or.peek());
            switch (op) {
                case "<": {
                    and.push(new Range(version, v -> v < 0));
                    continue block25;
                }
                case "<=": {
                    and.push(new Range(version, v -> v <= 0));
                    continue block25;
                }
                case ">": {
                    and.push(new Range(version, v -> v > 0));
                    continue block25;
                }
                case ">=": {
                    and.push(new Range(version, v -> v >= 0));
                    continue block25;
                }
                case "=": 
                case "==": 
                case "": {
                    and.push(new Range(version, v -> v == 0));
                    continue block25;
                }
                default: {
                    throw new IllegalArgumentException("Unknown operator " + op);
                }
            }
        }
        if (!lastOp.isEmpty()) {
            throw new IllegalArgumentException("Dangling operator " + lastOp);
        }
        return new VersionRanges(or);
    }

    private VersionRanges(Deque<Deque<Range>> or) {
        this.or = or;
    }

    public boolean match(String version) {
        if (this.or.isEmpty()) {
            return true;
        }
        for (Deque<Range> and : this.or) {
            boolean res = true;
            for (Range range : and) {
                res = res && range.predicate.test(FlexVerComparator.compare(version, range.version));
            }
            if (!res) continue;
            return true;
        }
        return false;
    }

    record Range(String version, IntPredicate predicate) {
    }
}

