/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.Futures;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.component.PairComponent;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_6025;

public enum PetOwnerProvider implements IEntityComponentProvider,
IDataProvider<class_1297>
{
    INSTANCE;

    static final Supplier<HttpClient> HTTP;
    static final Map<UUID, Future<class_2561>> NAMES;
    static final class_2561 UNKNOWN;
    static final class_2561 LOADING;
    static final class_2561 KEY;

    @Override
    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (config.getBoolean(Options.PET_OWNER)) {
            UUID uuid;
            class_6025 entity = (class_6025)accessor.getEntity();
            class_2487 data = accessor.getData().raw();
            UUID uUID = uuid = data.method_25928("owner") ? data.method_25926("owner") : entity.method_6139();
            if (uuid == null) {
                return;
            }
            class_2561 name = LOADING;
            if (NAMES.containsKey(uuid)) {
                Future<class_2561> future = NAMES.get(uuid);
                if (future.isDone()) {
                    name = (class_2561)Futures.getUnchecked(future);
                }
            } else {
                NAMES.put(uuid, this.requestOwner(uuid));
            }
            if (name != UNKNOWN && name != LOADING || !config.getBoolean(Options.PET_HIDE_UNKNOWN_OWNER)) {
                tooltip.addLine(new PairComponent(KEY, name));
            }
        }
    }

    @Override
    public void appendData(IDataWriter data, IServerAccessor<class_1297> accessor, IPluginConfig config) {
        UUID uuid;
        if (config.getBoolean(Options.PET_OWNER) && (uuid = ((class_6025)accessor.getTarget()).method_6139()) != null) {
            data.raw().method_25927("owner", uuid);
        }
    }

    private Future<class_2561> requestOwner(UUID uuid) {
        return ((CompletableFuture)HTTP.get().sendAsync(HttpRequest.newBuilder().uri(URI.create("https://sessionserver.mojang.com/session/minecraft/profile/" + String.valueOf(uuid))).GET().build(), HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8)).thenApplyAsync(res -> {
            String nameStr;
            JsonObject object;
            JsonElement element = JsonParser.parseString((String)((String)res.body()));
            if (element.isJsonObject() && (object = element.getAsJsonObject()).has("name") && (element = object.get("name")).isJsonPrimitive() && !(nameStr = element.getAsString()).isBlank()) {
                return class_2561.method_43470((String)nameStr);
            }
            return UNKNOWN;
        })).handle((component, throwable) -> {
            if (component != null) {
                return component;
            }
            if (throwable != null) {
                throwable.printStackTrace();
            }
            return UNKNOWN;
        });
    }

    static {
        HTTP = Suppliers.memoize(HttpClient::newHttpClient);
        NAMES = new HashMap<UUID, Future<class_2561>>();
        UNKNOWN = class_2561.method_43470((String)"???");
        LOADING = class_2561.method_43471((String)"tooltip.waila.owner.loading").method_27692(class_124.field_1056);
        KEY = class_2561.method_43471((String)"tooltip.waila.owner");
    }
}

