/*
 * Decompiled with CFR 0.152.
 */
package org.thinkingstudio.obsidianui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8666;
import org.jetbrains.annotations.Nullable;
import org.thinkingstudio.obsidianui.Position;
import org.thinkingstudio.obsidianui.Tooltip;
import org.thinkingstudio.obsidianui.Tooltipable;
import org.thinkingstudio.obsidianui.widget.AbstractSpruceWidget;
import org.thinkingstudio.obsidianui.wrapper.VanillaButtonWrapper;

public abstract class AbstractSpruceButtonWidget
extends AbstractSpruceWidget
implements Tooltipable {
    private class_2561 message;
    private class_2561 tooltip;
    private int tooltipTicks;
    private long lastTick;
    protected float alpha = 1.0f;
    protected static final class_8666 BUTTON_TEXTURES = new class_8666(class_2960.method_60656((String)"widget/button"), class_2960.method_60656((String)"widget/button_disabled"), class_2960.method_60656((String)"widget/button_highlighted"));

    public AbstractSpruceButtonWidget(Position position, int width, int height, class_2561 message) {
        super(position);
        this.width = width;
        this.height = height;
        this.message = message;
    }

    public class_2561 getMessage() {
        return this.message;
    }

    public void setMessage(class_2561 message) {
        this.message = message;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float value) {
        this.alpha = value;
    }

    @Override
    public Optional<class_2561> getTooltip() {
        return Optional.ofNullable(this.tooltip);
    }

    @Override
    public void setTooltip(@Nullable class_2561 tooltip) {
        this.tooltip = tooltip;
    }

    public VanillaButtonWrapper asVanilla() {
        return new VanillaButtonWrapper(this);
    }

    protected boolean isValidClickButton(int button) {
        return button == 0;
    }

    @Override
    protected boolean onMouseClick(double mouseX, double mouseY, int button) {
        if (this.isValidClickButton(button)) {
            this.onClick(mouseX, mouseY);
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseRelease(double mouseX, double mouseY, int button) {
        if (this.isValidClickButton(button)) {
            this.onRelease(mouseX, mouseY);
            return true;
        }
        return false;
    }

    @Override
    protected boolean onMouseDrag(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isValidClickButton(button)) {
            this.onDrag(mouseX, mouseY, deltaX, deltaY);
            return true;
        }
        return false;
    }

    protected void onClick(double mouseX, double mouseY) {
    }

    protected void onRelease(double mouseX, double mouseY) {
    }

    protected void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
    }

    protected class_2960 getTexture() {
        return BUTTON_TEXTURES.method_52729(this.isActive(), this.isFocusedOrHovered());
    }

    @Override
    protected void renderWidget(class_332 drawContext, int mouseX, int mouseY, float delta) {
        this.renderButton(drawContext, mouseX, mouseY, delta);
        if (!this.dragging) {
            Tooltip.queueFor(this, mouseX, mouseY, this.tooltipTicks, i -> {
                this.tooltipTicks = i;
            }, this.lastTick, i -> {
                this.lastTick = i;
            });
        }
    }

    protected void renderButton(class_332 drawContext, int mouseX, int mouseY, float delta) {
        int color = this.active ? 0xFFFFFF : 0xA0A0A0;
        drawContext.method_27534(this.client.field_1772, this.getMessage(), this.getX() + this.getWidth() / 2, this.getY() + (this.getHeight() - 8) / 2, color | class_3532.method_15386((float)(this.alpha * 255.0f)) << 24);
    }

    @Override
    protected void renderBackground(class_332 drawContext, int mouseX, int mouseY, float delta) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.getAlpha());
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        drawContext.method_52706(this.getTexture(), this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    @Override
    @Nullable
    protected class_2561 getNarrationMessage() {
        return class_2561.method_43469((String)"gui.narrate.button", (Object[])new Object[]{this.getMessage()});
    }

    protected class_2561 getNarrationFocusedUsageMessage() {
        return class_2561.method_43471((String)"narration.button.usage.focused");
    }

    protected class_2561 getNarrationHoveredUsageMessage() {
        return class_2561.method_43471((String)"narration.button.usage.hovered");
    }

    @Override
    public void method_37020(class_6382 builder) {
        super.method_37020(builder);
        if (this.isActive()) {
            if (this.method_25370()) {
                builder.method_37034(class_6381.field_33791, this.getNarrationFocusedUsageMessage());
            } else {
                builder.method_37034(class_6381.field_33791, this.getNarrationHoveredUsageMessage());
            }
        }
        this.getTooltip().ifPresent(text -> builder.method_37034(class_6381.field_33790, text));
    }
}

