/*
 * Decompiled with CFR 0.152.
 */
package org.thinkingstudio.obsidianui.widget.container;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;
import org.thinkingstudio.obsidianui.Position;
import org.thinkingstudio.obsidianui.background.Background;
import org.thinkingstudio.obsidianui.background.TransparentBackground;
import org.thinkingstudio.obsidianui.border.Border;
import org.thinkingstudio.obsidianui.border.EmptyBorder;
import org.thinkingstudio.obsidianui.navigation.NavigationDirection;
import org.thinkingstudio.obsidianui.util.ScissorManager;
import org.thinkingstudio.obsidianui.widget.AbstractSpruceWidget;
import org.thinkingstudio.obsidianui.widget.WithBackground;
import org.thinkingstudio.obsidianui.widget.WithBorder;
import org.thinkingstudio.obsidianui.widget.container.AbstractSpruceParentWidget;

public abstract class SpruceEntryListWidget<E extends Entry>
extends AbstractSpruceParentWidget<E>
implements WithBackground,
WithBorder {
    protected final Position anchor = Position.of(this, 0, 0);
    private final List<E> entries = new Entries();
    private final int anchorYOffset;
    private double scrollAmount;
    private Background background = TransparentBackground.NORMAL;
    private boolean renderTransition = true;
    private Border border = EmptyBorder.EMPTY_BORDER;
    private boolean scrolling = false;
    private boolean allowOutsideHorizontalNavigation = false;

    public SpruceEntryListWidget(Position position, int width, int height, int anchorYOffset, Class<E> entryClass) {
        super(position, entryClass);
        this.width = width;
        this.height = height;
        this.anchorYOffset = anchorYOffset;
        this.anchor.setRelativeY(anchorYOffset);
    }

    public int getInnerWidth() {
        int width = this.getWidth();
        if (this.getMaxScroll() > 0) {
            width -= 6;
        }
        return width -= this.getBorder().getThickness() * 2;
    }

    @Override
    public Background getBackground() {
        return this.background;
    }

    @Override
    public void setBackground(Background background) {
        this.background = background;
    }

    public boolean shouldRenderTransition() {
        return this.renderTransition;
    }

    public void setRenderTransition(boolean render) {
        this.renderTransition = render;
    }

    @Override
    public Border getBorder() {
        return this.border;
    }

    @Override
    public void setBorder(Border border) {
        this.border = border;
        this.anchor.setRelativeX(border.getThickness());
        if (this.anchor.getRelativeY() == this.anchorYOffset && this.hasBorder()) {
            this.anchor.setRelativeY(this.anchorYOffset + border.getThickness());
        }
    }

    public boolean doesAllowOutsideHorizontalNavigation() {
        return this.allowOutsideHorizontalNavigation;
    }

    public void setAllowOutsideHorizontalNavigation(boolean allowOutsideHorizontalNavigation) {
        this.allowOutsideHorizontalNavigation = allowOutsideHorizontalNavigation;
    }

    protected int getLengthUntil(int index) {
        int max = 0;
        for (int i = 0; i <= index; ++i) {
            max += ((Entry)this.entries.get(i)).getHeight();
        }
        return max;
    }

    public int getMaxPosition() {
        return this.getLengthUntil(this.getEntriesCount() - 1);
    }

    private void scroll(int amount) {
        this.setScrollAmount(this.getScrollAmount() + (double)amount);
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(double amount) {
        this.scrollAmount = class_3532.method_15350((double)amount, (double)0.0, (double)this.getMaxScroll());
        this.anchor.setRelativeY((int)((double)(this.anchorYOffset + this.getBorder().getThickness()) - this.scrollAmount));
        Iterator<E> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry entry;
            entry.setVisibleInList((entry = (Entry)iterator.next()).getY() + entry.getHeight() >= this.getY() && entry.getY() <= this.getY() + this.getHeight());
        }
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - this.getHeight() + 8);
    }

    protected int getScrollbarPositionX() {
        return this.getX() + this.getWidth() - 6 - this.getBorder().getThickness();
    }

    @Override
    public List<E> children() {
        return this.entries;
    }

    protected final void clearEntries() {
        this.setFocused(null);
        this.entries.clear();
    }

    protected void replaceEntries(Collection<E> newEntries) {
        Entry oldFocused = (Entry)this.getFocused();
        this.entries.clear();
        this.entries.addAll(newEntries);
        if (!newEntries.contains(oldFocused)) {
            this.setFocused(null);
        }
    }

    @Nullable
    protected E getEntry(int index) {
        return (E)((Entry)this.children().get(index));
    }

    protected int addEntry(E entry) {
        this.entries.add(entry);
        return this.entries.size() - 1;
    }

    protected boolean removeEntry(E entry) {
        if (this.getFocused() == entry) {
            this.refocusOnRemoval(entry);
        }
        return this.entries.remove(entry);
    }

    protected void refocusOnRemoval(E focused) {
        int i = this.entries.indexOf(focused);
        if (i == -1) {
            return;
        }
        int newIndex = i - 1;
        if (newIndex < 0) {
            newIndex = i;
        }
        if (this.getEntriesCount() == newIndex - 1) {
            this.setFocused(null);
        } else {
            this.setFocused(this.getEntry(newIndex));
        }
    }

    protected int getEntriesCount() {
        return this.children().size();
    }

    protected void ensureVisible(E entry) {
        int k;
        int index = this.children().indexOf(entry);
        int rowTop = this.getRowTop(index);
        int j = rowTop - this.getY() - ((AbstractSpruceWidget)entry).getHeight() - 8;
        if (j < 0) {
            this.scroll(j);
        }
        int nextHeight = 0;
        if (index < this.getEntriesCount() - 1) {
            nextHeight = ((Entry)this.children().get(index + 1)).getHeight();
        }
        if ((k = this.getY() + this.getHeight() - rowTop - ((AbstractSpruceWidget)entry).getHeight() + nextHeight) < 0) {
            this.scroll(-k);
        }
    }

    protected int getRowTop(int index) {
        return this.getY() + 4 - (int)this.getScrollAmount() + this.getLengthUntil(index);
    }

    @Override
    protected void setOwnerShip(E entry) {
        ((AbstractSpruceWidget)entry).getPosition().setAnchor(this.anchor);
        ((Entry)entry).setVisibleInList(entry.getY() + ((AbstractSpruceWidget)entry).getHeight() >= this.getY() && entry.getY() <= this.getY() + this.getHeight());
    }

    @Override
    public boolean onNavigation(NavigationDirection direction, boolean tab) {
        if (this.requiresCursor()) {
            return false;
        }
        if (direction.isHorizontal() && this.getFocused() != null) {
            boolean result = ((Entry)this.getFocused()).onNavigation(direction, tab);
            return !this.allowOutsideHorizontalNavigation || result;
        }
        boolean result = super.onNavigation(direction, tab);
        if (result) {
            this.ensureVisible((Entry)this.getFocused());
        }
        return result;
    }

    @Override
    protected boolean onMouseClick(double mouseX, double mouseY, int button) {
        this.scrolling = button == 0 && mouseX >= (double)this.getScrollbarPositionX() && mouseX < (double)(this.getScrollbarPositionX() + 6);
        return super.onMouseClick(mouseX, mouseY, button) || this.scrolling;
    }

    @Override
    protected boolean onMouseDrag(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.onMouseDrag(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (button == 0 && this.scrolling) {
            if (mouseY < (double)this.getY()) {
                this.setScrollAmount(0.0);
            } else if (mouseY > (double)(this.getY() + this.getHeight())) {
                this.setScrollAmount(this.getMaxScroll());
            } else {
                double d = Math.max(1, this.getMaxScroll());
                int height = this.height;
                int j = class_3532.method_15340((int)((int)((float)(height * height) / (float)this.getMaxPosition())), (int)32, (int)(height - 8));
                double e = Math.max(1.0, d / (double)(height - j));
                this.setScrollAmount(this.getScrollAmount() + deltaY * e);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean onMouseScroll(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (super.onMouseScroll(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        this.setScrollAmount(this.getScrollAmount() - scrollY * ((double)this.getMaxPosition() / (double)this.getEntriesCount()) / 2.0);
        return true;
    }

    @Override
    protected void renderBackground(class_332 drawContext, int mouseX, int mouseY, float delta) {
        this.getBackground().render(drawContext, this, 0, mouseX, mouseY, delta);
    }

    protected class_2960 getSeparatorTexture(boolean header) {
        boolean isIngame;
        boolean bl = isIngame = this.client.field_1687 != null;
        if (header) {
            return isIngame ? class_437.field_49897 : class_437.field_49895;
        }
        return isIngame ? class_437.field_49898 : class_437.field_49896;
    }

    @Override
    protected void renderWidget(class_332 drawContext, int mouseX, int mouseY, float delta) {
        int maxScroll;
        int scrollbarPositionX = this.getScrollbarPositionX();
        int scrollBarEnd = scrollbarPositionX + 6;
        int left = this.getX();
        int right = left + this.getWidth();
        int top = this.getY();
        int bottom = top + this.getHeight();
        ScissorManager.push(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        this.entries.forEach(e -> e.method_25394(drawContext, mouseX, mouseY, delta));
        ScissorManager.pop();
        RenderSystem.enableBlend();
        if (this.shouldRenderTransition()) {
            class_2960 topTexture = this.getSeparatorTexture(true);
            class_2960 bottomTexture = this.getSeparatorTexture(false);
            drawContext.method_25290(topTexture, left, top - 2, 0.0f, 0.0f, this.getWidth(), 2, 32, 2);
            drawContext.method_25290(bottomTexture, left, bottom, 0.0f, 0.0f, this.getWidth(), 2, 32, 2);
            int screenWidth = this.client.method_22683().method_4486();
            if (left > 0) {
                drawContext.method_25290(topTexture, left - 1, top - 1, 0.0f, 0.0f, 1, this.getHeight() + 2, 1, (this.getHeight() + 2) * 2);
            }
            if (right < screenWidth) {
                drawContext.method_25290(topTexture, right, top - 1, 0.0f, 0.0f, 1, this.getHeight() + 2, 1, (this.getHeight() + 2) * 2);
            }
        }
        if ((maxScroll = this.getMaxScroll()) > 0) {
            class_289 tessellator = class_289.method_1348();
            int scrollbarHeight = (int)((float)(this.getHeight() * this.getHeight()) / (float)this.getMaxPosition());
            scrollbarHeight = class_3532.method_15340((int)scrollbarHeight, (int)32, (int)(this.getHeight() - 8));
            int scrollbarY = (int)this.getScrollAmount() * (this.getHeight() - scrollbarHeight) / maxScroll + this.getY();
            if (scrollbarY < this.getY()) {
                scrollbarY = this.getY();
            }
            this.renderScrollbar(tessellator, scrollbarPositionX, scrollBarEnd, scrollbarY, scrollbarHeight);
        }
        this.getBorder().render(drawContext, this, mouseX, mouseY, delta);
        RenderSystem.disableBlend();
    }

    protected void renderScrollbar(class_289 tessellator, int scrollbarX, int scrollbarEndX, int scrollbarY, int scrollbarHeight) {
        RenderSystem.setShader(class_757::method_34540);
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        buffer.method_22912((float)scrollbarX, (float)(this.getY() + this.getHeight()), 0.0f).method_1336(0, 0, 0, 255);
        buffer.method_22912((float)scrollbarEndX, (float)(this.getY() + this.getHeight()), 0.0f).method_1336(0, 0, 0, 255);
        buffer.method_22912((float)scrollbarEndX, (float)this.getY(), 0.0f).method_1336(0, 0, 0, 255);
        buffer.method_22912((float)scrollbarX, (float)this.getY(), 0.0f).method_1336(0, 0, 0, 255);
        buffer.method_22912((float)scrollbarX, (float)(scrollbarY + scrollbarHeight), 0.0f).method_1336(128, 128, 128, 255);
        buffer.method_22912((float)scrollbarEndX, (float)(scrollbarY + scrollbarHeight), 0.0f).method_1336(128, 128, 128, 255);
        buffer.method_22912((float)scrollbarEndX, (float)scrollbarY, 0.0f).method_1336(128, 128, 128, 255);
        buffer.method_22912((float)scrollbarX, (float)scrollbarY, 0.0f).method_1336(128, 128, 128, 255);
        buffer.method_22912((float)scrollbarX, (float)(scrollbarY + scrollbarHeight - 1), 0.0f).method_1336(192, 192, 192, 255);
        buffer.method_22912((float)(scrollbarEndX - 1), (float)(scrollbarY + scrollbarHeight - 1), 0.0f).method_1336(192, 192, 192, 255);
        buffer.method_22912((float)(scrollbarEndX - 1), (float)scrollbarY, 0.0f).method_1336(192, 192, 192, 255);
        buffer.method_22912((float)scrollbarX, (float)scrollbarY, 0.0f).method_1336(192, 192, 192, 255);
        class_286.method_43433((class_9801)buffer.method_60800());
    }

    protected void appendPositionNarrations(class_6382 builder, E entry) {
        int i;
        List<E> list = this.children();
        if (list.size() > 1 && (i = list.indexOf(entry)) != -1) {
            builder.method_37034(class_6381.field_33789, (class_2561)class_2561.method_43469((String)"narrator.position.list", (Object[])new Object[]{i + 1, list.size()}));
        }
    }

    @Environment(value=EnvType.CLIENT)
    class Entries
    extends AbstractList<E> {
        private final List<E> entries = Lists.newArrayList();

        private Entries() {
        }

        @Override
        public E get(int i) {
            return (Entry)this.entries.get(i);
        }

        @Override
        public int size() {
            return this.entries.size();
        }

        @Override
        public E set(int i, E entry) {
            Entry entry2 = (Entry)this.entries.set(i, entry);
            this.recomputePositions();
            SpruceEntryListWidget.this.setOwnerShip(entry);
            return entry2;
        }

        @Override
        public void add(int i, E entry) {
            this.entries.add(i, entry);
            this.recomputePositions();
            SpruceEntryListWidget.this.setOwnerShip(entry);
        }

        @Override
        public E remove(int i) {
            Entry result = (Entry)this.entries.remove(i);
            this.recomputePositions();
            return result;
        }

        private void recomputePositions() {
            int y = 0;
            for (Entry entry : this.entries) {
                entry.getPosition().setRelativeY(y);
                y += entry.getHeight();
            }
        }
    }

    public static abstract class Entry
    extends AbstractSpruceWidget {
        private boolean visibleInList = false;

        public Entry() {
            super(Position.origin());
        }

        protected void setVisibleInList(boolean visible) {
            this.visibleInList = visible;
        }

        @Override
        public boolean isVisible() {
            return super.isVisible() && this.visibleInList;
        }
    }
}

