/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.net;

import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3532;
import net.minecraft.class_8710;
import nl.enjarai.doabarrelroll.api.RollEntity;
import nl.enjarai.doabarrelroll.api.event.ServerEvents;
import nl.enjarai.doabarrelroll.config.ModConfigServer;
import nl.enjarai.doabarrelroll.net.HandshakeServer;
import nl.enjarai.doabarrelroll.net.ServerConfigHolder;
import nl.enjarai.doabarrelroll.net.packet.ConfigResponseC2SPacket;
import nl.enjarai.doabarrelroll.net.packet.ConfigResponseC2SPacketImpl;
import nl.enjarai.doabarrelroll.net.packet.ConfigSyncS2CPacketImpl;
import nl.enjarai.doabarrelroll.net.packet.ConfigUpdateAckS2CPacketImpl;
import nl.enjarai.doabarrelroll.net.packet.ConfigUpdateC2SPacket;
import nl.enjarai.doabarrelroll.net.packet.ConfigUpdateC2SPacketImpl;
import nl.enjarai.doabarrelroll.net.packet.RollSyncC2SPacketImpl;
import nl.enjarai.doabarrelroll.net.packet.RollSyncS2CPacketImpl;

public class ServerNetworking {
    public static final ServerConfigHolder<ConfigUpdateAckS2CPacketImpl> CONFIG_HOLDER = new ServerConfigHolder<ConfigUpdateAckS2CPacketImpl>(FabricLoader.getInstance().getConfigDir().resolve("do_a_barrel_roll-server.json"), ModConfigServer.CODEC, ConfigUpdateAckS2CPacketImpl::new, ServerEvents::updateServerConfig);
    public static final HandshakeServer<ConfigSyncS2CPacketImpl> HANDSHAKE_SERVER = new HandshakeServer<ConfigSyncS2CPacketImpl>(ConfigSyncS2CPacketImpl::new, CONFIG_HOLDER, player -> !ModConfigServer.canModify(player));

    public static void init() {
        CONFIG_HOLDER.setHandshakeServer(HANDSHAKE_SERVER);
        PayloadTypeRegistry.playC2S().register(ConfigResponseC2SPacketImpl.PACKET_ID, ConfigResponseC2SPacketImpl.PACKET_CODEC);
        PayloadTypeRegistry.playC2S().register(ConfigUpdateC2SPacketImpl.PACKET_ID, ConfigUpdateC2SPacketImpl.PACKET_CODEC);
        PayloadTypeRegistry.playC2S().register(RollSyncC2SPacketImpl.PACKET_ID, RollSyncC2SPacketImpl.PACKET_CODEC);
        PayloadTypeRegistry.playS2C().register(ConfigSyncS2CPacketImpl.PACKET_ID, ConfigSyncS2CPacketImpl.PACKET_CODEC);
        PayloadTypeRegistry.playS2C().register(ConfigUpdateAckS2CPacketImpl.PACKET_ID, ConfigUpdateAckS2CPacketImpl.PACKET_CODEC);
        PayloadTypeRegistry.playS2C().register(RollSyncS2CPacketImpl.PACKET_ID, RollSyncS2CPacketImpl.PACKET_CODEC);
        ServerPlayNetworking.registerGlobalReceiver(ConfigResponseC2SPacketImpl.PACKET_ID, (payload, context) -> {
            HandshakeServer.HandshakeState reply = HANDSHAKE_SERVER.clientReplied(context.player().field_13987, (ConfigResponseC2SPacket)payload);
            if (reply == HandshakeServer.HandshakeState.RESEND) {
                ServerNetworking.sendHandshake(context.player());
            } else if (reply == HandshakeServer.HandshakeState.ACCEPTED) {
                ServerPlayNetworking.registerReceiver((class_3244)context.player().field_13987, RollSyncC2SPacketImpl.PACKET_ID, (payload1, context1) -> {
                    RollEntity rollPlayer = (RollEntity)context1.player();
                    boolean isRolling = payload1.rolling();
                    float roll = payload1.roll();
                    rollPlayer.doABarrelRoll$setRolling(isRolling);
                    rollPlayer.doABarrelRoll$setRoll(isRolling ? class_3532.method_15393((float)roll) : 0.0f);
                });
                ServerPlayNetworking.registerReceiver((class_3244)context.player().field_13987, ConfigUpdateC2SPacketImpl.PACKET_ID, (payload1, context1) -> context1.responseSender().sendPacket((class_8710)CONFIG_HOLDER.clientSendsUpdate(context1.player(), (ConfigUpdateC2SPacket)payload1)));
            }
        });
        ServerEvents.SERVER_CONFIG_UPDATE.register((server, config) -> {
            for (class_3222 player : server.method_3760().method_14571()) {
                ServerNetworking.sendHandshake(player);
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> HANDSHAKE_SERVER.playerDisconnected(handler));
        ServerTickEvents.END_SERVER_TICK.register(HANDSHAKE_SERVER::tick);
    }

    public static void sendHandshake(class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)HANDSHAKE_SERVER.initiateConfigSync(player.field_13987));
        HANDSHAKE_SERVER.configSentToClient(player.field_13987);
    }

    public static void sendRollUpdates(class_1297 entity) {
        RollEntity rollEntity = (RollEntity)entity;
        boolean isRolling = rollEntity.doABarrelRoll$isRolling();
        float roll = rollEntity.doABarrelRoll$getRoll();
        RollSyncS2CPacketImpl payload = new RollSyncS2CPacketImpl(entity.method_5628(), isRolling, roll);
        PlayerLookup.tracking((class_1297)entity).stream().filter(player -> player != entity).filter(player -> ServerNetworking.HANDSHAKE_SERVER.getHandshakeState((class_3222)player).state == HandshakeServer.HandshakeState.ACCEPTED).forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_8710)payload));
    }
}

