/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;

public class OverlayRendererSpawnableColumnHeights
extends OverlayRendererBase {
    private static final Set<Long> DIRTY_CHUNKS = new HashSet<Long>();
    private final class_2338.class_2339 posMutable = new class_2338.class_2339();
    private long lastCheckTime;

    @Override
    public String getName() {
        return "OverlayRendererSpawnableColumnHeights";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markChunkChanged(int cx, int cz) {
        if (RendererToggle.OVERLAY_SPAWNABLE_COLUMN_HEIGHTS.getBooleanValue()) {
            Set<Long> set = DIRTY_CHUNKS;
            synchronized (set) {
                DIRTY_CHUNKS.add(class_1923.method_8331((int)cx, (int)cz));
            }
        }
    }

    @Override
    public boolean shouldRender(class_310 mc) {
        return RendererToggle.OVERLAY_SPAWNABLE_COLUMN_HEIGHTS.getBooleanValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean needsUpdate(class_1297 entity, class_310 mc) {
        int ex = (int)Math.floor(entity.method_23317());
        int ez = (int)Math.floor(entity.method_23321());
        int lx = this.lastUpdatePos.method_10263();
        int lz = this.lastUpdatePos.method_10260();
        if (Math.abs(lx - ex) > 8 || Math.abs(lz - ez) > 8) {
            return true;
        }
        if (System.currentTimeMillis() - this.lastCheckTime > 1000L) {
            int radius = class_3532.method_15340((int)Configs.Generic.SPAWNABLE_COLUMNS_OVERLAY_RADIUS.getIntegerValue(), (int)0, (int)128);
            int xStart = (int)entity.method_23317() - radius >> 4;
            int zStart = (int)entity.method_23321() - radius >> 4;
            int xEnd = (int)entity.method_23317() + radius >> 4;
            int zEnd = (int)entity.method_23321() + radius >> 4;
            Set<Long> set = DIRTY_CHUNKS;
            synchronized (set) {
                for (int cx = xStart; cx <= xEnd; ++cx) {
                    for (int cz = zStart; cz <= zEnd; ++cz) {
                        if (!DIRTY_CHUNKS.contains(class_1923.method_8331((int)cx, (int)cz))) continue;
                        return true;
                    }
                }
            }
            this.lastCheckTime = System.currentTimeMillis();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(class_243 cameraPos, class_1297 entity, class_310 mc) {
        Color4f color = Configs.Colors.SPAWNABLE_COLUMNS_OVERLAY_COLOR.getColor();
        int radius = class_3532.method_15340((int)Configs.Generic.SPAWNABLE_COLUMNS_OVERLAY_RADIUS.getIntegerValue(), (int)0, (int)128);
        int xStart = (int)entity.method_23317() - radius;
        int zStart = (int)entity.method_23321() - radius;
        int xEnd = (int)entity.method_23317() + radius;
        int zEnd = (int)entity.method_23321() + radius;
        class_638 world = mc.field_1687;
        RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
        RenderObjectBase renderLines = (RenderObjectBase)this.renderObjects.get(1);
        BUFFER_1 = TESSELLATOR_1.method_60827(renderQuads.getGlMode(), class_290.field_1576);
        BUFFER_2 = TESSELLATOR_2.method_60827(renderLines.getGlMode(), class_290.field_1576);
        for (int x = xStart; x <= xEnd; ++x) {
            double minX = (double)x + 0.25 - cameraPos.field_1352;
            double maxX = minX + 0.5;
            for (int z = zStart; z <= zEnd; ++z) {
                int height = world.method_8500((class_2338)this.posMutable.method_10103(x, 0, z)).method_12005(class_2902.class_2903.field_13202, x, z) + 1;
                double minY = (double)height - cameraPos.field_1351;
                double maxY = minY + 0.09375;
                double minZ = (double)z + 0.25 - cameraPos.field_1350;
                double maxZ = minZ + 0.5;
                RenderUtils.drawBoxHorizontalSidesBatchedQuads((float)((float)minX), (float)((float)minY), (float)((float)minZ), (float)((float)maxX), (float)((float)maxY), (float)((float)maxZ), (Color4f)color, (class_287)BUFFER_1);
                RenderUtils.drawBoxTopBatchedQuads((float)((float)minX), (float)((float)minZ), (float)((float)maxX), (float)((float)maxY), (float)((float)maxZ), (Color4f)color, (class_287)BUFFER_1);
                RenderUtils.drawBoxAllEdgesBatchedLines((float)((float)minX), (float)((float)minY), (float)((float)minZ), (float)((float)maxX), (float)((float)maxY), (float)((float)maxZ), (Color4f)color, (class_287)BUFFER_2);
            }
        }
        renderQuads.uploadData(BUFFER_1);
        renderLines.uploadData(BUFFER_2);
        this.lastCheckTime = System.currentTimeMillis();
        Set<Long> set = DIRTY_CHUNKS;
        synchronized (set) {
            DIRTY_CHUNKS.clear();
        }
    }
}

