/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.IntFunction;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.__internal__.IExtraService;
import mcp.mobius.waila.api.data.BuiltinDataUtil;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public abstract class ItemData
implements IData {
    public static final class_2960 ID = BuiltinDataUtil.rl("item");
    public static final IData.Type<ItemData> TYPE = IData.createType(ID);
    public static final class_2960 CONFIG_SYNC_NBT = BuiltinDataUtil.rl("item.nbt");
    public static final class_2960 CONFIG_DISPLAY_MODE = BuiltinDataUtil.rl("item.display_mode");
    public static final class_2960 CONFIG_MAX_HEIGHT = BuiltinDataUtil.rl("item.max_height");
    public static final class_2960 CONFIG_SORT_BY_COUNT = BuiltinDataUtil.rl("item.sort_by_count");
    protected final ArrayList<class_1799> items = new ArrayList();

    public static ItemData of(IPluginConfig config) {
        return IExtraService.INSTANCE.createItemData(config);
    }

    public ItemData vanilla(class_1263 container) {
        int size = container.method_5439();
        this.ensureSpace(size);
        for (int i = 0; i < size; ++i) {
            this.items.add(container.method_5438(i));
        }
        return this;
    }

    public ItemData getter(IntFunction<class_1799> getter, int size) {
        this.ensureSpace(size);
        for (int i = 0; i < size; ++i) {
            this.items.add(getter.apply(i));
        }
        return this;
    }

    public ItemData add(class_1799 stack) {
        this.items.add(stack);
        return this;
    }

    public ItemData add(class_1799 ... stacks) {
        this.ensureSpace(stacks.length);
        Collections.addAll(this.items, stacks);
        return this;
    }

    public ItemData add(Collection<class_1799> stacks) {
        this.items.addAll(stacks);
        return this;
    }

    public ItemData ensureSpace(int length) {
        this.items.ensureCapacity(this.items.size() + length);
        return this;
    }

    public static enum ItemDisplayMode {
        GRID,
        LIST,
        DYNAMIC;

    }
}

