/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.config;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IJsonConfig;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.config.ConfigEntry;
import mcp.mobius.waila.config.commenter.CommenterFactories;
import mcp.mobius.waila.config.commenter.LanguageCommenter;
import mcp.mobius.waila.mcless.config.ConfigIo;
import mcp.mobius.waila.util.Log;
import net.minecraft.class_2960;

public enum PluginConfig implements IPluginConfig
{
    CLIENT,
    SERVER;

    private static final Log LOG;
    private static final Path PATH;
    private static final Supplier<IJsonConfig.Commenter> COMMENTER;
    private static final ConfigIo<Map<String, Map<String, JsonElement>>> IO;
    private static final Map<class_2960, ConfigEntry<Object>> CONFIGS;

    public static <T> void addConfig(ConfigEntry<T> entry) {
        CONFIGS.put(entry.getId(), entry);
    }

    private static Stream<class_2960> getKeyStream() {
        return CONFIGS.keySet().stream().filter(it -> PluginConfig.getEntry(it).getOrigin().isEnabled());
    }

    public static Set<class_2960> getAllKeys(String namespace) {
        return PluginConfig.getKeyStream().filter(id -> id.method_12836().equals(namespace)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Set<class_2960> getAllKeys() {
        return PluginConfig.getKeyStream().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Set<ConfigEntry<Object>> getSyncableConfigs() {
        return CONFIGS.values().stream().filter(ConfigEntry::isSynced).collect(Collectors.toSet());
    }

    public static List<String> getNamespaces() {
        return CONFIGS.keySet().stream().map(class_2960::method_12836).distinct().sorted((o1, o2) -> o1.equals("waila") ? -1 : (o2.equals("waila") ? 1 : o1.compareToIgnoreCase((String)o2))).collect(Collectors.toList());
    }

    public static <T> ConfigEntry<T> getEntry(class_2960 key) {
        return CONFIGS.get(key);
    }

    public static <T> void set(class_2960 key, T value) {
        ConfigEntry<Object> entry = CONFIGS.get(key);
        if (entry != null) {
            entry.setLocalValue(value);
        }
    }

    public static void reload() {
        if (!Files.exists(PATH, new LinkOption[0]) && !IO.migrateJson5(PATH)) {
            PluginConfig.write();
        }
        Map<String, Map<String, JsonElement>> config = IO.read(PATH);
        config.forEach((namespace, subMap) -> subMap.forEach((path, value) -> {
            ConfigEntry<Object> entry = CONFIGS.get(class_2960.method_60655((String)namespace, (String)path));
            if (entry != null) {
                try {
                    entry.setLocalValue(entry.getType().parser.apply((JsonElement)value, (JsonElement)entry.getDefaultValue()));
                }
                catch (Throwable throwable) {
                    entry.setLocalValue(entry.getDefaultValue());
                    LOG.error("Failed to parse config value for {}: {}, defaulting.", (Object)entry.getId(), (Object)throwable);
                }
            }
        }));
        PluginConfig.write();
        LOG.info("Plugin config reloaded");
    }

    public static void write() {
        LinkedHashMap<String, Map> config = new LinkedHashMap<String, Map>();
        for (ConfigEntry<Object> entry : CONFIGS.values()) {
            if (entry.isAlias()) continue;
            class_2960 id = entry.getId();
            config.computeIfAbsent(id.method_12836(), k -> new LinkedHashMap()).put(id.method_12832(), entry.getType().serializer.apply(entry.getLocalValue()));
        }
        IO.write(PATH, config);
    }

    private <T> T getValue(class_2960 key, T defaultValue) {
        ConfigEntry<Object> entry = CONFIGS.get(key);
        if (entry != null && entry.getOrigin().isEnabled()) {
            return (T)entry.getValue(this == SERVER);
        }
        if (Waila.DEV) {
            LOG.error("Unknown plugin config key {}", (Object)key);
        }
        return defaultValue;
    }

    @Override
    public Set<class_2960> getKeys() {
        return PluginConfig.getAllKeys();
    }

    @Override
    public Set<class_2960> getKeys(String namespace) {
        return PluginConfig.getAllKeys(namespace);
    }

    @Override
    public boolean getBoolean(class_2960 key) {
        return this.getValue(key, false);
    }

    @Override
    public int getInt(class_2960 key) {
        return this.getValue(key, 0);
    }

    @Override
    public double getDouble(class_2960 key) {
        return this.getValue(key, 0.0);
    }

    @Override
    public String getString(class_2960 key) {
        return this.getValue(key, "");
    }

    @Override
    public <T extends Enum<T>> T getEnum(class_2960 key) {
        return (T)((Enum)this.getValue(key, null));
    }

    static {
        LOG = Log.create();
        PATH = Waila.CONFIG_DIR.resolve("waila/waila_plugins.json5");
        COMMENTER = () -> new LanguageCommenter((translation, p) -> {
            if (p.size() < 2) {
                return null;
            }
            String namespace = (String)p.get(0);
            String path = (String)p.get(1);
            ConfigEntry entry = PluginConfig.getEntry(class_2960.method_60655((String)namespace, (String)path));
            ConfigEntry.Type type = entry.getType();
            StringBuilder sb = new StringBuilder();
            String tlKey = "config.waila.plugin_" + namespace + "." + path;
            sb.append((String)((Object)translation.getOrDefault(tlKey, tlKey)));
            String descKey = tlKey + "_desc";
            if (translation.containsKey(descKey)) {
                sb.append('\n').append((String)translation.get(descKey));
            }
            if (type.equals(ConfigEntry.PATH)) {
                sb.append("\nCustom config, open the following file\n").append(entry.getDefaultValue());
                return sb.toString();
            }
            if (entry.isServerRequired()) {
                sb.append("\nRequire server to have WTHIT installed, if not, will be locked to ").append(entry.getClientOnlyValue());
            } else if (entry.isMerged()) {
                sb.append("\nThis value will get merged with the value from the server");
            } else if (entry.isSynced()) {
                sb.append("\nThis value will get overridden by the server");
            }
            sb.append("\nDefault value: ").append(entry.getDefaultValue().toString());
            if (type.equals(ConfigEntry.ENUM)) {
                sb.append("\nAvailable values: ");
                Enum[] enums = (Enum[])((Enum)entry.getDefaultValue()).getDeclaringClass().getEnumConstants();
                sb.append(enums[0].name());
                for (int i = 1; i < enums.length; ++i) {
                    Enum anEnum = enums[i];
                    sb.append(", ").append(anEnum.name());
                }
            }
            return sb.toString();
        });
        IO = new ConfigIo<Map>(LOG::warn, LOG::error, true, new CommenterFactories(List.of(COMMENTER)), new GsonBuilder().setPrettyPrinting().create(), new TypeToken<Map<String, Map<String, JsonElement>>>(){}.getType(), LinkedHashMap::new);
        CONFIGS = new LinkedHashMap<class_2960, ConfigEntry<Object>>();
    }
}

