/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.harvest.tool;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import mcp.mobius.waila.api.__internal__.IApiService;
import mcp.mobius.waila.api.__internal__.Internals;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public final class ToolTier {
    public static final ToolTier NONE = Internals.unsafeAlloc(ToolTier.class);
    private static final Supplier<Map<class_2960, String>> VANILLA_TIER_TL_KEYS = Suppliers.memoize(() -> {
        HashMap<class_2960, String> map = new HashMap<class_2960, String>();
        for (class_1834 tier : class_1834.values()) {
            map.put(tier.method_58419().comp_327(), tier.name().toLowerCase(Locale.ROOT));
        }
        return map;
    });
    private static Supplier<Map<class_1832, ToolTier>> tiers;
    public final class_1832 tier;
    public final int index;
    public final class_6862<class_2248> incorrect;
    private final Supplier<String> tlKey;

    public ToolTier(class_1832 tier, int index) {
        this.tier = tier;
        this.index = index;
        this.incorrect = tier.method_58419();
        this.tlKey = Suppliers.memoize(() -> {
            String vanilla = VANILLA_TIER_TL_KEYS.get().get(this.incorrect.comp_327());
            String key = vanilla != null ? vanilla : this.incorrect.comp_327().method_42094();
            return "tooltip.waila.harvest.tier." + key;
        });
    }

    public static void resetMap() {
        tiers = Suppliers.memoize(() -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            List<class_1832> tiers = IApiService.INSTANCE.getTiers();
            for (int i = 0; i < tiers.size(); ++i) {
                class_1832 tier = tiers.get(i);
                builder.put((Object)tier, (Object)new ToolTier(tier, i));
            }
            return builder.build();
        });
    }

    public static Collection<ToolTier> all() {
        return tiers.get().values();
    }

    @Nullable
    public static ToolTier get(class_1832 tier) {
        return tiers.get().get(tier);
    }

    public String tlKey() {
        return this.tlKey.get();
    }

    public boolean isEqualTo(ToolTier other) {
        if (this == other) {
            return true;
        }
        if (this.tier == other.tier) {
            return true;
        }
        if (this.incorrect != null && other.incorrect != null) {
            return this.incorrect.comp_327().equals((Object)other.incorrect.comp_327());
        }
        return false;
    }

    public boolean isBetterThanOrEqualTo(ToolTier other) {
        return this.isEqualTo(other) || this.index >= other.index;
    }

    static {
        ToolTier.resetMap();
    }
}

